/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.NoSuchElementException;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.IntList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.lazy.primitive.AbstractLazyIntIterable;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

public class ReverseIntIterable
extends AbstractLazyIntIterable {
    private final IntList adapted;

    public ReverseIntIterable(IntList newAdapted) {
        this.adapted = newAdapted;
    }

    public static ReverseIntIterable adapt(IntList intList) {
        return new ReverseIntIterable(intList);
    }

    public IntIterator intIterator() {
        return new ReverseIntIterator();
    }

    public void each(IntProcedure procedure) {
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            procedure.value(iterator.next());
        }
    }

    public long sum() {
        return this.adapted.sum();
    }

    public int max() {
        return this.adapted.max();
    }

    public int min() {
        return this.adapted.min();
    }

    public int minIfEmpty(int defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.min();
    }

    public int maxIfEmpty(int defaultValue) {
        if (this.adapted.isEmpty()) {
            return defaultValue;
        }
        return this.adapted.max();
    }

    public double average() {
        return this.adapted.average();
    }

    public double median() {
        return this.adapted.median();
    }

    public int[] toSortedArray() {
        return this.adapted.toSortedArray();
    }

    public int[] toArray() {
        int[] results = new int[this.adapted.size()];
        int index = 0;
        IntIterator iterator = this.intIterator();
        while (iterator.hasNext()) {
            results[index] = iterator.next();
            ++index;
        }
        return results;
    }

    public boolean contains(int value) {
        return this.adapted.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.adapted.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.adapted.containsAll(source);
    }

    public int size() {
        return this.adapted.size();
    }

    public boolean isEmpty() {
        return this.adapted.isEmpty();
    }

    public boolean notEmpty() {
        return this.adapted.notEmpty();
    }

    public MutableIntList toList() {
        return IntArrayList.newList((IntIterable)this);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSet((IntIterable)this);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBag((IntIterable)this);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    private class ReverseIntIterator
    implements IntIterator {
        private int currentIndex;

        private ReverseIntIterator() {
            this.currentIndex = ReverseIntIterable.this.adapted.size() - 1;
        }

        public boolean hasNext() {
            return this.currentIndex != -1;
        }

        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int next = ReverseIntIterable.this.adapted.get(this.currentIndex);
            --this.currentIndex;
            return next;
        }
    }
}

