/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.RandomAccess;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.impl.list.mutable.AbstractMutableList;
import org.eclipse.collections.impl.utility.Iterate;

public class BoxedMutableDoubleList
extends AbstractMutableList<Double>
implements MutableList<Double>,
RandomAccess {
    private final MutableDoubleList delegate;

    public BoxedMutableDoubleList(MutableDoubleList delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean add(Double item) {
        return this.delegate.add(item.doubleValue());
    }

    public boolean addAll(int index, Collection<? extends Double> c) {
        double[] target = new double[c.size()];
        Iterate.forEachWithIndex(c, (ObjectIntProcedure & Serializable)(each, parameter) -> {
            target[parameter] = each;
        });
        return this.delegate.addAllAtIndex(index, target);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Double get(int index) {
        return this.delegate.get(index);
    }

    public Double set(int index, Double element) {
        return this.delegate.set(index, element.doubleValue());
    }

    public void add(int index, Double element) {
        this.delegate.addAtIndex(index, element.doubleValue());
    }

    public Double remove(int index) {
        return this.delegate.removeAtIndex(index);
    }

    @Override
    public int indexOf(Object o) {
        return o instanceof Double ? this.delegate.indexOf(((Double)o).doubleValue()) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return o instanceof Double ? this.delegate.lastIndexOf(((Double)o).doubleValue()) : -1;
    }

    @Override
    public MutableList<Double> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex).boxed();
    }
}

