/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap;

import java.io.Serializable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.UnmodifiableRichIterable;
import org.eclipse.collections.impl.block.factory.Functions;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;

public abstract class AbstractMultimap<K, V, C extends RichIterable<V>>
implements Multimap<K, V> {
    protected abstract MapIterable<K, C> getMap();

    protected abstract C createCollection();

    protected Function<AbstractMultimap<K, V, C>, C> createCollectionBlock() {
        return AbstractMultimap::createCollection;
    }

    public boolean containsKey(Object key) {
        return this.getMap().containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.getMap().anySatisfy((Predicate & Serializable)collection -> collection.contains(value));
    }

    public boolean containsKeyAndValue(Object key, Object value) {
        RichIterable collection = (RichIterable)this.getMap().get(key);
        return collection != null && collection.contains(value);
    }

    public RichIterable<K> keysView() {
        return this.getMap().keysView();
    }

    public RichIterable<RichIterable<V>> multiValuesView() {
        return this.getMap().valuesView().collect(UnmodifiableRichIterable::of);
    }

    public Bag<K> keyBag() {
        MutableBag bag = Bags.mutable.empty();
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, value) -> bag.addOccurrences(key, value.size()));
        return bag;
    }

    public RichIterable<V> valuesView() {
        return this.getMap().valuesView().flatCollect(Functions.identity());
    }

    public RichIterable<Pair<K, RichIterable<V>>> keyMultiValuePairsView() {
        return this.getMap().keyValuesView().collect((Function & Serializable)pair -> Tuples.pair(pair.getOne(), UnmodifiableRichIterable.of((RichIterable)pair.getTwo())));
    }

    public RichIterable<Pair<K, V>> keyValuePairsView() {
        return this.keyMultiValuePairsView().flatCollect((Function & Serializable)pair -> ((RichIterable)pair.getTwo()).collect(new KeyValuePairFunction(pair.getOne())));
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Multimap) {
            Multimap that = (Multimap)object;
            return this.getMap().equals((Object)that.toMap());
        }
        return false;
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public String toString() {
        return this.getMap().toString();
    }

    public boolean notEmpty() {
        return !this.isEmpty();
    }

    public void forEachValue(Procedure<? super V> procedure) {
        this.getMap().forEachValue((Procedure & Serializable)collection -> collection.forEach(procedure));
    }

    public void forEachKey(Procedure<? super K> procedure) {
        this.getMap().forEachKey(procedure);
    }

    public void forEachKeyValue(Procedure2<? super K, ? super V> procedure) {
        Procedure2 & Serializable innerProcedure = (Procedure2 & Serializable)(value, key) -> procedure.value(key, value);
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, collection) -> collection.forEachWith(innerProcedure, key));
    }

    public void forEachKeyMultiValues(Procedure2<? super K, ? super Iterable<V>> procedure) {
        this.getMap().forEachKeyValue(procedure);
    }

    public <R extends MutableMultimap<K, V>> R selectKeysValues(Predicate2<? super K, ? super V> predicate, R target) {
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, collection) -> {
            RichIterable selectedValues = collection.select((Predicate & Serializable)value -> predicate.accept(key, value));
            target.putAll(key, (Iterable)selectedValues);
        });
        return target;
    }

    public <R extends MutableMultimap<K, V>> R rejectKeysValues(Predicate2<? super K, ? super V> predicate, R target) {
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, collection) -> {
            RichIterable selectedValues = collection.reject((Predicate & Serializable)value -> predicate.accept(key, value));
            target.putAll(key, (Iterable)selectedValues);
        });
        return target;
    }

    public <R extends MutableMultimap<K, V>> R selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate, R target) {
        this.forEachKeyMultiValues((Procedure2 & Serializable)(key, collection) -> {
            if (predicate.accept(key, collection)) {
                target.putAll(key, collection);
            }
        });
        return target;
    }

    public <R extends MutableMultimap<K, V>> R rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate, R target) {
        this.forEachKeyMultiValues((Procedure2 & Serializable)(key, collection) -> {
            if (!predicate.accept(key, collection)) {
                target.putAll(key, collection);
            }
        });
        return target;
    }

    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function, R target) {
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, collection) -> collection.each((Procedure & Serializable)value -> target.add((Pair)function.value(key, value))));
        return target;
    }

    public <K2, V2, R extends MutableMultimap<K2, V2>> R collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction, R target) {
        this.forEachKeyMultiValues((Procedure2 & Serializable)(key, values) -> target.putAll(keyFunction.valueOf(key), Iterate.collect(values, valueFunction)));
        return target;
    }

    public <V2, R extends MutableMultimap<K, V2>> R collectValues(Function<? super V, ? extends V2> function, R target) {
        this.getMap().forEachKeyValue((Procedure2 & Serializable)(key, collection) -> target.putAll(key, (Iterable)collection.collect(function)));
        return target;
    }

    private static final class KeyValuePairFunction<V, K>
    implements Function<V, Pair<K, V>> {
        private static final long serialVersionUID = 1L;
        private final K key;

        private KeyValuePairFunction(K key) {
            this.key = key;
        }

        public Pair<K, V> valueOf(V value) {
            return Tuples.pair(this.key, value);
        }
    }
}

