/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.primitive;

import java.util.EmptyStackException;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectBooleanToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.BooleanPredicate;
import org.eclipse.collections.api.block.procedure.primitive.BooleanIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.BooleanProcedure;
import org.eclipse.collections.api.iterator.BooleanIterator;
import org.eclipse.collections.api.list.primitive.BooleanList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.set.primitive.MutableBooleanSet;
import org.eclipse.collections.api.stack.primitive.BooleanStack;
import org.eclipse.collections.impl.bag.mutable.primitive.BooleanHashBag;
import org.eclipse.collections.impl.iterator.UnmodifiableBooleanIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyBooleanIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.BooleanHashSet;

public abstract class AbstractBooleanStack
implements BooleanStack {
    protected abstract BooleanArrayList getDelegate();

    protected void checkEmptyStack() {
        if (this.getDelegate().isEmpty()) {
            throw new EmptyStackException();
        }
    }

    public boolean peek() {
        this.checkEmptyStack();
        return this.getDelegate().getLast();
    }

    public BooleanList peek(int count) {
        this.checkPositiveValueForCount(count);
        this.checkSizeLessThanCount(count);
        if (count == 0) {
            return new BooleanArrayList(0);
        }
        BooleanArrayList subList = new BooleanArrayList(count);
        int index = this.getDelegate().size() - 1;
        for (int i = 0; i < count; ++i) {
            subList.add(this.getDelegate().get(index - i));
        }
        return subList;
    }

    public boolean peekAt(int index) {
        this.rangeCheck(index);
        return this.getDelegate().get(this.getDelegate().size() - 1 - index);
    }

    protected void rangeCheck(int index) {
        if (index < 0 || index > this.getDelegate().size() - 1) {
            throw new IllegalArgumentException("Index " + index + " out of range.Should be between 0 and " + (this.getDelegate().size() - 1));
        }
    }

    protected void checkPositiveValueForCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    protected void checkSizeLessThanCount(int count) {
        if (this.getDelegate().size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.getDelegate().size());
        }
    }

    public void forEach(BooleanProcedure procedure) {
        this.each(procedure);
    }

    public BooleanIterator booleanIterator() {
        return new UnmodifiableBooleanIterator(this.getDelegate().asReversed().booleanIterator());
    }

    public void each(BooleanProcedure procedure) {
        this.getDelegate().asReversed().forEach(procedure);
    }

    public int count(BooleanPredicate predicate) {
        return this.getDelegate().asReversed().count(predicate);
    }

    public boolean anySatisfy(BooleanPredicate predicate) {
        return this.getDelegate().asReversed().anySatisfy(predicate);
    }

    public boolean allSatisfy(BooleanPredicate predicate) {
        return this.getDelegate().asReversed().allSatisfy(predicate);
    }

    public boolean noneSatisfy(BooleanPredicate predicate) {
        return this.getDelegate().asReversed().noneSatisfy(predicate);
    }

    public boolean detectIfNone(BooleanPredicate predicate, boolean ifNone) {
        return this.getDelegate().asReversed().detectIfNone(predicate, ifNone);
    }

    public boolean[] toArray() {
        return this.getDelegate().asReversed().toArray();
    }

    public boolean contains(boolean value) {
        return this.getDelegate().asReversed().contains(value);
    }

    public boolean containsAll(boolean ... source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public boolean containsAll(BooleanIterable source) {
        return this.getDelegate().asReversed().containsAll(source);
    }

    public MutableBooleanList toList() {
        return BooleanArrayList.newList((BooleanIterable)this);
    }

    public MutableBooleanSet toSet() {
        return BooleanHashSet.newSet((BooleanIterable)this);
    }

    public MutableBooleanBag toBag() {
        return BooleanHashBag.newBag((BooleanIterable)this);
    }

    public <V> V injectInto(V injectedValue, ObjectBooleanToObjectFunction<? super V, ? extends V> function) {
        return this.getDelegate().toReversed().injectInto(injectedValue, function);
    }

    public LazyBooleanIterable asLazy() {
        return new LazyBooleanIterableAdapter((BooleanIterable)this);
    }

    public int size() {
        return this.getDelegate().size();
    }

    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof BooleanStack)) {
            return false;
        }
        BooleanStack stack = (BooleanStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.peekAt(i) == stack.peekAt(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        LazyBooleanIterable iterable = this.getDelegate().asReversed();
        BooleanIterator iterator = iterable.booleanIterator();
        while (iterator.hasNext()) {
            boolean item = iterator.next();
            hashCode = 31 * hashCode + (item ? 1231 : 1237);
        }
        return hashCode;
    }

    public String toString() {
        return this.getDelegate().asReversed().toString();
    }

    public String makeString() {
        return this.getDelegate().asReversed().makeString();
    }

    public String makeString(String separator) {
        return this.getDelegate().asReversed().makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.getDelegate().asReversed().makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.getDelegate().asReversed().appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.getDelegate().asReversed().appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.getDelegate().asReversed().appendString(appendable, start, separator, end);
    }

    public boolean getFirst() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".getFirst() not implemented yet");
    }

    public int indexOf(boolean value) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectBooleanIntToObjectFunction<? super T, ? extends T> function) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".injectIntoWithIndex() not implemented yet");
    }

    public void forEachWithIndex(BooleanIntProcedure procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public RichIterable<BooleanIterable> chunk(int size) {
        return this.getDelegate().asReversed().chunk(size);
    }
}

