/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.ByteIntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.ByteToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction0;
import org.eclipse.collections.api.block.function.primitive.IntToIntFunction;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ByteIntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ByteIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ByteProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ByteIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteIntMap;
import org.eclipse.collections.api.map.primitive.MutableByteIntMap;
import org.eclipse.collections.api.map.primitive.MutableIntByteMap;
import org.eclipse.collections.api.set.primitive.MutableByteSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.ByteIntPair;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.primitive.ByteIntMaps;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.map.mutable.primitive.SynchronizedByteIntMap;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableByteSet;

public class UnmodifiableByteIntMap
implements MutableByteIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private final MutableByteIntMap map;

    public UnmodifiableByteIntMap(MutableByteIntMap map) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a UnmodifiableByteIntMap on a null map");
        }
        this.map = map;
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot call clear() on " + this.getClass().getSimpleName());
    }

    public void put(byte key, int value) {
        throw new UnsupportedOperationException("Cannot call put() on " + this.getClass().getSimpleName());
    }

    public void putPair(ByteIntPair keyValuePair) {
        throw new UnsupportedOperationException("Cannot call putPair() on " + this.getClass().getSimpleName());
    }

    public void putAll(ByteIntMap map) {
        throw new UnsupportedOperationException("Cannot call putAll() on " + this.getClass().getSimpleName());
    }

    public void updateValues(ByteIntToIntFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValues() on " + this.getClass().getSimpleName());
    }

    public void removeKey(byte key) {
        throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
    }

    public void remove(byte key) {
        throw new UnsupportedOperationException("Cannot call remove() on " + this.getClass().getSimpleName());
    }

    public int removeKeyIfAbsent(byte key, int value) {
        if (this.map.containsKey(key)) {
            throw new UnsupportedOperationException("Cannot call removeKey() on " + this.getClass().getSimpleName());
        }
        return value;
    }

    public int getIfAbsentPut(byte key, int value) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public int getIfAbsentPut(byte key, IntFunction0 function) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public int getIfAbsentPutWithKey(byte key, ByteToIntFunction function) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public <P> int getIfAbsentPutWith(byte key, IntFunction<? super P> function, P parameter) {
        return this.map.getIfAbsentPut(key, (IntFunction0 & Serializable)() -> {
            throw new UnsupportedOperationException();
        });
    }

    public int updateValue(byte key, int initialValueIfAbsent, IntToIntFunction function) {
        throw new UnsupportedOperationException("Cannot call updateValue() on " + this.getClass().getSimpleName());
    }

    public int get(byte key) {
        return this.map.get(key);
    }

    public int getIfAbsent(byte key, int ifAbsent) {
        return this.map.getIfAbsent(key, ifAbsent);
    }

    public int getOrThrow(byte key) {
        return this.map.getOrThrow(key);
    }

    public boolean containsKey(byte key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(int value) {
        return this.map.containsValue(value);
    }

    public void forEachValue(IntProcedure procedure) {
        this.map.forEachValue(procedure);
    }

    public void forEachKey(ByteProcedure procedure) {
        this.map.forEachKey(procedure);
    }

    public void forEachKeyValue(ByteIntProcedure procedure) {
        this.map.forEachKeyValue(procedure);
    }

    public LazyByteIterable keysView() {
        return this.map.keysView();
    }

    public RichIterable<ByteIntPair> keyValuesView() {
        return this.map.keyValuesView();
    }

    public MutableIntByteMap flipUniqueValues() {
        return this.map.flipUniqueValues().asUnmodifiable();
    }

    public MutableByteIntMap select(ByteIntPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableByteIntMap reject(ByteIntPredicate predicate) {
        return this.map.reject(predicate);
    }

    public MutableIntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)this.map.intIterator());
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        this.map.forEach(procedure);
    }

    public int count(IntPredicate predicate) {
        return this.map.count(predicate);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return this.map.anySatisfy(predicate);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return this.map.allSatisfy(predicate);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return this.map.noneSatisfy(predicate);
    }

    public MutableIntBag select(IntPredicate predicate) {
        return this.map.select(predicate);
    }

    public MutableIntBag reject(IntPredicate predicate) {
        return this.map.reject(predicate);
    }

    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return this.map.collect(function);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return this.map.detectIfNone(predicate, ifNone);
    }

    public long sum() {
        return this.map.sum();
    }

    public int max() {
        return this.map.max();
    }

    public int maxIfEmpty(int defaultValue) {
        return this.map.maxIfEmpty(defaultValue);
    }

    public int min() {
        return this.map.min();
    }

    public int minIfEmpty(int defaultValue) {
        return this.map.minIfEmpty(defaultValue);
    }

    public double average() {
        return this.map.average();
    }

    public double median() {
        return this.map.median();
    }

    public int addToValue(byte key, int toBeAdded) {
        throw new UnsupportedOperationException("Cannot call addToValue() on " + this.getClass().getSimpleName());
    }

    public int[] toSortedArray() {
        return this.map.toSortedArray();
    }

    public MutableIntList toSortedList() {
        return this.map.toSortedList();
    }

    public int[] toArray() {
        return this.map.toArray();
    }

    public boolean contains(int value) {
        return this.map.contains(value);
    }

    public boolean containsAll(int ... source) {
        return this.map.containsAll(source);
    }

    public boolean containsAll(IntIterable source) {
        return this.map.containsAll(source);
    }

    public MutableIntList toList() {
        return this.map.toList();
    }

    public MutableIntSet toSet() {
        return this.map.toSet();
    }

    public MutableIntBag toBag() {
        return this.map.toBag();
    }

    public LazyIntIterable asLazy() {
        return this.map.asLazy();
    }

    public MutableByteIntMap withKeyValue(byte key, int value) {
        throw new UnsupportedOperationException("Cannot call withKeyValue() on " + this.getClass().getSimpleName());
    }

    public MutableByteIntMap withoutKey(byte key) {
        throw new UnsupportedOperationException("Cannot call withoutKey() on " + this.getClass().getSimpleName());
    }

    public MutableByteIntMap withoutAllKeys(ByteIterable keys) {
        throw new UnsupportedOperationException("Cannot call withoutAllKeys() on " + this.getClass().getSimpleName());
    }

    public MutableByteIntMap asUnmodifiable() {
        return this;
    }

    public MutableByteIntMap asSynchronized() {
        return new SynchronizedByteIntMap(this);
    }

    public ImmutableByteIntMap toImmutable() {
        return ByteIntMaps.immutable.withAll((ByteIntMap)this);
    }

    public int size() {
        return this.map.size();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public boolean notEmpty() {
        return this.map.notEmpty();
    }

    public MutableByteSet keySet() {
        return UnmodifiableByteSet.of(this.map.keySet());
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of(this.map.values());
    }

    public boolean equals(Object otherMap) {
        return this.map.equals(otherMap);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }

    public String makeString() {
        return this.map.makeString();
    }

    public String makeString(String separator) {
        return this.map.makeString(separator);
    }

    public String makeString(String start, String separator, String end) {
        return this.map.makeString(start, separator, end);
    }

    public void appendString(Appendable appendable) {
        this.map.appendString(appendable);
    }

    public void appendString(Appendable appendable, String separator) {
        this.map.appendString(appendable, separator);
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        this.map.appendString(appendable, start, separator, end);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)this.map.injectInto(injectedValue, function);
    }

    public RichIterable<IntIterable> chunk(int size) {
        return this.map.chunk(size);
    }
}

