/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectDoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.predicate.primitive.IntDoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntDoubleProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.iterator.DoubleIterator;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleIntMap;
import org.eclipse.collections.api.map.primitive.ImmutableIntDoubleMap;
import org.eclipse.collections.api.map.primitive.IntDoubleMap;
import org.eclipse.collections.api.set.primitive.MutableDoubleSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.tuple.primitive.IntDoublePair;
import org.eclipse.collections.impl.bag.mutable.primitive.DoubleHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableDoubleCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.DoubleBags;
import org.eclipse.collections.impl.factory.primitive.DoubleIntMaps;
import org.eclipse.collections.impl.iterator.ImmutableEmptyDoubleIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyDoubleIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableIntDoubleSingletonMap;
import org.eclipse.collections.impl.set.mutable.primitive.DoubleHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableIntSet;
import org.eclipse.collections.impl.utility.LazyIterate;
import org.eclipse.collections.impl.utility.primitive.LazyIntIterate;

final class ImmutableIntDoubleEmptyMap
implements ImmutableIntDoubleMap,
Serializable {
    static final ImmutableIntDoubleMap INSTANCE = new ImmutableIntDoubleEmptyMap();
    private static final long serialVersionUID = 1L;
    private static final double EMPTY_VALUE = 0.0;

    ImmutableIntDoubleEmptyMap() {
    }

    private Object readResolve() {
        return INSTANCE;
    }

    public double get(int key) {
        return 0.0;
    }

    public double getIfAbsent(int key, double ifAbsent) {
        return ifAbsent;
    }

    public double getOrThrow(int key) {
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(int key) {
        return false;
    }

    public boolean containsValue(double value) {
        return false;
    }

    public void forEachValue(DoubleProcedure procedure) {
    }

    public void forEachKey(IntProcedure procedure) {
    }

    public void forEachKeyValue(IntDoubleProcedure procedure) {
    }

    public LazyIntIterable keysView() {
        return LazyIntIterate.empty();
    }

    public RichIterable<IntDoublePair> keyValuesView() {
        return LazyIterate.empty();
    }

    public ImmutableDoubleIntMap flipUniqueValues() {
        return DoubleIntMaps.immutable.empty();
    }

    public ImmutableIntDoubleMap select(IntDoublePredicate predicate) {
        return this;
    }

    public ImmutableIntDoubleMap reject(IntDoublePredicate predicate) {
        return this;
    }

    public ImmutableIntDoubleMap toImmutable() {
        return this;
    }

    public DoubleIterator doubleIterator() {
        return ImmutableEmptyDoubleIterator.INSTANCE;
    }

    public void forEach(DoubleProcedure procedure) {
    }

    public void each(DoubleProcedure procedure) {
    }

    public int count(DoublePredicate predicate) {
        return 0;
    }

    public double sum() {
        return 0.0;
    }

    public double min() {
        throw new NoSuchElementException();
    }

    public double max() {
        throw new NoSuchElementException();
    }

    public double maxIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double minIfEmpty(double defaultValue) {
        return defaultValue;
    }

    public double average() {
        throw new ArithmeticException();
    }

    public double median() {
        throw new ArithmeticException();
    }

    public double[] toSortedArray() {
        return new double[0];
    }

    public MutableDoubleList toSortedList() {
        return new DoubleArrayList();
    }

    public boolean anySatisfy(DoublePredicate predicate) {
        return false;
    }

    public boolean allSatisfy(DoublePredicate predicate) {
        return true;
    }

    public boolean noneSatisfy(DoublePredicate predicate) {
        return true;
    }

    public ImmutableDoubleBag select(DoublePredicate predicate) {
        return DoubleBags.immutable.empty();
    }

    public ImmutableDoubleBag reject(DoublePredicate predicate) {
        return DoubleBags.immutable.empty();
    }

    public <V> ImmutableBag<V> collect(DoubleToObjectFunction<? extends V> function) {
        return Bags.immutable.empty();
    }

    public double detectIfNone(DoublePredicate predicate, double ifNone) {
        return ifNone;
    }

    public <T> T injectInto(T injectedValue, ObjectDoubleToObjectFunction<? super T, ? extends T> function) {
        return injectedValue;
    }

    public RichIterable<DoubleIterable> chunk(int size) {
        return Lists.immutable.empty();
    }

    public double[] toArray() {
        return new double[0];
    }

    public boolean contains(double value) {
        return false;
    }

    public boolean containsAll(double ... source) {
        return source.length == 0;
    }

    public boolean containsAll(DoubleIterable source) {
        return source.isEmpty();
    }

    public MutableDoubleList toList() {
        return new DoubleArrayList();
    }

    public MutableDoubleSet toSet() {
        return new DoubleHashSet();
    }

    public MutableDoubleBag toBag() {
        return new DoubleHashBag();
    }

    public LazyDoubleIterable asLazy() {
        return new LazyDoubleIterableAdapter((DoubleIterable)this);
    }

    public ImmutableIntDoubleMap newWithKeyValue(int key, double value) {
        return new ImmutableIntDoubleSingletonMap(key, value);
    }

    public ImmutableIntDoubleMap newWithoutKey(int key) {
        return this;
    }

    public ImmutableIntDoubleMap newWithoutAllKeys(IntIterable keys) {
        return this;
    }

    public int size() {
        return 0;
    }

    public boolean isEmpty() {
        return true;
    }

    public boolean notEmpty() {
        return false;
    }

    public MutableIntSet keySet() {
        return UnmodifiableIntSet.of(new IntHashSet());
    }

    public MutableDoubleCollection values() {
        return UnmodifiableDoubleCollection.of((MutableDoubleCollection)new DoubleArrayList());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntDoubleMap)) {
            return false;
        }
        IntDoubleMap map = (IntDoubleMap)obj;
        return map.isEmpty();
    }

    public int hashCode() {
        return 0;
    }

    public String toString() {
        return "{}";
    }

    public String makeString() {
        return "";
    }

    public String makeString(String separator) {
        return "";
    }

    public String makeString(String start, String separator, String end) {
        return start + end;
    }

    public void appendString(Appendable appendable) {
    }

    public void appendString(Appendable appendable, String separator) {
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

