/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.Callable;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.collections.api.InternalIterable;
import org.eclipse.collections.api.PrimitiveIterable;
import org.eclipse.collections.api.bag.Bag;
import org.eclipse.collections.api.bag.sorted.SortedBag;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.ImmutableMapIterable;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.sorted.SortedMapIterable;
import org.eclipse.collections.api.multimap.Multimap;
import org.eclipse.collections.api.multimap.bag.BagMultimap;
import org.eclipse.collections.api.multimap.list.ListMultimap;
import org.eclipse.collections.api.multimap.set.SetMultimap;
import org.eclipse.collections.api.multimap.sortedbag.SortedBagMultimap;
import org.eclipse.collections.api.multimap.sortedset.SortedSetMultimap;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.CollectionAddProcedure;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.Sets;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.test.SerializeTestHelper;
import org.eclipse.collections.impl.tuple.ImmutableEntry;
import org.eclipse.collections.impl.utility.ArrayIterate;
import org.eclipse.collections.impl.utility.Iterate;
import org.junit.Assert;

public final class Verify
extends Assert {
    private static final int MAX_DIFFERENCES = 5;
    private static final byte[] LINE_SEPARATOR = new byte[]{10};

    private Verify() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static void throwMangledException(AssertionError e) {
        Verify.throwMangledException(e, 3);
    }

    public static void throwMangledException(AssertionError e, int framesToPop) {
        ((Throwable)((Object)e)).fillInStackTrace();
        StackTraceElement[] stackTrace = ((Throwable)((Object)e)).getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[stackTrace.length - framesToPop];
        System.arraycopy(stackTrace, framesToPop, newStackTrace, 0, newStackTrace.length);
        ((Throwable)((Object)e)).setStackTrace(newStackTrace);
        throw e;
    }

    public static void fail(String message, Throwable cause) {
        AssertionError failedException = new AssertionError(message, cause);
        Verify.throwMangledException(failedException);
    }

    @Deprecated
    public static void assertNotEquals(String itemsName, Object item1, Object item2) {
        try {
            if (Comparators.nullSafeEquals((Object)item1, (Object)item2) || Comparators.nullSafeEquals((Object)item2, (Object)item1)) {
                Assert.fail((String)(itemsName + " should not be equal, item1:<" + item1 + ">, item2:<" + item2 + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(Object item1, Object item2) {
        try {
            Verify.assertNotEquals("items", item1, item2);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(String itemName, String notExpected, String actual) {
        try {
            if (Comparators.nullSafeEquals((Object)notExpected, (Object)actual)) {
                Assert.fail((String)(itemName + " should not equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(String notExpected, String actual) {
        try {
            Verify.assertNotEquals("string", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(String itemName, double notExpected, double actual, double delta) {
        try {
            if (Double.isInfinite(notExpected) && notExpected == actual || Math.abs(notExpected - actual) <= delta) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(double notExpected, double actual, double delta) {
        try {
            Verify.assertNotEquals("double", notExpected, actual, delta);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(String itemName, float notExpected, float actual, float delta) {
        try {
            if (Float.isInfinite(notExpected) && notExpected == actual || Math.abs(notExpected - actual) <= delta) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(float expected, float actual, float delta) {
        try {
            Verify.assertNotEquals("float", expected, actual, delta);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(String itemName, long notExpected, long actual) {
        try {
            if (notExpected == actual) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(long notExpected, long actual) {
        try {
            Verify.assertNotEquals("long", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(String itemName, boolean notExpected, boolean actual) {
        try {
            if (notExpected == actual) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(boolean notExpected, boolean actual) {
        try {
            Verify.assertNotEquals("boolean", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(String itemName, byte notExpected, byte actual) {
        try {
            if (notExpected == actual) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(byte notExpected, byte actual) {
        try {
            Verify.assertNotEquals("byte", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(String itemName, char notExpected, char actual) {
        try {
            if (notExpected == actual) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(char notExpected, char actual) {
        try {
            Verify.assertNotEquals("char", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(String itemName, short notExpected, short actual) {
        try {
            if (notExpected == actual) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEquals(short notExpected, short actual) {
        try {
            Verify.assertNotEquals("short", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(String itemName, int notExpected, int actual) {
        try {
            if (notExpected == actual) {
                Assert.fail((String)(itemName + " should not be equal:<" + notExpected + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertNotEquals(int notExpected, int actual) {
        try {
            Verify.assertNotEquals("int", notExpected, actual);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(Iterable<?> actualIterable) {
        try {
            Verify.assertEmpty("iterable", actualIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(String iterableName, Iterable<?> actualIterable) {
        try {
            Verify.assertObjectNotNull(iterableName, actualIterable);
            if (Iterate.notEmpty(actualIterable)) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualIterable) + '>'));
            }
            if (!Iterate.isEmpty(actualIterable)) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualIterable) + '>'));
            }
            if (Iterate.sizeOf(actualIterable) != 0) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualIterable) + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(MutableMapIterable<?, ?> actualMutableMapIterable) {
        try {
            Verify.assertEmpty("mutableMapIterable", actualMutableMapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(String mutableMapIterableName, MutableMapIterable<?, ?> actualMutableMapIterable) {
        try {
            Verify.assertObjectNotNull(mutableMapIterableName, actualMutableMapIterable);
            if (Iterate.notEmpty(actualMutableMapIterable)) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + '>'));
            }
            if (!Iterate.isEmpty(actualMutableMapIterable)) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + '>'));
            }
            if (!actualMutableMapIterable.isEmpty()) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + '>'));
            }
            if (actualMutableMapIterable.notEmpty()) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + Iterate.sizeOf(actualMutableMapIterable) + '>'));
            }
            if (actualMutableMapIterable.size() != 0) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.size() + '>'));
            }
            if (actualMutableMapIterable.keySet().size() != 0) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.keySet().size() + '>'));
            }
            if (actualMutableMapIterable.values().size() != 0) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.values().size() + '>'));
            }
            if (actualMutableMapIterable.entrySet().size() != 0) {
                Assert.fail((String)(mutableMapIterableName + " should be empty; actual size:<" + actualMutableMapIterable.entrySet().size() + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(PrimitiveIterable primitiveIterable) {
        try {
            Verify.assertEmpty("primitiveIterable", primitiveIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(String iterableName, PrimitiveIterable primitiveIterable) {
        try {
            Verify.assertObjectNotNull(iterableName, primitiveIterable);
            if (primitiveIterable.notEmpty()) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + primitiveIterable.size() + '>'));
            }
            if (!primitiveIterable.isEmpty()) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + primitiveIterable.size() + '>'));
            }
            if (primitiveIterable.size() != 0) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + primitiveIterable.size() + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterableEmpty(Iterable<?> iterable) {
        try {
            Verify.assertIterableEmpty("iterable", iterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterableEmpty(String iterableName, Iterable<?> iterable) {
        try {
            Verify.assertObjectNotNull(iterableName, iterable);
            if (Iterate.notEmpty(iterable)) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(iterable) + '>'));
            }
            if (!Iterate.isEmpty(iterable)) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(iterable) + '>'));
            }
            if (Iterate.sizeOf(iterable) != 0) {
                Assert.fail((String)(iterableName + " should be empty; actual size:<" + Iterate.sizeOf(iterable) + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertInstanceOf(Class<?> expectedClassType, Object actualObject) {
        try {
            Verify.assertInstanceOf(actualObject.getClass().getName(), expectedClassType, actualObject);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertInstanceOf(String objectName, Class<?> expectedClassType, Object actualObject) {
        try {
            if (!expectedClassType.isInstance(actualObject)) {
                Assert.fail((String)(objectName + " is not an instance of " + expectedClassType.getName()));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotInstanceOf(Class<?> expectedClassType, Object actualObject) {
        try {
            Verify.assertNotInstanceOf(actualObject.getClass().getName(), expectedClassType, actualObject);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotInstanceOf(String objectName, Class<?> expectedClassType, Object actualObject) {
        try {
            if (expectedClassType.isInstance(actualObject)) {
                Assert.fail((String)(objectName + " is an instance of " + expectedClassType.getName()));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(Map<?, ?> actualMap) {
        try {
            Verify.assertEmpty("map", actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(Multimap<?, ?> actualMultimap) {
        try {
            Verify.assertEmpty("multimap", actualMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(String multimapName, Multimap<?, ?> actualMultimap) {
        try {
            Verify.assertObjectNotNull(multimapName, actualMultimap);
            if (actualMultimap.notEmpty()) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + '>'));
            }
            if (!actualMultimap.isEmpty()) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + '>'));
            }
            if (actualMultimap.size() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + '>'));
            }
            if (actualMultimap.sizeDistinct() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.size() + '>'));
            }
            if (actualMultimap.keyBag().size() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keyBag().size() + '>'));
            }
            if (actualMultimap.keysView().size() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keysView().size() + '>'));
            }
            if (actualMultimap.valuesView().size() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.valuesView().size() + '>'));
            }
            if (actualMultimap.keyValuePairsView().size() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keyValuePairsView().size() + '>'));
            }
            if (actualMultimap.keyMultiValuePairsView().size() != 0) {
                Assert.fail((String)(multimapName + " should be empty; actual size:<" + actualMultimap.keyMultiValuePairsView().size() + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEmpty(String mapName, Map<?, ?> actualMap) {
        try {
            Verify.assertObjectNotNull(mapName, actualMap);
            if (!actualMap.isEmpty()) {
                Assert.fail((String)(mapName + " should be empty; actual size:<" + actualMap.size() + '>'));
            }
            if (actualMap.size() != 0) {
                Assert.fail((String)(mapName + " should be empty; actual size:<" + actualMap.size() + '>'));
            }
            if (actualMap.keySet().size() != 0) {
                Assert.fail((String)(mapName + " should be empty; actual size:<" + actualMap.keySet().size() + '>'));
            }
            if (actualMap.values().size() != 0) {
                Assert.fail((String)(mapName + " should be empty; actual size:<" + actualMap.values().size() + '>'));
            }
            if (actualMap.entrySet().size() != 0) {
                Assert.fail((String)(mapName + " should be empty; actual size:<" + actualMap.entrySet().size() + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(Iterable<?> actualIterable) {
        try {
            Verify.assertNotEmpty("iterable", actualIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(String iterableName, Iterable<?> actualIterable) {
        try {
            Verify.assertObjectNotNull(iterableName, actualIterable);
            Assert.assertFalse((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.isEmpty(actualIterable));
            Assert.assertTrue((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.notEmpty(actualIterable));
            Assert.assertNotEquals((String)(iterableName + " should be non-empty, but was empty"), (long)0L, (long)Iterate.sizeOf(actualIterable));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(MutableMapIterable<?, ?> actualMutableMapIterable) {
        try {
            Verify.assertNotEmpty("mutableMapIterable", actualMutableMapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(String mutableMapIterableName, MutableMapIterable<?, ?> actualMutableMapIterable) {
        try {
            Verify.assertObjectNotNull(mutableMapIterableName, actualMutableMapIterable);
            Assert.assertFalse((String)(mutableMapIterableName + " should be non-empty, but was empty"), (boolean)Iterate.isEmpty(actualMutableMapIterable));
            Assert.assertTrue((String)(mutableMapIterableName + " should be non-empty, but was empty"), (boolean)Iterate.notEmpty(actualMutableMapIterable));
            Assert.assertTrue((String)(mutableMapIterableName + " should be non-empty, but was empty"), (boolean)actualMutableMapIterable.notEmpty());
            Assert.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.size());
            Assert.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.keySet().size());
            Assert.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.values().size());
            Assert.assertNotEquals((String)(mutableMapIterableName + " should be non-empty, but was empty"), (long)0L, (long)actualMutableMapIterable.entrySet().size());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(PrimitiveIterable primitiveIterable) {
        try {
            Verify.assertNotEmpty("primitiveIterable", primitiveIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(String iterableName, PrimitiveIterable primitiveIterable) {
        try {
            Verify.assertObjectNotNull(iterableName, primitiveIterable);
            Assert.assertFalse((String)(iterableName + " should be non-empty, but was empty"), (boolean)primitiveIterable.isEmpty());
            Assert.assertTrue((String)(iterableName + " should be non-empty, but was empty"), (boolean)primitiveIterable.notEmpty());
            Assert.assertNotEquals((String)(iterableName + " should be non-empty, but was empty"), (long)0L, (long)primitiveIterable.size());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterableNotEmpty(Iterable<?> iterable) {
        try {
            Verify.assertIterableNotEmpty("iterable", iterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterableNotEmpty(String iterableName, Iterable<?> iterable) {
        try {
            Verify.assertObjectNotNull(iterableName, iterable);
            Assert.assertFalse((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.isEmpty(iterable));
            Assert.assertTrue((String)(iterableName + " should be non-empty, but was empty"), (boolean)Iterate.notEmpty(iterable));
            Assert.assertNotEquals((String)(iterableName + " should be non-empty, but was empty"), (long)0L, (long)Iterate.sizeOf(iterable));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(Map<?, ?> actualMap) {
        try {
            Verify.assertNotEmpty("map", actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(String mapName, Map<?, ?> actualMap) {
        try {
            Verify.assertObjectNotNull(mapName, actualMap);
            Assert.assertFalse((String)(mapName + " should be non-empty, but was empty"), (boolean)actualMap.isEmpty());
            Assert.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.size());
            Assert.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.keySet().size());
            Assert.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.values().size());
            Assert.assertNotEquals((String)(mapName + " should be non-empty, but was empty"), (long)0L, (long)actualMap.entrySet().size());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(Multimap<?, ?> actualMultimap) {
        try {
            Verify.assertNotEmpty("multimap", actualMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotEmpty(String multimapName, Multimap<?, ?> actualMultimap) {
        try {
            Verify.assertObjectNotNull(multimapName, actualMultimap);
            Assert.assertTrue((String)(multimapName + " should be non-empty, but was empty"), (boolean)actualMultimap.notEmpty());
            Assert.assertFalse((String)(multimapName + " should be non-empty, but was empty"), (boolean)actualMultimap.isEmpty());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.size());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.sizeDistinct());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keyBag().size());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keysView().size());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.valuesView().size());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keyValuePairsView().size());
            Assert.assertNotEquals((String)(multimapName + " should be non-empty, but was empty"), (long)0L, (long)actualMultimap.keyMultiValuePairsView().size());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertNotEmpty(String itemsName, T[] items) {
        try {
            Verify.assertObjectNotNull(itemsName, items);
            Verify.assertNotEquals(itemsName, 0, items.length);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertNotEmpty(T[] items) {
        try {
            Verify.assertNotEmpty("items", items);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, Object[] actualArray) {
        try {
            Verify.assertSize("array", expectedSize, actualArray);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String arrayName, int expectedSize, Object[] actualArray) {
        try {
            Assert.assertNotNull((String)(arrayName + " should not be null"), (Object)actualArray);
            int actualSize = actualArray.length;
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + arrayName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, Iterable<?> actualIterable) {
        try {
            Verify.assertSize("iterable", expectedSize, actualIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String iterableName, int expectedSize, Iterable<?> actualIterable) {
        try {
            Verify.assertObjectNotNull(iterableName, actualIterable);
            int actualSize = Iterate.sizeOf(actualIterable);
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + iterableName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, PrimitiveIterable primitiveIterable) {
        try {
            Verify.assertSize("primitiveIterable", expectedSize, primitiveIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String primitiveIterableName, int expectedSize, PrimitiveIterable actualPrimitiveIterable) {
        try {
            Verify.assertObjectNotNull(primitiveIterableName, actualPrimitiveIterable);
            int actualSize = actualPrimitiveIterable.size();
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + primitiveIterableName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterableSize(int expectedSize, Iterable<?> actualIterable) {
        try {
            Verify.assertIterableSize("iterable", expectedSize, actualIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterableSize(String iterableName, int expectedSize, Iterable<?> actualIterable) {
        try {
            Verify.assertObjectNotNull(iterableName, actualIterable);
            int actualSize = Iterate.sizeOf(actualIterable);
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + iterableName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String mapName, int expectedSize, Map<?, ?> actualMap) {
        try {
            Verify.assertSize(mapName, expectedSize, actualMap.keySet());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, Map<?, ?> actualMap) {
        try {
            Verify.assertSize("map", expectedSize, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, Multimap<?, ?> actualMultimap) {
        try {
            Verify.assertSize("multimap", expectedSize, actualMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String multimapName, int expectedSize, Multimap<?, ?> actualMultimap) {
        try {
            int actualSize = actualMultimap.size();
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + multimapName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, MutableMapIterable<?, ?> mutableMapIterable) {
        try {
            Verify.assertSize("map", expectedSize, mutableMapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String mapName, int expectedSize, MutableMapIterable<?, ?> mutableMapIterable) {
        try {
            int entrySetSize;
            int valuesSize;
            int keySetSize;
            int actualSize = mutableMapIterable.size();
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + mapName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
            if ((keySetSize = mutableMapIterable.keySet().size()) != expectedSize) {
                Assert.fail((String)("Incorrect size for " + mapName + ".keySet(); expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
            if ((valuesSize = mutableMapIterable.values().size()) != expectedSize) {
                Assert.fail((String)("Incorrect size for " + mapName + ".values(); expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
            if ((entrySetSize = mutableMapIterable.entrySet().size()) != expectedSize) {
                Assert.fail((String)("Incorrect size for " + mapName + ".entrySet(); expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(int expectedSize, ImmutableSet<?> actualImmutableSet) {
        try {
            Verify.assertSize("immutable set", expectedSize, actualImmutableSet);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSize(String immutableSetName, int expectedSize, ImmutableSet<?> actualImmutableSet) {
        try {
            int actualSize = actualImmutableSet.size();
            if (actualSize != expectedSize) {
                Assert.fail((String)("Incorrect size for " + immutableSetName + "; expected:<" + expectedSize + "> but was:<" + actualSize + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContains(String stringToFind, String stringToSearch) {
        try {
            Verify.assertContains("string", stringToFind, stringToSearch);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContains(String unexpectedString, String stringToSearch) {
        try {
            Verify.assertNotContains("string", unexpectedString, stringToSearch);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContains(String stringName, String stringToFind, String stringToSearch) {
        try {
            Assert.assertNotNull((String)"stringToFind should not be null", (Object)stringToFind);
            Assert.assertNotNull((String)"stringToSearch should not be null", (Object)stringToSearch);
            if (!stringToSearch.contains(stringToFind)) {
                Assert.fail((String)(stringName + " did not contain stringToFind:<" + stringToFind + "> in stringToSearch:<" + stringToSearch + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContains(String stringName, String unexpectedString, String stringToSearch) {
        try {
            Assert.assertNotNull((String)"unexpectedString should not be null", (Object)unexpectedString);
            Assert.assertNotNull((String)"stringToSearch should not be null", (Object)stringToSearch);
            if (stringToSearch.contains(unexpectedString)) {
                Assert.fail((String)(stringName + " contains unexpectedString:<" + unexpectedString + "> in stringToSearch:<" + stringToSearch + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertCount(int expectedCount, Iterable<T> iterable, Predicate<? super T> predicate) {
        Assert.assertEquals((long)expectedCount, (long)Iterate.count(iterable, predicate));
    }

    public static <T> void assertAllSatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        try {
            Verify.assertAllSatisfy("The following items failed to satisfy the condition", iterable, predicate);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertAllSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        try {
            Verify.assertAllSatisfy(map.values(), predicate);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertAllSatisfy(String message, Iterable<T> iterable, Predicate<? super T> predicate) {
        try {
            MutableList unnacceptable = (MutableList)Iterate.reject(iterable, predicate, (Collection)Lists.mutable.of());
            if (unnacceptable.notEmpty()) {
                Assert.fail((String)(message + " <" + unnacceptable + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertAnySatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        try {
            Verify.assertAnySatisfy("No items satisfied the condition", iterable, predicate);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertAnySatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        try {
            Verify.assertAnySatisfy(map.values(), predicate);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertAnySatisfy(String message, Iterable<T> iterable, Predicate<? super T> predicate) {
        try {
            Assert.assertTrue((String)message, (boolean)Predicates.anySatisfy(predicate).accept(iterable));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertNoneSatisfy(Iterable<T> iterable, Predicate<? super T> predicate) {
        try {
            Verify.assertNoneSatisfy("The following items satisfied the condition", iterable, predicate);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertNoneSatisfy(Map<K, V> map, Predicate<? super V> predicate) {
        try {
            Verify.assertNoneSatisfy(map.values(), predicate);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertNoneSatisfy(String message, Iterable<T> iterable, Predicate<? super T> predicate) {
        try {
            MutableList unnacceptable = (MutableList)Iterate.select(iterable, predicate, (Collection)Lists.mutable.empty());
            if (unnacceptable.notEmpty()) {
                Assert.fail((String)(message + " <" + unnacceptable + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(Map<?, ?> actualMap, Object ... keyValues) {
        try {
            Verify.assertContainsAllKeyValues("map", actualMap, keyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(String mapName, Map<?, ?> actualMap, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            if (expectedKeyValues.length % 2 != 0) {
                Assert.fail((String)"Odd number of keys and values (every key must have a value)");
            }
            Verify.assertObjectNotNull(mapName, actualMap);
            Verify.assertMapContainsKeys(mapName, actualMap, expectedKeyValues);
            Verify.assertMapContainsValues(mapName, actualMap, expectedKeyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(MapIterable<?, ?> mapIterable, Object ... keyValues) {
        try {
            Verify.assertContainsAllKeyValues("map", mapIterable, keyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(String mapIterableName, MapIterable<?, ?> mapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            if (expectedKeyValues.length % 2 != 0) {
                Assert.fail((String)"Odd number of keys and values (every key must have a value)");
            }
            Verify.assertObjectNotNull(mapIterableName, mapIterable);
            Verify.assertMapContainsKeys(mapIterableName, mapIterable, expectedKeyValues);
            Verify.assertMapContainsValues(mapIterableName, mapIterable, expectedKeyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(MutableMapIterable<?, ?> mutableMapIterable, Object ... keyValues) {
        try {
            Verify.assertContainsAllKeyValues("map", mutableMapIterable, keyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(String mutableMapIterableName, MutableMapIterable<?, ?> mutableMapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            if (expectedKeyValues.length % 2 != 0) {
                Assert.fail((String)"Odd number of keys and values (every key must have a value)");
            }
            Verify.assertObjectNotNull(mutableMapIterableName, mutableMapIterable);
            Verify.assertMapContainsKeys(mutableMapIterableName, mutableMapIterable, expectedKeyValues);
            Verify.assertMapContainsValues(mutableMapIterableName, mutableMapIterable, expectedKeyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(ImmutableMapIterable<?, ?> immutableMapIterable, Object ... keyValues) {
        try {
            Verify.assertContainsAllKeyValues("map", immutableMapIterable, keyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllKeyValues(String immutableMapIterableName, ImmutableMapIterable<?, ?> immutableMapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            if (expectedKeyValues.length % 2 != 0) {
                Assert.fail((String)"Odd number of keys and values (every key must have a value)");
            }
            Verify.assertObjectNotNull(immutableMapIterableName, immutableMapIterable);
            Verify.assertMapContainsKeys(immutableMapIterableName, immutableMapIterable, expectedKeyValues);
            Verify.assertMapContainsValues(immutableMapIterableName, immutableMapIterable, expectedKeyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void denyContainsAny(Collection<?> actualCollection, Object ... items) {
        try {
            Verify.denyContainsAny("collection", actualCollection, items);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsNone(Collection<?> actualCollection, Object ... items) {
        try {
            Verify.denyContainsAny("collection", actualCollection, items);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContains(Object expectedItem, Collection<?> actualCollection) {
        try {
            Verify.assertContains("collection", expectedItem, actualCollection);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContains(String collectionName, Object expectedItem, Collection<?> actualCollection) {
        try {
            Verify.assertObjectNotNull(collectionName, actualCollection);
            if (!actualCollection.contains(expectedItem)) {
                Assert.fail((String)(collectionName + " did not contain expectedItem:<" + expectedItem + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContains(Object expectedItem, ImmutableCollection<?> actualImmutableCollection) {
        try {
            Verify.assertContains("ImmutableCollection", expectedItem, actualImmutableCollection);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContains(String immutableCollectionName, Object expectedItem, ImmutableCollection<?> actualImmutableCollection) {
        try {
            Verify.assertObjectNotNull(immutableCollectionName, actualImmutableCollection);
            if (!actualImmutableCollection.contains(expectedItem)) {
                Assert.fail((String)(immutableCollectionName + " did not contain expectedItem:<" + expectedItem + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAll(Iterable<?> iterable, Object ... items) {
        try {
            Verify.assertContainsAll("iterable", iterable, items);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAll(String collectionName, Iterable<?> iterable, Object ... items) {
        try {
            Verify.assertObjectNotNull(collectionName, iterable);
            Verify.assertNotEmpty("Expected items in assertion", items);
            Predicate & Serializable containsPredicate = (Predicate & Serializable)each -> Iterate.contains((Iterable)iterable, (Object)each);
            if (!ArrayIterate.allSatisfy((Object[])items, (Predicate)containsPredicate)) {
                ImmutableList result = Lists.immutable.of(items).newWithoutAll(iterable);
                Assert.fail((String)(collectionName + " did not contain these items:<" + result + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertListsEqual(List<?> expectedList, List<?> actualList) {
        try {
            Verify.assertListsEqual("list", expectedList, actualList);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertListsEqual(String listName, List<?> expectedList, List<?> actualList) {
        try {
            if (expectedList == null && actualList == null) {
                return;
            }
            Assert.assertNotNull(expectedList);
            Assert.assertNotNull(actualList);
            Assert.assertEquals((String)(listName + " size"), (long)expectedList.size(), (long)actualList.size());
            for (int index = 0; index < actualList.size(); ++index) {
                Object eachActual;
                Object eachExpected = expectedList.get(index);
                if (Comparators.nullSafeEquals(eachExpected, eachActual = actualList.get(index))) continue;
                junit.framework.Assert.failNotEquals((String)(listName + " first differed at element [" + index + "];"), eachExpected, eachActual);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSetsEqual(Set<?> expectedSet, Set<?> actualSet) {
        try {
            Verify.assertSetsEqual("set", expectedSet, actualSet);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSetsEqual(String setName, Set<?> expectedSet, Set<?> actualSet) {
        try {
            if (expectedSet == null) {
                Assert.assertNull((String)(setName + " should be null"), actualSet);
                return;
            }
            Verify.assertObjectNotNull(setName, actualSet);
            Verify.assertSize(setName, expectedSet.size(), actualSet);
            if (!actualSet.equals(expectedSet)) {
                UnifiedSet inExpectedOnlySet = UnifiedSet.newSet(expectedSet);
                inExpectedOnlySet.removeAll(actualSet);
                int numberDifferences = inExpectedOnlySet.size();
                String message = setName + ": " + numberDifferences + " elements different.";
                if (numberDifferences > 5) {
                    Assert.fail((String)message);
                }
                UnifiedSet inActualOnlySet = UnifiedSet.newSet(actualSet);
                inActualOnlySet.removeAll(expectedSet);
                junit.framework.Assert.failNotEquals((String)message, (Object)inExpectedOnlySet, (Object)inActualOnlySet);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSortedSetsEqual(SortedSet<?> expectedSet, SortedSet<?> actualSet) {
        try {
            Verify.assertSortedSetsEqual("sortedSets", expectedSet, actualSet);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSortedSetsEqual(String setName, SortedSet<?> expectedSet, SortedSet<?> actualSet) {
        try {
            Assert.assertEquals((String)setName, expectedSet, actualSet);
            Verify.assertIterablesEqual(setName, expectedSet, actualSet);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSortedBagsEqual(SortedBag<?> expectedBag, SortedBag<?> actualBag) {
        try {
            Verify.assertSortedBagsEqual("sortedBags", expectedBag, actualBag);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSortedBagsEqual(String bagName, SortedBag<?> expectedBag, SortedBag<?> actualBag) {
        try {
            Assert.assertEquals((String)bagName, expectedBag, actualBag);
            Verify.assertIterablesEqual(bagName, expectedBag, actualBag);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSortedMapsEqual(SortedMapIterable<?, ?> expectedMap, SortedMapIterable<?, ?> actualMap) {
        try {
            Verify.assertSortedMapsEqual("sortedMaps", expectedMap, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSortedMapsEqual(String mapName, SortedMapIterable<?, ?> expectedMap, SortedMapIterable<?, ?> actualMap) {
        try {
            Assert.assertEquals((String)mapName, expectedMap, actualMap);
            Verify.assertIterablesEqual(mapName, expectedMap, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterablesEqual(Iterable<?> expectedIterable, Iterable<?> actualIterable) {
        try {
            Verify.assertIterablesEqual("iterables", expectedIterable, actualIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertIterablesEqual(String iterableName, Iterable<?> expectedIterable, Iterable<?> actualIterable) {
        try {
            if (expectedIterable == null) {
                Assert.assertNull((String)(iterableName + " should be null"), actualIterable);
                return;
            }
            Verify.assertObjectNotNull(iterableName, actualIterable);
            if (expectedIterable instanceof InternalIterable && actualIterable instanceof InternalIterable) {
                FastList expectedList = FastList.newList();
                FastList actualList = FastList.newList();
                ((InternalIterable)expectedIterable).forEach((Procedure)CollectionAddProcedure.on((Collection)expectedList));
                ((InternalIterable)actualIterable).forEach((Procedure)CollectionAddProcedure.on((Collection)actualList));
                Verify.assertListsEqual(iterableName, expectedList, actualList);
            } else {
                Iterator<?> expectedIterator = expectedIterable.iterator();
                Iterator<?> actualIterator = actualIterable.iterator();
                int index = 0;
                while (expectedIterator.hasNext() && actualIterator.hasNext()) {
                    Object eachActual;
                    Object eachExpected = expectedIterator.next();
                    if (!Comparators.nullSafeEquals(eachExpected, eachActual = actualIterator.next())) {
                        junit.framework.Assert.failNotEquals((String)(iterableName + " first differed at element [" + index + "];"), eachExpected, eachActual);
                    }
                    ++index;
                }
                Assert.assertFalse((String)("Actual " + iterableName + " had " + index + " elements but expected " + iterableName + " had more."), (boolean)expectedIterator.hasNext());
                Assert.assertFalse((String)("Expected " + iterableName + " had " + index + " elements but actual " + iterableName + " had more."), (boolean)actualIterator.hasNext());
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertMapsEqual(Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        try {
            Verify.assertMapsEqual("map", expectedMap, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertMapsEqual(String mapName, Map<?, ?> expectedMap, Map<?, ?> actualMap) {
        try {
            if (expectedMap == null) {
                Assert.assertNull((String)(mapName + " should be null"), actualMap);
                return;
            }
            Assert.assertNotNull((String)(mapName + " should not be null"), actualMap);
            Set<Map.Entry<?, ?>> expectedEntries = expectedMap.entrySet();
            for (Map.Entry<?, ?> expectedEntry : expectedEntries) {
                Object expectedKey = expectedEntry.getKey();
                Object expectedValue = expectedEntry.getValue();
                Object actualValue = actualMap.get(expectedKey);
                if (Comparators.nullSafeEquals(actualValue, expectedValue)) continue;
                Assert.fail((String)("Values differ at key " + expectedKey + " expected " + expectedValue + " but was " + actualValue));
            }
            Verify.assertSetsEqual(mapName + " keys", expectedMap.keySet(), actualMap.keySet());
            Verify.assertSetsEqual(mapName + " entries", expectedMap.entrySet(), actualMap.entrySet());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertBagsEqual(Bag<?> expectedBag, Bag<?> actualBag) {
        try {
            Verify.assertBagsEqual("bag", expectedBag, actualBag);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertBagsEqual(String bagName, Bag<?> expectedBag, Bag<?> actualBag) {
        try {
            if (expectedBag == null) {
                Assert.assertNull((String)(bagName + " should be null"), actualBag);
                return;
            }
            Assert.assertNotNull((String)(bagName + " should not be null"), actualBag);
            Assert.assertEquals((String)(bagName + " size"), (long)expectedBag.size(), (long)actualBag.size());
            Assert.assertEquals((String)(bagName + " sizeDistinct"), (long)expectedBag.sizeDistinct(), (long)actualBag.sizeDistinct());
            expectedBag.forEachWithOccurrences((ObjectIntProcedure & Serializable)(expectedKey, expectedValue) -> {
                int actualValue = actualBag.occurrencesOf(expectedKey);
                Assert.assertEquals((String)("Occurrences of " + expectedKey), (long)expectedValue, (long)actualValue);
            });
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertListMultimapsEqual(ListMultimap<K, V> expectedListMultimap, ListMultimap<K, V> actualListMultimap) {
        try {
            Verify.assertListMultimapsEqual("ListMultimap", expectedListMultimap, actualListMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertListMultimapsEqual(String multimapName, ListMultimap<K, V> expectedListMultimap, ListMultimap<K, V> actualListMultimap) {
        try {
            if (expectedListMultimap == null) {
                Assert.assertNull((String)(multimapName + " should be null"), actualListMultimap);
                return;
            }
            Assert.assertNotNull((String)(multimapName + " should not be null"), actualListMultimap);
            Assert.assertEquals((String)(multimapName + " size"), (long)expectedListMultimap.size(), (long)actualListMultimap.size());
            Verify.assertBagsEqual(multimapName + " keyBag", expectedListMultimap.keyBag(), actualListMultimap.keyBag());
            for (Object key : expectedListMultimap.keysView()) {
                Verify.assertListsEqual(multimapName + " value list for key:" + key, (List)expectedListMultimap.get(key), (List)actualListMultimap.get(key));
            }
            Assert.assertEquals((String)multimapName, expectedListMultimap, actualListMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertSetMultimapsEqual(SetMultimap<K, V> expectedSetMultimap, SetMultimap<K, V> actualSetMultimap) {
        try {
            Verify.assertSetMultimapsEqual("SetMultimap", expectedSetMultimap, actualSetMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertSetMultimapsEqual(String multimapName, SetMultimap<K, V> expectedSetMultimap, SetMultimap<K, V> actualSetMultimap) {
        try {
            if (expectedSetMultimap == null) {
                Assert.assertNull((String)(multimapName + " should be null"), actualSetMultimap);
                return;
            }
            Assert.assertNotNull((String)(multimapName + " should not be null"), actualSetMultimap);
            Assert.assertEquals((String)(multimapName + " size"), (long)expectedSetMultimap.size(), (long)actualSetMultimap.size());
            Verify.assertBagsEqual(multimapName + " keyBag", expectedSetMultimap.keyBag(), actualSetMultimap.keyBag());
            for (Object key : expectedSetMultimap.keysView()) {
                Verify.assertSetsEqual(multimapName + " value set for key:" + key, (Set)expectedSetMultimap.get(key), (Set)actualSetMultimap.get(key));
            }
            Assert.assertEquals((String)multimapName, expectedSetMultimap, actualSetMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertBagMultimapsEqual(BagMultimap<K, V> expectedBagMultimap, BagMultimap<K, V> actualBagMultimap) {
        try {
            Verify.assertBagMultimapsEqual("BagMultimap", expectedBagMultimap, actualBagMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertBagMultimapsEqual(String multimapName, BagMultimap<K, V> expectedBagMultimap, BagMultimap<K, V> actualBagMultimap) {
        try {
            if (expectedBagMultimap == null) {
                Assert.assertNull((String)(multimapName + " should be null"), actualBagMultimap);
                return;
            }
            Assert.assertNotNull((String)(multimapName + " should not be null"), actualBagMultimap);
            Assert.assertEquals((String)(multimapName + " size"), (long)expectedBagMultimap.size(), (long)actualBagMultimap.size());
            Verify.assertBagsEqual(multimapName + " keyBag", expectedBagMultimap.keyBag(), actualBagMultimap.keyBag());
            for (Object key : expectedBagMultimap.keysView()) {
                Verify.assertBagsEqual(multimapName + " value bag for key:" + key, expectedBagMultimap.get(key), actualBagMultimap.get(key));
            }
            Assert.assertEquals((String)multimapName, expectedBagMultimap, actualBagMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertSortedSetMultimapsEqual(SortedSetMultimap<K, V> expectedSortedSetMultimap, SortedSetMultimap<K, V> actualSortedSetMultimap) {
        try {
            Verify.assertSortedSetMultimapsEqual("SortedSetMultimap", expectedSortedSetMultimap, actualSortedSetMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertSortedSetMultimapsEqual(String multimapName, SortedSetMultimap<K, V> expectedSortedSetMultimap, SortedSetMultimap<K, V> actualSortedSetMultimap) {
        try {
            if (expectedSortedSetMultimap == null) {
                Assert.assertNull((String)(multimapName + " should be null"), actualSortedSetMultimap);
                return;
            }
            Assert.assertNotNull((String)(multimapName + " should not be null"), actualSortedSetMultimap);
            Assert.assertEquals((String)(multimapName + " size"), (long)expectedSortedSetMultimap.size(), (long)actualSortedSetMultimap.size());
            Verify.assertBagsEqual(multimapName + " keyBag", expectedSortedSetMultimap.keyBag(), actualSortedSetMultimap.keyBag());
            for (Object key : expectedSortedSetMultimap.keysView()) {
                Verify.assertSortedSetsEqual(multimapName + " value set for key:" + key, (SortedSet)expectedSortedSetMultimap.get(key), (SortedSet)actualSortedSetMultimap.get(key));
            }
            Assert.assertEquals((String)multimapName, expectedSortedSetMultimap, actualSortedSetMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertSortedBagMultimapsEqual(SortedBagMultimap<K, V> expectedSortedBagMultimap, SortedBagMultimap<K, V> actualSortedBagMultimap) {
        try {
            Verify.assertSortedBagMultimapsEqual("SortedBagMultimap", expectedSortedBagMultimap, actualSortedBagMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertSortedBagMultimapsEqual(String multimapName, SortedBagMultimap<K, V> expectedSortedBagMultimap, SortedBagMultimap<K, V> actualSortedBagMultimap) {
        try {
            if (expectedSortedBagMultimap == null) {
                Assert.assertNull((String)(multimapName + " should be null"), actualSortedBagMultimap);
                return;
            }
            Assert.assertNotNull((String)(multimapName + " should not be null"), actualSortedBagMultimap);
            Assert.assertEquals((String)(multimapName + " size"), (long)expectedSortedBagMultimap.size(), (long)actualSortedBagMultimap.size());
            Verify.assertBagsEqual(multimapName + " keyBag", expectedSortedBagMultimap.keyBag(), actualSortedBagMultimap.keyBag());
            for (Object key : expectedSortedBagMultimap.keysView()) {
                Verify.assertSortedBagsEqual(multimapName + " value set for key:" + key, expectedSortedBagMultimap.get(key), actualSortedBagMultimap.get(key));
            }
            Assert.assertEquals((String)multimapName, expectedSortedBagMultimap, actualSortedBagMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsKeys(String mapName, Map<?, ?> actualMap, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedKeys = Lists.mutable.of();
            for (int i = 0; i < expectedKeyValues.length; i += 2) {
                expectedKeys.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(mapName + ".keySet()", actualMap.keySet(), expectedKeys.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsValues(String mapName, Map<?, ?> actualMap, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            UnifiedMap missingEntries = UnifiedMap.newMap();
            int i = 0;
            while (i < expectedKeyValues.length) {
                Object expectedKey;
                Object actualValue;
                Object expectedValue;
                if (Comparators.nullSafeEquals((Object)(expectedValue = expectedKeyValues[i++]), actualValue = actualMap.get(expectedKey = expectedKeyValues[i++]))) continue;
                missingEntries.put(expectedKey, (Object)("expectedValue:<" + expectedValue + ">, actualValue:<" + actualValue + '>'));
            }
            if (!missingEntries.isEmpty()) {
                StringBuilder buf = new StringBuilder(mapName + " has incorrect values for keys:[");
                for (Map.Entry expectedEntry : missingEntries.entrySet()) {
                    buf.append("key:<").append(expectedEntry.getKey()).append(',').append((String)expectedEntry.getValue()).append("> ");
                }
                buf.append(']');
                Assert.fail((String)buf.toString());
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsKeys(String mapIterableName, MapIterable<?, ?> mapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedKeys = Lists.mutable.of();
            for (int i = 0; i < expectedKeyValues.length; i += 2) {
                expectedKeys.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(mapIterableName + ".keysView()", mapIterable.keysView(), expectedKeys.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsValues(String mapIterableName, MapIterable<?, ?> mapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedValues = Lists.mutable.of();
            for (int i = 1; i < expectedKeyValues.length; i += 2) {
                expectedValues.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(mapIterableName + ".valuesView()", mapIterable.valuesView(), expectedValues.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsKeys(String mutableMapIterableName, MutableMapIterable<?, ?> mutableMapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedKeys = Lists.mutable.of();
            for (int i = 0; i < expectedKeyValues.length; i += 2) {
                expectedKeys.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(mutableMapIterableName + ".keysView()", mutableMapIterable.keysView(), expectedKeys.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsValues(String mutableMapIterableName, MutableMapIterable<?, ?> mutableMapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedValues = Lists.mutable.of();
            for (int i = 1; i < expectedKeyValues.length; i += 2) {
                expectedValues.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(mutableMapIterableName + ".valuesView()", mutableMapIterable.valuesView(), expectedValues.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsKeys(String immutableMapIterableName, ImmutableMapIterable<?, ?> immutableMapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedKeys = Lists.mutable.of();
            for (int i = 0; i < expectedKeyValues.length; i += 2) {
                expectedKeys.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(immutableMapIterableName + ".keysView()", immutableMapIterable.keysView(), expectedKeys.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static void assertMapContainsValues(String immutableMapIterableName, ImmutableMapIterable<?, ?> immutableMapIterable, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            MutableList expectedValues = Lists.mutable.of();
            for (int i = 1; i < expectedKeyValues.length; i += 2) {
                expectedValues.add(expectedKeyValues[i]);
            }
            Verify.assertContainsAll(immutableMapIterableName + ".valuesView()", immutableMapIterable.valuesView(), expectedValues.toArray());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertContainsEntry(K expectedKey, V expectedValue, Multimap<K, V> actualMultimap) {
        try {
            Verify.assertContainsEntry("multimap", expectedKey, expectedValue, actualMultimap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <K, V> void assertContainsEntry(String multimapName, K expectedKey, V expectedValue, Multimap<K, V> actualMultimap) {
        try {
            Assert.assertNotNull((String)multimapName, actualMultimap);
            if (!actualMultimap.containsKeyAndValue(expectedKey, expectedValue)) {
                Assert.fail((String)(multimapName + " did not contain entry: <" + expectedKey + ", " + expectedValue + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllEntries(Multimap<?, ?> actualMultimap, Object ... keyValues) {
        try {
            Verify.assertContainsAllEntries("multimap", actualMultimap, keyValues);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsAllEntries(String multimapName, Multimap<?, ?> actualMultimap, Object ... expectedKeyValues) {
        try {
            Verify.assertNotEmpty("Expected keys/values in assertion", expectedKeyValues);
            if (expectedKeyValues.length % 2 != 0) {
                Assert.fail((String)"Odd number of keys and values (every key must have a value)");
            }
            Verify.assertObjectNotNull(multimapName, actualMultimap);
            MutableList missingEntries = Lists.mutable.of();
            for (int i = 0; i < expectedKeyValues.length; i += 2) {
                Object expectedKey = expectedKeyValues[i];
                Object expectedValue = expectedKeyValues[i + 1];
                if (actualMultimap.containsKeyAndValue(expectedKey, expectedValue)) continue;
                missingEntries.add((Object)new ImmutableEntry(expectedKey, expectedValue));
            }
            if (!missingEntries.isEmpty()) {
                Assert.fail((String)(multimapName + " is missing entries: " + missingEntries));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void denyContainsAny(String collectionName, Collection<?> actualCollection, Object ... items) {
        try {
            Verify.assertNotEmpty("Expected items in assertion", items);
            Verify.assertObjectNotNull(collectionName, actualCollection);
            MutableSet intersection = Sets.intersect((Set)UnifiedSet.newSet(actualCollection), (Set)UnifiedSet.newSetWith((Object[])items));
            if (intersection.notEmpty()) {
                Assert.fail((String)(collectionName + " has an intersection with these items and should not :<" + intersection + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(Object expectedKey, Map<?, ?> actualMap) {
        try {
            Verify.assertContainsKey("map", expectedKey, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(String mapName, Object expectedKey, Map<?, ?> actualMap) {
        try {
            Assert.assertNotNull((String)mapName, actualMap);
            if (!actualMap.containsKey(expectedKey)) {
                Assert.fail((String)(mapName + " did not contain expectedKey:<" + expectedKey + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(Object expectedKey, MapIterable<?, ?> mapIterable) {
        try {
            Verify.assertContainsKey("map", expectedKey, mapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(String mapIterableName, Object expectedKey, MapIterable<?, ?> mapIterable) {
        try {
            Assert.assertNotNull((String)mapIterableName, mapIterable);
            if (!mapIterable.containsKey(expectedKey)) {
                Assert.fail((String)(mapIterableName + " did not contain expectedKey:<" + expectedKey + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(Object expectedKey, MutableMapIterable<?, ?> mutableMapIterable) {
        try {
            Verify.assertContainsKey("map", expectedKey, mutableMapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(String mutableMapIterableName, Object expectedKey, MutableMapIterable<?, ?> mutableMapIterable) {
        try {
            Assert.assertNotNull((String)mutableMapIterableName, mutableMapIterable);
            if (!mutableMapIterable.containsKey(expectedKey)) {
                Assert.fail((String)(mutableMapIterableName + " did not contain expectedKey:<" + expectedKey + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(Object expectedKey, ImmutableMapIterable<?, ?> immutableMapIterable) {
        try {
            Verify.assertContainsKey("map", expectedKey, immutableMapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKey(String immutableMapIterableName, Object expectedKey, ImmutableMapIterable<?, ?> immutableMapIterable) {
        try {
            Assert.assertNotNull((String)immutableMapIterableName, immutableMapIterable);
            if (!immutableMapIterable.containsKey(expectedKey)) {
                Assert.fail((String)(immutableMapIterableName + " did not contain expectedKey:<" + expectedKey + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void denyContainsKey(Object unexpectedKey, Map<?, ?> actualMap) {
        try {
            Verify.denyContainsKey("map", unexpectedKey, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void denyContainsKey(String mapName, Object unexpectedKey, Map<?, ?> actualMap) {
        try {
            Assert.assertNotNull((String)mapName, actualMap);
            if (actualMap.containsKey(unexpectedKey)) {
                Assert.fail((String)(mapName + " contained unexpectedKey:<" + unexpectedKey + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, Map<?, ?> actualMap) {
        try {
            Verify.assertContainsKeyValue("map", expectedKey, expectedValue, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(String mapName, Object expectedKey, Object expectedValue, Map<?, ?> actualMap) {
        try {
            Verify.assertContainsKey(mapName, expectedKey, actualMap);
            Object actualValue = actualMap.get(expectedKey);
            if (!Comparators.nullSafeEquals(actualValue, (Object)expectedValue)) {
                Assert.fail((String)(mapName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, MapIterable<?, ?> mapIterable) {
        try {
            Verify.assertContainsKeyValue("map", expectedKey, expectedValue, mapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(String mapIterableName, Object expectedKey, Object expectedValue, MapIterable<?, ?> mapIterable) {
        try {
            Verify.assertContainsKey(mapIterableName, expectedKey, mapIterable);
            Object actualValue = mapIterable.get(expectedKey);
            if (!Comparators.nullSafeEquals((Object)actualValue, (Object)expectedValue)) {
                Assert.fail((String)(mapIterableName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, MutableMapIterable<?, ?> mapIterable) {
        try {
            Verify.assertContainsKeyValue("map", expectedKey, expectedValue, mapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(String mapIterableName, Object expectedKey, Object expectedValue, MutableMapIterable<?, ?> mutableMapIterable) {
        try {
            Verify.assertContainsKey(mapIterableName, expectedKey, mutableMapIterable);
            Object actualValue = mutableMapIterable.get(expectedKey);
            if (!Comparators.nullSafeEquals((Object)actualValue, (Object)expectedValue)) {
                Assert.fail((String)(mapIterableName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(Object expectedKey, Object expectedValue, ImmutableMapIterable<?, ?> mapIterable) {
        try {
            Verify.assertContainsKeyValue("map", expectedKey, expectedValue, mapIterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertContainsKeyValue(String mapIterableName, Object expectedKey, Object expectedValue, ImmutableMapIterable<?, ?> immutableMapIterable) {
        try {
            Verify.assertContainsKey(mapIterableName, expectedKey, immutableMapIterable);
            Object actualValue = immutableMapIterable.get(expectedKey);
            if (!Comparators.nullSafeEquals((Object)actualValue, (Object)expectedValue)) {
                Assert.fail((String)(mapIterableName + " entry with expectedKey:<" + expectedKey + "> did not contain expectedValue:<" + expectedValue + ">, but had actualValue:<" + actualValue + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContains(Object unexpectedItem, Collection<?> actualCollection) {
        try {
            Verify.assertNotContains("collection", unexpectedItem, actualCollection);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContains(String collectionName, Object unexpectedItem, Collection<?> actualCollection) {
        try {
            Verify.assertObjectNotNull(collectionName, actualCollection);
            if (actualCollection.contains(unexpectedItem)) {
                Assert.fail((String)(collectionName + " should not contain unexpectedItem:<" + unexpectedItem + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContains(Object unexpectedItem, Iterable<?> iterable) {
        try {
            Verify.assertNotContains("iterable", unexpectedItem, iterable);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContains(String collectionName, Object unexpectedItem, Iterable<?> iterable) {
        try {
            Verify.assertObjectNotNull(collectionName, iterable);
            if (Iterate.contains(iterable, (Object)unexpectedItem)) {
                Assert.fail((String)(collectionName + " should not contain unexpectedItem:<" + unexpectedItem + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContainsKey(Object unexpectedKey, Map<?, ?> actualMap) {
        try {
            Verify.assertNotContainsKey("map", unexpectedKey, actualMap);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNotContainsKey(String mapName, Object unexpectedKey, Map<?, ?> actualMap) {
        try {
            Verify.assertObjectNotNull(mapName, actualMap);
            if (actualMap.containsKey(unexpectedKey)) {
                Assert.fail((String)(mapName + " should not contain unexpectedItem:<" + unexpectedKey + '>'));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertBefore(Object formerItem, Object latterItem, List<?> actualList) {
        try {
            Verify.assertBefore("list", formerItem, latterItem, actualList);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertBefore(String listName, Object formerItem, Object latterItem, List<?> actualList) {
        try {
            Verify.assertObjectNotNull(listName, actualList);
            Verify.assertNotEquals("Bad test, formerItem and latterItem are equal, listName:<" + listName + '>', formerItem, latterItem);
            Verify.assertContainsAll(listName, actualList, formerItem, latterItem);
            int formerPosition = actualList.indexOf(formerItem);
            int latterPosition = actualList.indexOf(latterItem);
            if (latterPosition < formerPosition) {
                Assert.fail((String)("Items in " + listName + " are in incorrect order; expected formerItem:<" + formerItem + "> to appear before latterItem:<" + latterItem + ">, but didn't"));
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertObjectNotNull(String objectName, Object actualObject) {
        try {
            Assert.assertNotNull((String)(objectName + " should not be null"), (Object)actualObject);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertItemAtIndex(Object expectedItem, int index, List<?> list) {
        try {
            Verify.assertItemAtIndex("list", expectedItem, index, list);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertItemAtIndex(Object expectedItem, int index, Object[] array) {
        try {
            Verify.assertItemAtIndex("array", expectedItem, index, array);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertStartsWith(T[] array, T ... items) {
        try {
            Verify.assertNotEmpty("Expected items in assertion", items);
            for (int i = 0; i < items.length; ++i) {
                T item = items[i];
                Verify.assertItemAtIndex("array", item, i, array);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertStartsWith(List<T> list, T ... items) {
        try {
            Verify.assertStartsWith("list", list, items);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertStartsWith(String listName, List<T> list, T ... items) {
        try {
            Verify.assertNotEmpty("Expected items in assertion", items);
            for (int i = 0; i < items.length; ++i) {
                T item = items[i];
                Verify.assertItemAtIndex(listName, item, i, list);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertEndsWith(List<T> list, T ... items) {
        try {
            Verify.assertNotEmpty("Expected items in assertion", items);
            for (int i = 0; i < items.length; ++i) {
                T item = items[i];
                Verify.assertItemAtIndex("list", item, list.size() - items.length + i, list);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertEndsWith(T[] array, T ... items) {
        try {
            Verify.assertNotEmpty("Expected items in assertion", items);
            for (int i = 0; i < items.length; ++i) {
                T item = items[i];
                Verify.assertItemAtIndex("array", item, array.length - items.length + i, array);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertItemAtIndex(String listName, Object expectedItem, int index, List<?> list) {
        try {
            Verify.assertObjectNotNull(listName, list);
            Object actualItem = list.get(index);
            if (!Comparators.nullSafeEquals((Object)expectedItem, actualItem)) {
                Assert.assertEquals((String)(listName + " has incorrect element at index:<" + index + '>'), (Object)expectedItem, actualItem);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertItemAtIndex(String arrayName, Object expectedItem, int index, Object[] array) {
        try {
            Assert.assertNotNull((Object)array);
            Object actualItem = array[index];
            if (!Comparators.nullSafeEquals((Object)expectedItem, (Object)actualItem)) {
                Assert.assertEquals((String)(arrayName + " has incorrect element at index:<" + index + '>'), (Object)expectedItem, (Object)actualItem);
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertPostSerializedEqualsAndHashCode(Object object) {
        try {
            Object deserialized = SerializeTestHelper.serializeDeserialize(object);
            Verify.assertEqualsAndHashCode("objects", object, deserialized);
            Assert.assertNotSame((String)"not same object", (Object)object, (Object)deserialized);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertPostSerializedIdentity(Object object) {
        try {
            Object deserialized = SerializeTestHelper.serializeDeserialize(object);
            Verify.assertEqualsAndHashCode("objects", object, deserialized);
            Assert.assertSame((String)"same object", (Object)object, (Object)deserialized);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSerializedForm(String expectedBase64Form, Object actualObject) {
        try {
            Verify.assertInstanceOf(Serializable.class, actualObject);
            Assert.assertEquals((String)"Serialization was broken.", (Object)expectedBase64Form, (Object)Verify.encodeObject(actualObject));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertSerializedForm(long expectedSerialVersionUID, String expectedBase64Form, Object actualObject) {
        try {
            Verify.assertInstanceOf(Serializable.class, actualObject);
            Assert.assertEquals((String)"Serialization was broken.", (Object)expectedBase64Form, (Object)Verify.encodeObject(actualObject));
            Object decodeToObject = Verify.decodeObject(expectedBase64Form);
            Assert.assertEquals((String)"serialVersionUID's differ", (long)expectedSerialVersionUID, (long)ObjectStreamClass.lookup(decodeToObject.getClass()).getSerialVersionUID());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertDeserializedForm(String expectedBase64Form, Object actualObject) {
        try {
            Verify.assertInstanceOf(Serializable.class, actualObject);
            Object decodeToObject = Verify.decodeObject(expectedBase64Form);
            Assert.assertEquals((String)"Serialization was broken.", (Object)decodeToObject, (Object)actualObject);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static Object decodeObject(String expectedBase64Form) {
        try {
            byte[] bytes = Base64.decodeBase64((String)expectedBase64Form);
            return new ObjectInputStream(new ByteArrayInputStream(bytes)).readObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String encodeObject(Object actualObject) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(actualObject);
            objectOutputStream.flush();
            objectOutputStream.close();
            String string = new Base64(76, LINE_SEPARATOR, false).encodeAsString(byteArrayOutputStream.toByteArray());
            String trimmedString = Verify.removeFinalNewline(string);
            return Verify.addFinalNewline(trimmedString);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static String removeFinalNewline(String string) {
        return string.substring(0, string.length() - 1);
    }

    private static String addFinalNewline(String string) {
        if (string.length() % 77 == 76) {
            return string + '\n';
        }
        return string;
    }

    public static void assertNotSerializable(Object actualObject) {
        try {
            Verify.assertThrows(NotSerializableException.class, () -> {
                new ObjectOutputStream(new ByteArrayOutputStream()).writeObject(actualObject);
                return null;
            });
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEqualsAndHashCode(Object objectA, Object objectB) {
        try {
            Verify.assertEqualsAndHashCode("objects", objectA, objectB);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertNegative(int value) {
        try {
            Assert.assertTrue((String)(value + " is not negative"), (value < 0 ? 1 : 0) != 0);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertPositive(int value) {
        try {
            Assert.assertTrue((String)(value + " is not positive"), (value > 0 ? 1 : 0) != 0);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertZero(int value) {
        try {
            Assert.assertEquals((long)0L, (long)value);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertEqualsAndHashCode(String itemNames, Object objectA, Object objectB) {
        try {
            if (objectA == null || objectB == null) {
                Assert.fail((String)("Neither item should be null: <" + objectA + "> <" + objectB + '>'));
            }
            Assert.assertFalse((String)"Neither item should equal null", (boolean)objectA.equals(null));
            Assert.assertFalse((String)"Neither item should equal null", (boolean)objectB.equals(null));
            Verify.assertNotEquals((Object)"Neither item should equal new Object()", (Object)objectA.equals(new Object()));
            Verify.assertNotEquals((Object)"Neither item should equal new Object()", (Object)objectB.equals(new Object()));
            Assert.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectA, (Object)objectA);
            Assert.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectB, (Object)objectB);
            Assert.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectA, (Object)objectB);
            Assert.assertEquals((String)("Expected " + itemNames + " to be equal."), (Object)objectB, (Object)objectA);
            Assert.assertEquals((String)("Expected " + itemNames + " to have the same hashCode()."), (long)objectA.hashCode(), (long)objectB.hashCode());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertShallowClone(Cloneable object) {
        try {
            Verify.assertShallowClone("object", object);
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    @Deprecated
    public static void assertShallowClone(String itemName, Cloneable object) {
        try {
            Method method = Object.class.getDeclaredMethod("clone", null);
            method.setAccessible(true);
            Object clone = method.invoke((Object)object, new Object[0]);
            String prefix = itemName + " and its clone";
            Assert.assertNotSame((String)prefix, (Object)object, (Object)clone);
            Verify.assertEqualsAndHashCode(prefix, object, clone);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e.getLocalizedMessage());
        }
        catch (InvocationTargetException e) {
            throw new AssertionError((Object)e.getLocalizedMessage());
        }
        catch (SecurityException e) {
            throw new AssertionError((Object)e.getLocalizedMessage());
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e.getLocalizedMessage());
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e.getLocalizedMessage());
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static <T> void assertClassNonInstantiable(Class<T> aClass) {
        try {
            try {
                aClass.newInstance();
                Assert.fail((String)("Expected class '" + aClass + "' to be non-instantiable"));
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException e) {
                if (Verify.canInstantiateThroughReflection(aClass)) {
                    Assert.fail((String)("Expected constructor of non-instantiable class '" + aClass + "' to throw an exception, but didn't"));
                }
            }
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    private static <T> boolean canInstantiateThroughReflection(Class<T> aClass) {
        try {
            Constructor<T> declaredConstructor = aClass.getDeclaredConstructor(new Class[0]);
            declaredConstructor.setAccessible(true);
            declaredConstructor.newInstance(new Object[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            return false;
        }
        catch (InstantiationException e) {
            return false;
        }
        catch (IllegalAccessException e) {
            return false;
        }
        catch (AssertionError e) {
            return false;
        }
    }

    public static void assertError(Class<? extends Error> expectedErrorClass, Runnable code) {
        try {
            code.run();
        }
        catch (Error ex) {
            try {
                Assert.assertSame((String)("Caught error of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedErrorClass.getName() + '>'), expectedErrorClass, ex.getClass());
                return;
            }
            catch (AssertionError e) {
                Verify.throwMangledException(e);
            }
        }
        try {
            Assert.fail((String)("Block did not throw an error of type " + expectedErrorClass.getName()));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertThrows(Class<? extends Exception> expectedExceptionClass, Callable<?> code) {
        try {
            code.call();
        }
        catch (Exception ex) {
            try {
                Assert.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + '>' + '\n' + "Exception Message: " + ex.getMessage() + '\n'), expectedExceptionClass, ex.getClass());
                return;
            }
            catch (AssertionError e) {
                Verify.throwMangledException(e);
            }
        }
        try {
            Assert.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertThrows(Class<? extends Exception> expectedExceptionClass, Runnable code) {
        try {
            code.run();
        }
        catch (RuntimeException ex) {
            try {
                Assert.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + '>' + '\n' + "Exception Message: " + ex.getMessage() + '\n'), expectedExceptionClass, ex.getClass());
                return;
            }
            catch (AssertionError e) {
                Verify.throwMangledException(e);
            }
        }
        try {
            Assert.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertThrowsWithCause(Class<? extends Exception> expectedExceptionClass, Class<? extends Throwable> expectedCauseClass, Callable<?> code) {
        try {
            code.call();
        }
        catch (Exception ex) {
            try {
                Assert.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + '>'), expectedExceptionClass, ex.getClass());
                Throwable actualCauseClass = ex.getCause();
                Assert.assertNotNull((String)("Caught exception with null cause, expected cause of type <" + expectedCauseClass.getName() + '>'), (Object)actualCauseClass);
                Assert.assertSame((String)("Caught exception with cause of type<" + actualCauseClass.getClass().getName() + ">, expected cause of type <" + expectedCauseClass.getName() + '>'), expectedCauseClass, actualCauseClass.getClass());
                return;
            }
            catch (AssertionError e) {
                Verify.throwMangledException(e);
            }
        }
        try {
            Assert.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }

    public static void assertThrowsWithCause(Class<? extends Exception> expectedExceptionClass, Class<? extends Throwable> expectedCauseClass, Runnable code) {
        try {
            code.run();
        }
        catch (RuntimeException ex) {
            try {
                Assert.assertSame((String)("Caught exception of type <" + ex.getClass().getName() + ">, expected one of type <" + expectedExceptionClass.getName() + '>'), expectedExceptionClass, ex.getClass());
                Throwable actualCauseClass = ex.getCause();
                Assert.assertNotNull((String)("Caught exception with null cause, expected cause of type <" + expectedCauseClass.getName() + '>'), (Object)actualCauseClass);
                Assert.assertSame((String)("Caught exception with cause of type<" + actualCauseClass.getClass().getName() + ">, expected cause of type <" + expectedCauseClass.getName() + '>'), expectedCauseClass, actualCauseClass.getClass());
                return;
            }
            catch (AssertionError e) {
                Verify.throwMangledException(e);
            }
        }
        try {
            Assert.fail((String)("Block did not throw an exception of type " + expectedExceptionClass.getName()));
        }
        catch (AssertionError e) {
            Verify.throwMangledException(e);
        }
    }
}

