/*
 * Copyright (c) 2017 Goldman Sachs and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v. 1.0 which accompany this distribution.
 * The Eclipse Public License is available at http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 * http://www.eclipse.org/org/documents/edl-v10.php.
 */

package org.eclipse.collections.api.list.primitive;

import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.collection.primitive.ImmutableIntCollection;
import org.eclipse.collections.api.list.ImmutableList;

/**
 * This file was automatically generated from template file immutablePrimitiveList.stg.
 *
 * @since 3.0.
 */
public interface ImmutableIntList extends ImmutableIntCollection, IntList
{
    @Override
    ImmutableIntList select(IntPredicate predicate);

    @Override
    ImmutableIntList reject(IntPredicate predicate);

    /**
     * @since 9.0.
     */
    @Override
    default ImmutableIntList tap(IntProcedure procedure)
    {
        this.forEach(procedure);
        return this;
    }

    @Override
    <V> ImmutableList<V> collect(IntToObjectFunction<? extends V> function);

    @Override
    ImmutableIntList newWith(int element);

    @Override
    ImmutableIntList newWithout(int element);

    @Override
    ImmutableIntList newWithAll(IntIterable elements);

    @Override
    ImmutableIntList newWithoutAll(IntIterable elements);

    @Override
    ImmutableIntList toReversed();

    /**
     * @since 6.0.
     */
    @Override
    ImmutableIntList distinct();

    @Override
    ImmutableIntList subList(int fromIndex, int toIndex);
}
