/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api;

import java.util.Collection;
import org.eclipse.collections.api.LazyBooleanIterable;
import org.eclipse.collections.api.LazyByteIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyDoubleIterable;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Bags;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;

public interface LazyIterable<T>
extends RichIterable<T> {
    @Override
    public T getFirst();

    @Override
    default public ImmutableList<T> toImmutableList() {
        MutableList mutableList = Lists.mutable.empty();
        this.forEach(mutableList::add);
        return mutableList.toImmutable();
    }

    @Override
    default public ImmutableSet<T> toImmutableSet() {
        MutableSet mutableSet = Sets.mutable.empty();
        this.forEach(mutableSet::add);
        return mutableSet.toImmutable();
    }

    @Override
    default public ImmutableBag<T> toImmutableBag() {
        MutableBag mutableBag = Bags.mutable.empty();
        this.forEach(mutableBag::add);
        return mutableBag.toImmutable();
    }

    @Override
    default public Object[] toArray() {
        MutableList mutableList = Lists.mutable.empty();
        this.forEach(mutableList::add);
        return mutableList.toArray();
    }

    @Override
    default public <E> E[] toArray(E[] array) {
        MutableList mutableList = Lists.mutable.empty();
        this.forEach(mutableList::add);
        return mutableList.toArray((T1[])array);
    }

    @Override
    public LazyIterable<T> select(Predicate<? super T> var1);

    @Override
    public <P> LazyIterable<T> selectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <S> LazyIterable<S> selectInstancesOf(Class<S> var1);

    @Override
    public LazyIterable<T> reject(Predicate<? super T> var1);

    @Override
    public <P> LazyIterable<T> rejectWith(Predicate2<? super T, ? super P> var1, P var2);

    @Override
    public <V> LazyIterable<V> collect(Function<? super T, ? extends V> var1);

    @Override
    public <P, V> LazyIterable<V> collectWith(Function2<? super T, ? super P, ? extends V> var1, P var2);

    @Override
    public <V> LazyIterable<V> collectIf(Predicate<? super T> var1, Function<? super T, ? extends V> var2);

    public LazyIterable<T> take(int var1);

    public LazyIterable<T> drop(int var1);

    public LazyIterable<T> takeWhile(Predicate<? super T> var1);

    public LazyIterable<T> dropWhile(Predicate<? super T> var1);

    public LazyIterable<T> distinct();

    @Override
    public <V> LazyIterable<V> flatCollect(Function<? super T, ? extends Iterable<V>> var1);

    @Override
    default public <P, V> LazyIterable<V> flatCollectWith(Function2<? super T, ? super P, ? extends Iterable<V>> function, P parameter) {
        return this.flatCollect((T each) -> (Iterable)function.apply((Object)each, (Object)parameter));
    }

    public LazyIterable<T> concatenate(Iterable<T> var1);

    @Override
    public <S> LazyIterable<Pair<T, S>> zip(Iterable<S> var1);

    @Override
    public LazyIterable<Pair<T, Integer>> zipWithIndex();

    @Override
    public LazyIterable<RichIterable<T>> chunk(int var1);

    @Override
    public LazyIterable<T> tap(Procedure<? super T> var1);

    @Override
    public <R extends Collection<T>> R into(R var1);

    @Override
    public LazyBooleanIterable collectBoolean(BooleanFunction<? super T> var1);

    @Override
    public LazyByteIterable collectByte(ByteFunction<? super T> var1);

    @Override
    public LazyCharIterable collectChar(CharFunction<? super T> var1);

    @Override
    public LazyDoubleIterable collectDouble(DoubleFunction<? super T> var1);

    @Override
    public LazyFloatIterable collectFloat(FloatFunction<? super T> var1);

    @Override
    public LazyIntIterable collectInt(IntFunction<? super T> var1);

    @Override
    public LazyLongIterable collectLong(LongFunction<? super T> var1);

    @Override
    public LazyShortIterable collectShort(ShortFunction<? super T> var1);
}

