/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionJuggle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OptionJuggle.class);
    private static List<Integer> allEOptions = OptionJuggle.populateAllEOptions();

    private static List<Integer> populateAllEOptions() {
        ArrayList<Integer> allEOptions = new ArrayList<Integer>();
        allEOptions.add(1);
        allEOptions.add(4);
        allEOptions.add(5);
        allEOptions.add(6);
        allEOptions.add(8);
        allEOptions.add(11);
        allEOptions.add(12);
        allEOptions.add(14);
        allEOptions.add(15);
        allEOptions.add(17);
        allEOptions.add(20);
        allEOptions.add(23);
        allEOptions.add(27);
        allEOptions.add(28);
        allEOptions.add(60);
        return allEOptions;
    }

    public static OptionSet prepareUoptions(OptionSet options) {
        byte[] oscore;
        boolean hasProxyUri = options.hasProxyUri();
        boolean hasUriHost = options.hasUriHost();
        boolean hasUriPort = options.hasUriPort();
        boolean hasProxyScheme = options.hasProxyScheme();
        boolean hasMaxAge = options.hasMaxAge();
        boolean hasObserve = options.hasObserve();
        OptionSet ret = new OptionSet();
        if (hasUriHost) {
            ret.setUriHost(options.getUriHost());
        }
        if (hasUriPort) {
            ret.setUriPort(options.getUriPort());
        }
        if (hasMaxAge) {
            ret.setMaxAge(options.getMaxAge());
        }
        if (hasProxyScheme) {
            ret.setProxyScheme(options.getProxyScheme());
        }
        if (hasObserve) {
            ret.setObserve(options.getObserve());
        }
        if (hasProxyUri) {
            String proxyUri = options.getProxyUri();
            proxyUri = proxyUri.replace("coap://", "");
            int i = (proxyUri = proxyUri.replace("coaps://", "")).indexOf(47);
            if (i >= 0) {
                proxyUri = proxyUri.substring(0, i);
            }
            proxyUri = "coap://" + proxyUri;
            ret.setProxyUri(proxyUri);
        }
        if ((oscore = options.getOscore()) != null) {
            ret.setOscore(oscore);
        }
        return ret;
    }

    public static OptionSet prepareEoptions(OptionSet options) {
        OptionSet ret = new OptionSet();
        block4: for (Option o : options.asSortedList()) {
            switch (o.getNumber()) {
                case 3: 
                case 7: 
                case 9: 
                case 39: {
                    break;
                }
                case 35: {
                    String proxyUri = o.getStringValue();
                    proxyUri = proxyUri.replace("coap://", "");
                    int i = (proxyUri = proxyUri.replace("coaps://", "")).indexOf(47);
                    if (i < 0) continue block4;
                    proxyUri = proxyUri.substring(i + 1, proxyUri.length());
                    i = proxyUri.indexOf("?");
                    String uriPath = proxyUri;
                    String uriQuery = null;
                    if (i >= 0) {
                        uriPath = proxyUri.substring(0, i);
                        uriQuery = proxyUri.substring(i + 1, proxyUri.length());
                    }
                    if (uriPath != null) {
                        ret.setUriPath(uriPath);
                    }
                    if (uriQuery == null) continue block4;
                    String[] uriQueries = uriQuery.split("&");
                    for (int idx = 0; idx < uriQueries.length; ++idx) {
                        ret.setUriQuery(uriQueries[idx]);
                    }
                    continue block4;
                }
                default: {
                    ret.addOption(o);
                }
            }
        }
        return ret;
    }

    public static OptionSet discardEOptions(OptionSet optionSet) {
        LOGGER.trace("Removing inner only E options from the outer options");
        OptionSet result = new OptionSet();
        for (Option opt : optionSet.asSortedList()) {
            if (allEOptions.contains(opt.getNumber())) continue;
            result.addOption(opt);
        }
        return result;
    }

    public static Request setFakeCodeRequest(Request request) {
        CoAP.Code fakeCode = request.getOptions().hasObserve() ? CoAP.Code.FETCH : CoAP.Code.POST;
        return OptionJuggle.requestWithNewCode(request, fakeCode);
    }

    public static Request setRealCodeRequest(Request request, CoAP.Code realCode) {
        return OptionJuggle.requestWithNewCode(request, realCode);
    }

    public static Response setFakeCodeResponse(Response response) {
        return OptionJuggle.responseWithNewCode(response, CoAP.ResponseCode.CHANGED);
    }

    public static Response setRealCodeResponse(Response response, CoAP.ResponseCode realCode) {
        return OptionJuggle.responseWithNewCode(response, realCode);
    }

    private static Request requestWithNewCode(Request request, CoAP.Code code) {
        Request newRequest = new Request(code);
        OptionJuggle.copy(newRequest, request);
        newRequest.setUserContext(request.getUserContext());
        return newRequest;
    }

    private static Response responseWithNewCode(Response response, CoAP.ResponseCode code) {
        Long rtt = response.getApplicationRttNanos();
        Response newResponse = new Response(code);
        OptionJuggle.copy(newResponse, response);
        if (rtt != null) {
            newResponse.setApplicationRttNanos(rtt);
        }
        return newResponse;
    }

    private static void copy(Message newMessage, Message oldMessage) {
        newMessage.setOptions(oldMessage.getOptions());
        newMessage.setPayload(oldMessage.getPayload());
        newMessage.setToken(oldMessage.getToken());
        newMessage.setDestinationContext(oldMessage.getDestinationContext());
        newMessage.setSourceContext(oldMessage.getSourceContext());
        newMessage.addMessageObservers(oldMessage.getMessageObservers());
        newMessage.setMID(oldMessage.getMID());
        newMessage.setType(oldMessage.getType());
        newMessage.setDuplicate(oldMessage.isDuplicate());
        newMessage.setNanoTimestamp(oldMessage.getNanoTimestamp());
    }

    public static OptionSet merge(OptionSet eOptions, OptionSet uOptions) {
        List<Option> u = uOptions.asSortedList();
        for (Option tmp : u) {
            if (eOptions.hasOption(tmp.getNumber())) continue;
            eOptions.addOption(tmp);
        }
        return eOptions;
    }
}

