/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.tcp.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.util.List;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.RawData;
import org.eclipse.californium.elements.tcp.netty.TcpContextUtil;
import org.eclipse.californium.elements.util.ClockUtil;

class DatagramFramer
extends ByteToMessageDecoder {
    private final TcpContextUtil contextUtil;

    public DatagramFramer(TcpContextUtil contextUtil) {
        this.contextUtil = contextUtil;
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        while (in.readableBytes() > 0) {
            byte firstByte = in.getByte(in.readerIndex());
            int lengthNibble = (firstByte & 0xF0) >>> 4;
            int tokenNibble = firstByte & 0xF;
            int lengthFieldSize = this.getLengthFieldSize(lengthNibble);
            int coapHeaderSize = this.getCoapHeaderSize(lengthFieldSize, tokenNibble);
            if (in.readableBytes() < coapHeaderSize) {
                return;
            }
            int bodyLength = this.getBodyLength(in, lengthNibble, lengthFieldSize);
            if (in.readableBytes() < coapHeaderSize + bodyLength) {
                return;
            }
            byte[] data = new byte[coapHeaderSize + bodyLength];
            in.readBytes(data);
            Channel channel = ctx.channel();
            EndpointContext endpointContext = this.contextUtil.buildEndpointContext(channel);
            RawData rawData = RawData.inbound(data, endpointContext, false, ClockUtil.nanoRealtime(), (InetSocketAddress)channel.localAddress());
            out.add(rawData);
        }
    }

    private int getLengthFieldSize(int len) {
        if (len > 15 || len < 0) {
            throw new IllegalArgumentException("Invalid len field: " + len);
        }
        if (len == 13) {
            return 1;
        }
        if (len == 14) {
            return 2;
        }
        if (len == 15) {
            return 4;
        }
        return 0;
    }

    private int getBodyLength(ByteBuf in, int lengthNibble, int fieldSize) {
        byte[] data = new byte[fieldSize];
        in.getBytes(in.readerIndex() + 1, data);
        switch (fieldSize) {
            case 0: {
                return lengthNibble;
            }
            case 1: {
                return new BigInteger(1, data).intValue() + 13;
            }
            case 2: {
                return new BigInteger(1, data).intValue() + 269;
            }
            case 4: {
                return new BigInteger(1, data).intValue() + 65805;
            }
        }
        throw new IllegalArgumentException("Invalid field size: " + fieldSize);
    }

    private int getCoapHeaderSize(int lengthFieldSize, int tokenFieldSize) {
        return 2 + lengthFieldSize + tokenFieldSize;
    }
}

