/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.coap.option.BlockOption;
import org.eclipse.californium.cose.Encrypt0Message;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.oscore.ContextRederivation;
import org.eclipse.californium.oscore.Encryptor;
import org.eclipse.californium.oscore.OSCoreCtx;
import org.eclipse.californium.oscore.OSCoreCtxDB;
import org.eclipse.californium.oscore.OSException;
import org.eclipse.californium.oscore.OSSerializer;
import org.eclipse.californium.oscore.OptionJuggle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseEncryptor
extends Encryptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResponseEncryptor.class);

    public static Response encrypt(OSCoreCtxDB db, Response response, OSCoreCtx ctx, boolean newPartialIV, boolean outerBlockwise, int requestSequenceNr) throws OSException {
        if (ctx == null) {
            LOGGER.error("Context is null");
            throw new OSException("Context is null");
        }
        try {
            ctx = ContextRederivation.outgoingResponse(db, ctx);
            newPartialIV |= ctx.getResponsesIncludePartialIV();
            if (ctx.getContextRederivationPhase() == ContextRederivation.PHASE.SERVER_PHASE_2) {
                response = OptionJuggle.setRealCodeResponse(response, CoAP.ResponseCode.UNAUTHORIZED);
                response.setPayload(Bytes.EMPTY);
            }
        }
        catch (OSException e) {
            LOGGER.error("Security context re-generation failed");
            throw new OSException("Security context re-generation failed");
        }
        int realCode = response.getCode().value;
        response = OptionJuggle.setFakeCodeResponse(response);
        OptionSet options = response.getOptions();
        BlockOption block1Option = null;
        if (outerBlockwise) {
            block1Option = options.getBlock1();
            options.removeBlock1();
        }
        byte[] confidential = OSSerializer.serializeConfidentialData(options, response.getPayload(), realCode);
        Encrypt0Message enc = ResponseEncryptor.prepareCOSEStructure(confidential);
        byte[] cipherText = ResponseEncryptor.encryptAndEncode(enc, ctx, response, newPartialIV, requestSequenceNr);
        ResponseEncryptor.compression(ctx, cipherText, response, newPartialIV);
        options = response.getOptions();
        response.setOptions(OptionJuggle.prepareUoptions(options));
        if (outerBlockwise) {
            response.setOptions(response.getOptions().setBlock1(block1Option));
        }
        if (newPartialIV) {
            ctx.increaseSenderSeq();
        }
        return response;
    }
}

