/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.GroupedMessageIdTracker;
import org.eclipse.californium.core.network.MapBasedMessageIdTracker;
import org.eclipse.californium.core.network.MessageIdProvider;
import org.eclipse.californium.core.network.MessageIdTracker;
import org.eclipse.californium.core.network.NullMessageIdTracker;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.LeastRecentlyUpdatedCache;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMessageIdProvider
implements MessageIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMessageIdProvider.class);
    private final LeastRecentlyUpdatedCache<InetSocketAddress, MessageIdTracker> trackers;
    private final MessageIdTracker multicastTracker;
    private final CoapConfig.TrackerMode mode;
    private final Random random;
    private final Configuration config;
    private final int multicastBaseMid;

    public InMemoryMessageIdProvider(Configuration config) {
        CoapConfig.TrackerMode mode;
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        this.mode = mode = config.get(CoapConfig.MID_TRACKER);
        this.config = config;
        this.random = config.get(CoapConfig.USE_RANDOM_MID_START) != false ? new Random(ClockUtil.nanoRealtime()) : null;
        this.trackers = new LeastRecentlyUpdatedCache(config.get(CoapConfig.MAX_ACTIVE_PEERS), config.get(CoapConfig.MAX_PEER_INACTIVITY_PERIOD, TimeUnit.SECONDS), TimeUnit.SECONDS);
        int multicastBaseMid = config.get(CoapConfig.MULTICAST_BASE_MID);
        if (0 < multicastBaseMid) {
            this.multicastBaseMid = multicastBaseMid;
            int max = 65536;
            int mid = null == this.random ? multicastBaseMid : this.random.nextInt(max - multicastBaseMid) + multicastBaseMid;
            this.multicastTracker = this.createTracker(mid, multicastBaseMid, max, config);
        } else {
            this.multicastBaseMid = 65536;
            this.multicastTracker = null;
        }
    }

    @Override
    public int getNextMessageId(InetSocketAddress destination) {
        MessageIdTracker tracker = this.getTracker(destination);
        if (tracker == null) {
            String time = this.trackers.getExpirationThreshold(TimeUnit.SECONDS) + "s";
            throw new IllegalStateException("No MID available, max. peers " + this.trackers.size() + " exhausted! (Timeout " + time + ".)");
        }
        return tracker.getNextMessageId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageIdTracker getTracker(InetSocketAddress destination) {
        if (NetworkInterfacesUtil.isMultiAddress(destination.getAddress())) {
            if (this.multicastTracker == null) {
                LOG.warn("Destination address {} is a multicast address, please configure NetworkConfig to support multicast messaging", (Object)destination);
            }
            return this.multicastTracker;
        }
        MessageIdTracker tracker = this.trackers.get(destination);
        if (tracker == null) {
            int mid = null == this.random ? 0 : this.random.nextInt(this.multicastBaseMid);
            MessageIdTracker newTracker = this.createTracker(mid, 0, this.multicastBaseMid, this.config);
            this.trackers.writeLock().lock();
            try {
                tracker = this.trackers.get(destination);
                if (tracker == null) {
                    if (this.trackers.put(destination, newTracker)) {
                        MessageIdTracker messageIdTracker = newTracker;
                        return messageIdTracker;
                    }
                    MessageIdTracker messageIdTracker = null;
                    return messageIdTracker;
                }
            }
            finally {
                this.trackers.writeLock().unlock();
            }
        }
        if (tracker != null) {
            this.trackers.update(destination);
        }
        return tracker;
    }

    private MessageIdTracker createTracker(int initialMid, int minMid, int maxMid, Configuration config) {
        MessageIdTracker tracker;
        switch (this.mode) {
            case NULL: {
                tracker = new NullMessageIdTracker(initialMid, minMid, maxMid);
                break;
            }
            case MAPBASED: {
                tracker = new MapBasedMessageIdTracker(initialMid, minMid, maxMid, config);
                break;
            }
            default: {
                tracker = new GroupedMessageIdTracker(initialMid, minMid, maxMid, config);
            }
        }
        return tracker;
    }
}

