/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.core.coap.Option;
import org.eclipse.californium.core.coap.UriQueryParameter;
import org.eclipse.californium.core.coap.option.BlockOption;
import org.eclipse.californium.core.coap.option.EmptyOption;
import org.eclipse.californium.core.coap.option.IntegerOption;
import org.eclipse.californium.core.coap.option.NoResponseOption;
import org.eclipse.californium.core.coap.option.OpaqueOption;
import org.eclipse.californium.core.coap.option.OptionDefinition;
import org.eclipse.californium.core.coap.option.OptionNumber;
import org.eclipse.californium.core.coap.option.StandardOptionRegistry;
import org.eclipse.californium.core.coap.option.StringOption;

public final class OptionSet {
    private List<OpaqueOption> if_match_list;
    private StringOption uri_host;
    private List<OpaqueOption> etag_list;
    private EmptyOption if_none_match;
    private IntegerOption uri_port;
    private List<StringOption> location_path_list;
    private List<StringOption> uri_path_list;
    private IntegerOption content_format;
    private IntegerOption max_age;
    private List<StringOption> uri_query_list;
    private UriQueryParameter uri_query_parameter;
    private IntegerOption accept;
    private List<StringOption> location_query_list;
    private StringOption proxy_uri;
    private StringOption proxy_scheme;
    private BlockOption block1;
    private BlockOption block2;
    private IntegerOption size1;
    private IntegerOption size2;
    private IntegerOption observe;
    private OpaqueOption oscore;
    private NoResponseOption no_response;
    private List<Option> others;

    public OptionSet() {
        this.if_match_list = null;
        this.uri_host = null;
        this.etag_list = null;
        this.if_none_match = null;
        this.uri_port = null;
        this.location_path_list = null;
        this.uri_path_list = null;
        this.content_format = null;
        this.max_age = null;
        this.uri_query_list = null;
        this.uri_query_parameter = null;
        this.accept = null;
        this.location_query_list = null;
        this.proxy_uri = null;
        this.proxy_scheme = null;
        this.block1 = null;
        this.block2 = null;
        this.size1 = null;
        this.size2 = null;
        this.observe = null;
        this.oscore = null;
        this.no_response = null;
        this.others = null;
    }

    public OptionSet(OptionSet origin) {
        if (origin == null) {
            throw new NullPointerException("option set must not be null!");
        }
        this.if_match_list = OptionSet.copyList(origin.if_match_list);
        this.uri_host = origin.uri_host;
        this.etag_list = OptionSet.copyList(origin.etag_list);
        this.if_none_match = origin.if_none_match;
        this.uri_port = origin.uri_port;
        this.location_path_list = OptionSet.copyList(origin.location_path_list);
        this.uri_path_list = OptionSet.copyList(origin.uri_path_list);
        this.content_format = origin.content_format;
        this.max_age = origin.max_age;
        this.uri_query_list = OptionSet.copyList(origin.uri_query_list);
        this.uri_query_parameter = origin.uri_query_parameter;
        this.accept = origin.accept;
        this.location_query_list = OptionSet.copyList(origin.location_query_list);
        this.proxy_uri = origin.proxy_uri;
        this.proxy_scheme = origin.proxy_scheme;
        this.block1 = origin.block1;
        this.block2 = origin.block2;
        this.size1 = origin.size1;
        this.size2 = origin.size2;
        this.observe = origin.observe;
        this.oscore = origin.oscore;
        this.no_response = origin.no_response;
        this.others = OptionSet.copyList(origin.others);
    }

    public void clear() {
        OptionSet.clear(this.if_match_list);
        this.uri_host = null;
        OptionSet.clear(this.etag_list);
        this.if_none_match = null;
        this.uri_port = null;
        OptionSet.clear(this.location_path_list);
        OptionSet.clear(this.uri_path_list);
        this.content_format = null;
        this.max_age = null;
        OptionSet.clear(this.uri_query_list);
        this.uri_query_parameter = null;
        this.accept = null;
        OptionSet.clear(this.location_query_list);
        this.proxy_uri = null;
        this.proxy_scheme = null;
        this.block1 = null;
        this.block2 = null;
        this.size1 = null;
        this.size2 = null;
        this.observe = null;
        this.oscore = null;
        this.no_response = null;
        OptionSet.clear(this.others);
    }

    private static final int count(List<?> list) {
        return list == null ? 0 : list.size();
    }

    private static final void clear(List<?> list) {
        if (list != null) {
            list.clear();
        }
    }

    private static final <T> List<T> copyList(List<T> list) {
        if (list == null) {
            return null;
        }
        return new ArrayList<T>(list);
    }

    private static final <T> List<T> ensureList(List<T> list) {
        if (list == null) {
            list = new ArrayList<T>(4);
        }
        return list;
    }

    private static final String getValue(StringOption option) {
        return option == null ? null : option.getStringValue();
    }

    private static final Integer getValue(IntegerOption option) {
        return option == null ? null : Integer.valueOf(option.getIntegerValue());
    }

    private static final void addOrdered(List<Option> list, Option option) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        if (option == null) {
            throw new NullPointerException("Option must not be null!");
        }
        int pos = list.size();
        while (pos > 0) {
            int cmp;
            if ((cmp = list.get(--pos).compareTo(option)) > 0) continue;
            if (cmp == 0 && option.isSingleValue()) {
                list.remove(pos);
                break;
            }
            ++pos;
            break;
        }
        list.add(pos, option);
    }

    private static final int indexOfFirst(List<Option> list, OptionNumber option) {
        if (list == null) {
            throw new NullPointerException("List must not be null!");
        }
        if (option == null) {
            throw new NullPointerException("Option must not be null!");
        }
        for (int index = 0; index < list.size(); ++index) {
            int cmp = list.get(index).compareTo(option);
            if (cmp == 0) {
                return index;
            }
            if (cmp > 0) break;
        }
        return -1;
    }

    private static final void assertOrder(List<Option> list) {
        Option last = null;
        for (Option option : list) {
            if (last != null && last.compareTo(option) > 0) {
                throw new IllegalArgumentException("List not sorted! " + last + " > " + option);
            }
            last = option;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpaqueOption> getIfMatch() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.if_match_list = OptionSet.ensureList(this.if_match_list);
        }
        return this.if_match_list;
    }

    public int getIfMatchCount() {
        return OptionSet.count(this.if_match_list);
    }

    public boolean isIfMatch(byte[] check) {
        List<OpaqueOption> list = this.if_match_list;
        if (list == null) {
            return true;
        }
        if (this.isIfMatchAll()) {
            return true;
        }
        return OptionSet.contains(list, check);
    }

    public boolean isIfMatchAll() {
        List<OpaqueOption> list = this.if_match_list;
        return list != null && list.size() == 1 && list.get(0).getLength() == 0;
    }

    public OptionSet addIfMatch(byte[] etag) {
        List<OpaqueOption> list;
        if (!this.isIfMatchAll() && !OptionSet.contains(list = this.getIfMatch(), etag)) {
            if (etag.length == 0) {
                list.clear();
                list.add(StandardOptionRegistry.IF_MATCH.create(etag));
            } else if (!this.isIfMatchAll()) {
                list.add(StandardOptionRegistry.IF_MATCH.create((byte[])etag.clone()));
            }
        }
        return this;
    }

    public OptionSet removeIfMatch(byte[] etag) {
        OptionSet.remove(this.if_match_list, etag);
        return this;
    }

    public OptionSet clearIfMatchs() {
        OptionSet.clear(this.if_match_list);
        return this;
    }

    public String getUriHost() {
        return OptionSet.getValue(this.uri_host);
    }

    public boolean hasUriHost() {
        return this.uri_host != null;
    }

    public OptionSet setUriHost(String host) {
        StringOption option;
        this.uri_host = option = StandardOptionRegistry.URI_HOST.create(host);
        return this;
    }

    public OptionSet removeUriHost() {
        this.uri_host = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OpaqueOption> getETags() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.etag_list = OptionSet.ensureList(this.etag_list);
        }
        return this.etag_list;
    }

    public int getETagCount() {
        return OptionSet.count(this.etag_list);
    }

    public boolean containsETag(byte[] check) {
        return OptionSet.contains(this.etag_list, check);
    }

    public OptionSet addETag(byte[] etag) {
        if (!this.containsETag(etag)) {
            OpaqueOption option = StandardOptionRegistry.ETAG.create((byte[])etag.clone());
            this.getETags().add(option);
        }
        return this;
    }

    public OptionSet removeETag(byte[] etag) {
        OptionSet.remove(this.etag_list, etag);
        return this;
    }

    public OptionSet clearETags() {
        OptionSet.clear(this.etag_list);
        return this;
    }

    public byte[] getResponseEtag() {
        List<OpaqueOption> list = this.etag_list;
        if (list != null) {
            int size = list.size();
            if (size == 1) {
                return list.get(0).getValue();
            }
            if (size > 1) {
                throw new IllegalStateException(size + " etags, only 1 etag supported in responses!");
            }
        }
        return null;
    }

    public boolean hasIfNoneMatch() {
        return this.if_none_match != null;
    }

    public OptionSet setIfNoneMatch(boolean present) {
        this.if_none_match = present ? StandardOptionRegistry.IF_NONE_MATCH.create() : null;
        return this;
    }

    public Integer getUriPort() {
        return OptionSet.getValue(this.uri_port);
    }

    public boolean hasUriPort() {
        return this.uri_port != null;
    }

    public OptionSet setUriPort(int port) {
        this.uri_port = StandardOptionRegistry.URI_PORT.create(port);
        return this;
    }

    public OptionSet removeUriPort() {
        this.uri_port = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StringOption> getLocationPath() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.location_path_list = OptionSet.ensureList(this.location_path_list);
        }
        return this.location_path_list;
    }

    public String getLocationString() {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        OptionSet.appendMultiOption(builder, this.getLocationPath(), '/');
        if (this.getLocationQueryCount() > 0) {
            builder.append('?');
            OptionSet.appendMultiOption(builder, this.getLocationQuery(), '&');
        }
        return builder.toString();
    }

    public String getLocationPathString() {
        return OptionSet.getMultiOptionString(this.getLocationPath(), '/');
    }

    public int getLocationPathCount() {
        return OptionSet.count(this.location_path_list);
    }

    public OptionSet addLocationPath(String segment) {
        this.getLocationPath().add(StandardOptionRegistry.LOCATION_PATH.create(segment));
        return this;
    }

    public OptionSet clearLocationPath() {
        OptionSet.clear(this.location_path_list);
        return this;
    }

    public OptionSet setLocationPath(String path) {
        String slash = "/";
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        this.clearLocationPath();
        for (String segment : path.split("/")) {
            this.addLocationPath(segment);
        }
        return this;
    }

    public String getUriString() {
        StringBuilder builder = new StringBuilder();
        builder.append('/');
        OptionSet.appendMultiOption(builder, this.getUriPath(), '/');
        if (this.getURIQueryCount() > 0) {
            builder.append('?');
            OptionSet.appendMultiOption(builder, this.getUriQuery(), '&');
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StringOption> getUriPath() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.uri_path_list = OptionSet.ensureList(this.uri_path_list);
        }
        return this.uri_path_list;
    }

    public String getUriPathString() {
        return OptionSet.getMultiOptionString(this.getUriPath(), '/');
    }

    public int getURIPathCount() {
        return OptionSet.count(this.uri_path_list);
    }

    public OptionSet setUriPath(String path) {
        String slash = "/";
        if (path.startsWith("/")) {
            path = path.substring("/".length());
        }
        this.clearUriPath();
        for (String segment : path.split("/")) {
            this.addUriPath(segment);
        }
        return this;
    }

    public OptionSet addUriPath(String segment) {
        this.getUriPath().add(StandardOptionRegistry.URI_PATH.create(segment));
        return this;
    }

    public OptionSet clearUriPath() {
        OptionSet.clear(this.uri_path_list);
        return this;
    }

    public int getContentFormat() {
        IntegerOption option = this.content_format;
        return option == null ? -1 : option.getIntegerValue();
    }

    public boolean hasContentFormat() {
        return this.content_format != null;
    }

    public boolean isContentFormat(int format) {
        IntegerOption option = this.content_format;
        return option != null && option.getIntegerValue() == format;
    }

    public OptionSet setContentFormat(int format) {
        this.content_format = -1 == format ? null : StandardOptionRegistry.CONTENT_FORMAT.create(format);
        return this;
    }

    public OptionSet removeContentFormat() {
        this.content_format = null;
        return this;
    }

    public Long getMaxAge() {
        IntegerOption m = this.max_age;
        return m != null ? m.getLongValue() : 60L;
    }

    public boolean hasMaxAge() {
        return this.max_age != null;
    }

    public OptionSet setMaxAge(long age) {
        this.max_age = StandardOptionRegistry.MAX_AGE.create(age);
        return this;
    }

    public OptionSet removeMaxAge() {
        this.max_age = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StringOption> getUriQuery() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.uri_query_list = OptionSet.ensureList(this.uri_query_list);
        }
        return this.uri_query_list;
    }

    public List<String> getUriQueryStrings() {
        return OptionSet.getValues(this.getUriQuery());
    }

    public int getURIQueryCount() {
        return OptionSet.count(this.uri_query_list);
    }

    public String getUriQueryString() {
        return OptionSet.getMultiOptionString(this.getUriQuery(), '&');
    }

    public OptionSet setUriQuery(String query) {
        while (query.startsWith("?")) {
            query = query.substring(1);
        }
        this.clearUriQuery();
        for (String segment : query.split("&")) {
            if (segment.isEmpty()) continue;
            this.addUriQuery(segment);
        }
        return this;
    }

    public OptionSet addUriQuery(String argument) {
        this.getUriQuery().add(StandardOptionRegistry.URI_QUERY.create(argument));
        this.uri_query_parameter = null;
        return this;
    }

    public OptionSet removeUriQuery(String argument) {
        if (OptionSet.removeStringOption(this.getUriQuery(), argument)) {
            this.uri_query_parameter = null;
        }
        return this;
    }

    public OptionSet clearUriQuery() {
        OptionSet.clear(this.uri_query_list);
        this.uri_query_parameter = null;
        return this;
    }

    public UriQueryParameter getUriQueryParameter() {
        if (this.uri_query_parameter == null) {
            return this.getUriQueryParameter(null, null);
        }
        return this.uri_query_parameter;
    }

    public UriQueryParameter getUriQueryParameter(List<String> supportedParameterNames) {
        return this.getUriQueryParameter(supportedParameterNames, null);
    }

    public UriQueryParameter getUriQueryParameter(List<String> supportedParameterNames, List<String> unsupportedParameter) {
        this.uri_query_parameter = this.uri_query_list != null && !this.uri_query_list.isEmpty() ? new UriQueryParameter(OptionSet.getValues(this.uri_query_list), supportedParameterNames, unsupportedParameter) : UriQueryParameter.EMPTY;
        return this.uri_query_parameter;
    }

    public int getAccept() {
        IntegerOption option = this.accept;
        return option == null ? -1 : option.getIntegerValue();
    }

    public boolean hasAccept() {
        return this.accept != null;
    }

    public boolean isAccept(int format) {
        IntegerOption option = this.accept;
        return option != null && option.getIntegerValue() == format;
    }

    public OptionSet setAccept(int format) {
        this.accept = StandardOptionRegistry.ACCEPT.create(format);
        return this;
    }

    public OptionSet removeAccept() {
        this.accept = null;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StringOption> getLocationQuery() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.location_query_list = OptionSet.ensureList(this.location_query_list);
        }
        return this.location_query_list;
    }

    public int getLocationQueryCount() {
        return this.getLocationQuery().size();
    }

    public String getLocationQueryString() {
        return OptionSet.getMultiOptionString(this.getLocationQuery(), '&');
    }

    public OptionSet setLocationQuery(String query) {
        while (query.startsWith("?")) {
            query = query.substring(1);
        }
        this.clearLocationQuery();
        for (String segment : query.split("&")) {
            if (segment.isEmpty()) continue;
            this.addLocationQuery(segment);
        }
        return this;
    }

    public OptionSet addLocationQuery(String argument) {
        this.getLocationQuery().add(StandardOptionRegistry.LOCATION_QUERY.create(argument));
        return this;
    }

    public OptionSet removeLocationQuery(String argument) {
        OptionSet.removeStringOption(this.getLocationQuery(), argument);
        return this;
    }

    public OptionSet clearLocationQuery() {
        OptionSet.clear(this.location_query_list);
        return this;
    }

    public String getProxyUri() {
        return OptionSet.getValue(this.proxy_uri);
    }

    public boolean hasProxyUri() {
        return this.proxy_uri != null;
    }

    public OptionSet setProxyUri(String uri) {
        this.proxy_uri = StandardOptionRegistry.PROXY_URI.create(uri);
        return this;
    }

    public OptionSet removeProxyUri() {
        this.proxy_uri = null;
        return this;
    }

    public String getProxyScheme() {
        return OptionSet.getValue(this.proxy_scheme);
    }

    public boolean hasProxyScheme() {
        return this.proxy_scheme != null;
    }

    public OptionSet setProxyScheme(String scheme) {
        this.proxy_scheme = StandardOptionRegistry.PROXY_SCHEME.create(scheme);
        return this;
    }

    public OptionSet removeProxyScheme() {
        this.proxy_scheme = null;
        return this;
    }

    public BlockOption getBlock1() {
        return this.block1;
    }

    public boolean hasBlock1() {
        return this.block1 != null;
    }

    public OptionSet setBlock1(int szx, boolean m, int num) {
        this.block1 = StandardOptionRegistry.BLOCK1.create(szx, m, num);
        return this;
    }

    public OptionSet setBlock1(BlockOption block) {
        if (block != null && StandardOptionRegistry.BLOCK1 != block.getDefinition()) {
            throw new IllegalArgumentException("Block option is not BLOCK1!");
        }
        this.block1 = block;
        return this;
    }

    public OptionSet removeBlock1() {
        this.block1 = null;
        return this;
    }

    public BlockOption getBlock2() {
        return this.block2;
    }

    public boolean hasBlock2() {
        return this.block2 != null;
    }

    public OptionSet setBlock2(int szx, boolean m, int num) {
        this.block2 = StandardOptionRegistry.BLOCK2.create(szx, m, num);
        return this;
    }

    public OptionSet setBlock2(BlockOption block) {
        if (block != null && StandardOptionRegistry.BLOCK2 != block.getDefinition()) {
            throw new IllegalArgumentException("Block option is not BLOCK2!");
        }
        this.block2 = block;
        return this;
    }

    public OptionSet removeBlock2() {
        this.block2 = null;
        return this;
    }

    public Integer getSize1() {
        return OptionSet.getValue(this.size1);
    }

    public boolean hasSize1() {
        return this.size1 != null;
    }

    public OptionSet setSize1(int size) {
        this.size1 = StandardOptionRegistry.SIZE1.create(size);
        return this;
    }

    public OptionSet removeSize1() {
        this.size1 = null;
        return this;
    }

    public Integer getSize2() {
        return OptionSet.getValue(this.size2);
    }

    public boolean hasSize2() {
        return this.size2 != null;
    }

    public OptionSet setSize2(int size) {
        this.size2 = StandardOptionRegistry.SIZE2.create(size);
        return this;
    }

    public OptionSet removeSize2() {
        this.size2 = null;
        return this;
    }

    public Integer getObserve() {
        return OptionSet.getValue(this.observe);
    }

    public boolean hasObserve() {
        return this.observe != null;
    }

    public OptionSet setObserve(int seqnum) {
        this.observe = StandardOptionRegistry.OBSERVE.create(seqnum);
        return this;
    }

    public OptionSet removeObserve() {
        this.observe = null;
        return this;
    }

    public byte[] getOscore() {
        OpaqueOption option = this.oscore;
        return option == null ? null : option.getValue();
    }

    public boolean hasOscore() {
        return this.oscore != null;
    }

    public OptionSet setOscore(byte[] oscore) {
        this.oscore = StandardOptionRegistry.OSCORE.create((byte[])oscore.clone());
        return this;
    }

    public OptionSet removeOscore() {
        this.oscore = null;
        return this;
    }

    public NoResponseOption getNoResponse() {
        return this.no_response;
    }

    public boolean hasNoResponse() {
        return this.no_response != null;
    }

    public OptionSet setNoResponse(int noResponse) {
        this.no_response = new NoResponseOption(noResponse);
        return this;
    }

    public OptionSet setNoResponse(NoResponseOption noResponse) {
        this.no_response = noResponse;
        return this;
    }

    public OptionSet removeNoResponse() {
        this.no_response = null;
        return this;
    }

    public boolean hasOption(OptionDefinition definition) {
        return Collections.binarySearch(this.asSortedList(), definition) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Option> getOthersInternal() {
        OptionSet optionSet = this;
        synchronized (optionSet) {
            this.others = OptionSet.ensureList(this.others);
        }
        return this.others;
    }

    public List<Option> getOthers() {
        List<Option> others = this.others;
        if (others == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(others);
    }

    public List<Option> getOthers(OptionDefinition definition) {
        int pos;
        ArrayList<Option> options = null;
        List<Option> others = this.others;
        if (others != null && (pos = OptionSet.indexOfFirst(others, definition)) >= 0) {
            Option option;
            while (pos < others.size() && definition.equals((option = others.get(pos)).getDefinition())) {
                if (options == null) {
                    options = new ArrayList<Option>();
                }
                options.add(option);
                if (option.isSingleValue()) break;
                ++pos;
            }
        }
        if (options == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(options);
    }

    public <T extends Option> T getOtherOption(OptionDefinition definition) {
        int pos;
        List<Option> others = this.others;
        if (others != null && (pos = OptionSet.indexOfFirst(others, definition)) >= 0) {
            return (T)others.get(pos);
        }
        return null;
    }

    public List<Option> asSortedList() {
        List<Option> others;
        ArrayList<Option> options = new ArrayList<Option>();
        if (this.if_match_list != null) {
            options.addAll(this.if_match_list);
        }
        if (this.hasUriHost()) {
            options.add(this.uri_host);
        }
        if (this.etag_list != null) {
            options.addAll(this.etag_list);
        }
        if (this.hasIfNoneMatch()) {
            options.add(this.if_none_match);
        }
        if (this.hasObserve()) {
            options.add(this.observe);
        }
        if (this.hasUriPort()) {
            options.add(this.uri_port);
        }
        if (this.location_path_list != null) {
            options.addAll(this.location_path_list);
        }
        if (this.hasOscore()) {
            options.add(this.oscore);
        }
        if (this.uri_path_list != null) {
            options.addAll(this.uri_path_list);
        }
        if (this.hasContentFormat()) {
            options.add(this.content_format);
        }
        if (this.hasMaxAge()) {
            options.add(this.max_age);
        }
        if (this.uri_query_list != null) {
            options.addAll(this.uri_query_list);
        }
        if (this.hasAccept()) {
            options.add(this.accept);
        }
        if (this.location_query_list != null) {
            options.addAll(this.location_query_list);
        }
        if (this.hasBlock2()) {
            options.add(this.block2);
        }
        if (this.hasBlock1()) {
            options.add(this.block1);
        }
        if (this.hasSize2()) {
            options.add(this.size2);
        }
        if (this.hasProxyUri()) {
            options.add(this.proxy_uri);
        }
        if (this.hasProxyScheme()) {
            options.add(this.proxy_scheme);
        }
        if (this.hasSize1()) {
            options.add(this.size1);
        }
        if (this.hasNoResponse()) {
            options.add(this.no_response);
        }
        if ((others = this.others) != null) {
            Option last = options.isEmpty() ? null : options.get(options.size() - 1);
            for (Option other : others) {
                if (last == null || last.compareTo(other) <= 0) {
                    options.add(other);
                    last = other;
                    continue;
                }
                OptionSet.addOrdered(options, other);
            }
        }
        OptionSet.assertOrder(options);
        return options;
    }

    public OptionSet addOptions(Option ... options) {
        if (options != null) {
            for (Option option : options) {
                this.addOption(option);
            }
        }
        return this;
    }

    public OptionSet addOptions(List<Option> options) {
        if (options != null) {
            for (Option option : options) {
                this.addOption(option);
            }
        }
        return this;
    }

    public OptionSet addOption(Option option) {
        if (option == null) {
            throw new NullPointerException("Option must not be null!");
        }
        switch (option.getNumber()) {
            case 1: {
                this.getIfMatch().add((OpaqueOption)option);
                break;
            }
            case 3: {
                this.uri_host = (StringOption)option;
                break;
            }
            case 4: {
                this.getETags().add((OpaqueOption)option);
                break;
            }
            case 5: {
                this.if_none_match = (EmptyOption)option;
                break;
            }
            case 7: {
                this.uri_port = (IntegerOption)option;
                break;
            }
            case 8: {
                this.getLocationPath().add((StringOption)option);
                break;
            }
            case 11: {
                this.getUriPath().add((StringOption)option);
                break;
            }
            case 12: {
                this.content_format = (IntegerOption)option;
                break;
            }
            case 14: {
                this.max_age = (IntegerOption)option;
                break;
            }
            case 15: {
                this.getUriQuery().add((StringOption)option);
                break;
            }
            case 17: {
                this.accept = (IntegerOption)option;
                break;
            }
            case 20: {
                this.getLocationQuery().add((StringOption)option);
                break;
            }
            case 35: {
                this.proxy_uri = (StringOption)option;
                break;
            }
            case 39: {
                this.proxy_scheme = (StringOption)option;
                break;
            }
            case 27: {
                this.block1 = (BlockOption)option;
                break;
            }
            case 23: {
                this.block2 = (BlockOption)option;
                break;
            }
            case 60: {
                this.size1 = (IntegerOption)option;
                break;
            }
            case 28: {
                this.size2 = (IntegerOption)option;
                break;
            }
            case 6: {
                this.observe = (IntegerOption)option;
                break;
            }
            case 9: {
                this.oscore = (OpaqueOption)option;
                break;
            }
            case 258: {
                this.no_response = (NoResponseOption)option;
                break;
            }
            default: {
                OptionSet.addOrdered(this.getOthersInternal(), option);
            }
        }
        return this;
    }

    public OptionSet addOtherOption(Option option) {
        if (option == null) {
            throw new NullPointerException("Option must not be null!");
        }
        OptionSet.addOrdered(this.getOthersInternal(), option);
        return this;
    }

    public OptionSet clearOtherOption(Option option) {
        OptionDefinition definition;
        int pos;
        if (option == null) {
            throw new NullPointerException("Option must not be null!");
        }
        List<Option> others = this.others;
        if (others != null && (pos = OptionSet.indexOfFirst(others, definition = option.getDefinition())) >= 0) {
            Option optionToRemove;
            while (pos < others.size() && (optionToRemove = others.get(pos)).getDefinition().equals(definition)) {
                if (optionToRemove.equals(option)) {
                    others.remove(pos);
                    continue;
                }
                ++pos;
            }
        }
        return this;
    }

    public OptionSet clearOtherOption(OptionDefinition definition) {
        int pos;
        if (definition == null) {
            throw new NullPointerException("OptionDefinition must not be null!");
        }
        List<Option> others = this.others;
        if (others != null && (pos = OptionSet.indexOfFirst(others, definition)) >= 0) {
            Option optionToRemove;
            while (pos < others.size() && (optionToRemove = others.get(pos)).getDefinition().equals(definition)) {
                others.remove(pos);
                if (!definition.isSingleValue()) continue;
                break;
            }
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StringBuilder sbv = new StringBuilder();
        int oldNr = -1;
        boolean list = false;
        sb.append('{');
        for (Option opt : this.asSortedList()) {
            if (opt.getNumber() != oldNr) {
                if (oldNr != -1) {
                    if (list) {
                        sbv.append(']');
                    }
                    sb.append((CharSequence)sbv).append(", ");
                    sbv.setLength(0);
                }
                list = false;
                sb.append('\"');
                sb.append(opt.getDefinition().getName());
                sb.append('\"');
                sb.append(':');
            } else {
                if (!list) {
                    sbv.insert(0, '[');
                }
                list = true;
                sbv.append(",");
            }
            sbv.append(opt.toValueString());
            oldNr = opt.getNumber();
        }
        if (list) {
            sbv.append(']');
        }
        sb.append((CharSequence)sbv);
        sb.append('}');
        return sb.toString();
    }

    public static List<String> getValues(final List<StringOption> options) {
        AbstractList<String> result = null;
        if (options != null) {
            result = new AbstractList<String>(){

                @Override
                public int size() {
                    return options.size();
                }

                @Override
                public String get(int index) {
                    return ((StringOption)options.get(index)).getStringValue();
                }
            };
        }
        return result;
    }

    private static String getMultiOptionString(List<StringOption> multiOption, char separator) {
        StringBuilder builder = new StringBuilder();
        OptionSet.appendMultiOption(builder, multiOption, separator);
        return builder.toString();
    }

    private static void appendMultiOption(StringBuilder builder, List<StringOption> multiOption, char separator) {
        if (!multiOption.isEmpty()) {
            for (StringOption optionText : multiOption) {
                builder.append(optionText.getStringValue()).append(separator);
            }
            builder.setLength(builder.length() - 1);
        }
    }

    private static final boolean removeStringOption(List<StringOption> options, String value) {
        for (StringOption option : options) {
            if (!option.getStringValue().equals(value)) continue;
            options.remove(option);
            return true;
        }
        return false;
    }

    private static final boolean contains(List<OpaqueOption> options, byte[] value) {
        if (options != null) {
            for (OpaqueOption option : options) {
                if (!Arrays.equals(option.getValue(), value)) continue;
                return true;
            }
        }
        return false;
    }

    private static final boolean remove(List<OpaqueOption> options, byte[] value) {
        if (options != null) {
            int max = options.size();
            for (int index = 0; index < max; ++index) {
                if (!Arrays.equals(options.get(index).getValue(), value)) continue;
                options.remove(index);
                return true;
            }
        }
        return false;
    }
}

