/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.serialization;

import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.CoAPMessageFormatException;
import org.eclipse.californium.core.coap.MessageFormatException;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.core.network.serialization.DataParser;
import org.eclipse.californium.core.network.serialization.MessageHeader;
import org.eclipse.californium.elements.util.DatagramReader;

public class UdpDataParser
extends DataParser {
    private final boolean strictEmptyMessageFormat;

    public UdpDataParser() {
        this(false, null);
    }

    public UdpDataParser(int[] criticalCustomOptions) {
        this(false, criticalCustomOptions);
    }

    public UdpDataParser(boolean strictEmptyMessageFormat, int[] criticalCustomOptions) {
        super(criticalCustomOptions);
        this.strictEmptyMessageFormat = strictEmptyMessageFormat;
    }

    @Override
    protected MessageHeader parseHeader(DatagramReader reader) {
        if (!reader.bytesAvailable(4)) {
            throw new MessageFormatException("UDP Message too short! " + reader.bitsLeft() / 8 + " must be at least 4 bytes!");
        }
        int version = reader.read(2);
        this.assertCorrectVersion(version);
        int typeValue = reader.read(2);
        CoAP.Type type = CoAP.Type.valueOf(typeValue);
        boolean confirmable = type == CoAP.Type.CON;
        int tokenLength = reader.read(4);
        if (tokenLength > 8) {
            throw new MessageFormatException("UDP Message has invalid token length (> 8) " + tokenLength);
        }
        int code = reader.read(8);
        int mid = reader.read(16);
        if (this.strictEmptyMessageFormat && code == 0 && reader.bytesAvailable()) {
            throw new CoAPMessageFormatException("UDP malformed Empty Message!", null, mid, code, confirmable);
        }
        if (!reader.bytesAvailable(tokenLength)) {
            throw new CoAPMessageFormatException("UDP Message too short for token! " + reader.bitsLeft() / 8 + " must be at least " + tokenLength + " bytes!", null, mid, code, confirmable);
        }
        Token token = Token.fromProvider(reader.readBytes(tokenLength));
        return new MessageHeader(version, type, token, code, mid, 0);
    }

    @Override
    protected void assertValidOptions(OptionSet options) {
        UdpDataParser.assertValidUdpOptions(options);
    }

    private void assertCorrectVersion(int version) {
        if (version != 1) {
            throw new MessageFormatException("UDP Message has invalid version: " + version);
        }
    }

    public static void assertValidUdpOptions(OptionSet options) {
        BlockOption block = options.getBlock1();
        if (block != null && block.isBERT()) {
            throw new IllegalArgumentException("Block1 BERT used for UDP!");
        }
        block = options.getBlock2();
        if (block != null && block.isBERT()) {
            throw new IllegalArgumentException("Block2 BERT used for UDP!");
        }
    }
}

