/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class MediaTypeRegistry {
    public static final int TEXT_PLAIN = 0;
    public static final int APPLICATION_COSE_ENCRYPT0 = 16;
    public static final int APPLICATION_COSE_MAC0 = 17;
    public static final int APPLICATION_COSE_SIGN1 = 18;
    public static final int APPLICATION_ACE_CBOR = 19;
    public static final int IMAGE_GIF = 21;
    public static final int IMAGE_JPEG = 22;
    public static final int IMAGE_PNG = 23;
    public static final int APPLICATION_LINK_FORMAT = 40;
    public static final int APPLICATION_XML = 41;
    public static final int APPLICATION_OCTET_STREAM = 42;
    public static final int APPLICATION_XMPP_XML = 46;
    public static final int APPLICATION_EXI = 47;
    public static final int APPLICATION_JSON = 50;
    public static final int APPLICATION_JSON_PATCH = 51;
    public static final int APPLICATION_MERGE_PATCH = 52;
    public static final int APPLICATION_CBOR = 60;
    public static final int APPLICATION_CWT = 61;
    public static final int APPLICATION_MULTIPART_CORE = 62;
    public static final int APPLICATION_CBOR_SEQ = 63;
    public static final int APPLICATION_COSE_ENCRYPT = 96;
    public static final int APPLICATION_COSE_MAC = 97;
    public static final int APPLICATION_COSE_SIGN = 98;
    public static final int APPLICATION_COSE_KEY = 101;
    public static final int APPLICATION_COSE_KEY_SET = 102;
    public static final int APPLICATION_SENML_JSON = 110;
    public static final int APPLICATION_SENSML_JSON = 111;
    public static final int APPLICATION_SENML_CBOR = 112;
    public static final int APPLICATION_SENSML_CBOR = 113;
    public static final int APPLICATION_SENML_EXI = 114;
    public static final int APPLICATION_SENSML_EXI = 115;
    public static final int APPLICATION_COAP_GROUP = 256;
    public static final int APPLICATION_DOTS_CBOR = 271;
    public static final int APPLICATION_MISSING_BLOCKS_CBOR_SEQ = 272;
    public static final int APPLICATION_PKCS7_SERVER_GENERATED_KEY = 280;
    public static final int APPLICATION_PKCS7_CERTS_ONLY = 281;
    public static final int APPLICATION_PKCS8 = 284;
    public static final int APPLICATION_CSATTRS = 285;
    public static final int APPLICATION_PKCS10 = 286;
    public static final int APPLICATION_PKIX_CERT = 287;
    public static final int APPLICATION_SENML_XML = 310;
    public static final int APPLICATION_SENSML_XML = 311;
    public static final int APPLICATION_SENML_ETCH_JSON = 320;
    public static final int APPLICATION_SENML_ETCH_CBOR = 322;
    public static final int APPLICATION_TD_JSON = 432;
    public static final int APPLICATION_VND_OCF_CBOR = 10000;
    public static final int APPLICATION_OSCORE = 10001;
    public static final int APPLICATION_JAVASCRIPT = 10002;
    public static final int APPLICATION_VND_OMA_LWM2M_TLV = 11542;
    public static final int APPLICATION_VND_OMA_LWM2M_JSON = 11543;
    public static final int APPLICATION_VND_OMA_LWM2M_CBOR = 11544;
    public static final int TEXT_CSS = 20000;
    public static final int IMAGE_SVG_XML = 30000;
    public static final int MAX_TYPE = 65535;
    public static final int UNDEFINED = -1;
    private static final Map<Integer, MediaTypeDefintion> registry = new ConcurrentHashMap<Integer, MediaTypeDefintion>();

    public static Set<Integer> getAllMediaTypes() {
        return registry.keySet();
    }

    public static MediaTypeDefintion getDefinition(int mediaType) {
        return registry.get(mediaType);
    }

    public static boolean isKnown(int mediaType) {
        return registry.containsKey(mediaType);
    }

    public static boolean isPrintable(int mediaType) {
        MediaTypeDefintion definition = registry.get(mediaType);
        if (definition != null) {
            return definition.isPrintable();
        }
        return false;
    }

    public static boolean isCharsetConvertible(int mediaType) {
        MediaTypeDefintion definition = registry.get(mediaType);
        if (definition != null) {
            return definition.isCharsetConvertible();
        }
        return false;
    }

    public static int parse(String type) {
        if (type == null) {
            return -1;
        }
        for (MediaTypeDefintion defintion : registry.values()) {
            if (!defintion.match(type)) continue;
            return defintion.getType();
        }
        return -1;
    }

    public static int[] parseWildcard(String wildcard) {
        LinkedList<Integer> matches = new LinkedList<Integer>();
        if (wildcard.equals("*/*")) {
            for (MediaTypeDefintion defintion : registry.values()) {
                matches.add(defintion.getType());
            }
        } else if (wildcard.endsWith("/*")) {
            Pattern pattern = Pattern.compile(wildcard.replace("*", ".*"));
            for (MediaTypeDefintion defintion : registry.values()) {
                if (!defintion.match(pattern)) continue;
                matches.add(defintion.getType());
            }
        } else {
            for (MediaTypeDefintion defintion : registry.values()) {
                if (!defintion.match(wildcard)) continue;
                matches.add(defintion.getType());
            }
        }
        int[] result = new int[matches.size()];
        for (int index = 0; index < result.length; ++index) {
            result[index] = (Integer)matches.get(index);
        }
        return result;
    }

    public static String toFileExtension(int mediaType) {
        MediaTypeDefintion definition = registry.get(mediaType);
        if (definition != null) {
            return definition.getFileExtension();
        }
        return "unknown_" + mediaType;
    }

    public static String toString(int mediaType) {
        if (mediaType == -1) {
            return "undefined";
        }
        MediaTypeDefintion definition = registry.get(mediaType);
        if (definition != null) {
            return definition.getMime();
        }
        return "unknown/" + mediaType;
    }

    private static void addNonPrintable(int mediaType, String mime, String extension) {
        MediaTypeRegistry.add(new MediaTypeDefintion(mediaType, mime, extension));
    }

    private static void addPrintable(int mediaType, String mime, String extension, boolean isCharsetConvertible) {
        MediaTypeRegistry.add(new MediaTypeDefintion(mediaType, mime, extension, isCharsetConvertible));
    }

    public static void add(MediaTypeDefintion definition) {
        registry.put(definition.getType(), definition);
    }

    static {
        MediaTypeRegistry.addPrintable(0, "text/plain", "txt", true);
        MediaTypeRegistry.addNonPrintable(16, "application/cose; cose-type=\"cose-encrypt0\"", "cbor");
        MediaTypeRegistry.addNonPrintable(17, "application/cose; cose-type=\"cose-mac0\"", "cbor");
        MediaTypeRegistry.addNonPrintable(18, "application/cose; cose-type=\"cose-sign1\"", "cbor");
        MediaTypeRegistry.addNonPrintable(19, "application/ace+cbor", "cbor");
        MediaTypeRegistry.addNonPrintable(21, "image/gif", "gif");
        MediaTypeRegistry.addNonPrintable(22, "image/jpeg", "jpeg");
        MediaTypeRegistry.addNonPrintable(23, "image/png", "png");
        MediaTypeRegistry.addPrintable(40, "application/link-format", "wlnk", false);
        MediaTypeRegistry.addPrintable(41, "application/xml", "xml", false);
        MediaTypeRegistry.addNonPrintable(42, "application/octet-stream", "bin");
        MediaTypeRegistry.addPrintable(46, "application/xmpp+xml", "xmpp", false);
        MediaTypeRegistry.addNonPrintable(47, "application/exi", "exi");
        MediaTypeRegistry.addPrintable(50, "application/json", "json", false);
        MediaTypeRegistry.addPrintable(51, "application/json-patch+json", "json", false);
        MediaTypeRegistry.addPrintable(52, "application/merge-patch+json", "json", false);
        MediaTypeRegistry.addNonPrintable(60, "application/cbor", "cbor");
        MediaTypeRegistry.addNonPrintable(61, "application/cwt", "cwt");
        MediaTypeRegistry.addNonPrintable(62, "application/multipart-core", "part");
        MediaTypeRegistry.addNonPrintable(63, "application/cbor-seq", "cbor");
        MediaTypeRegistry.addNonPrintable(96, "application/cose; cose-type=\"cose-encrypt\"", "cbor");
        MediaTypeRegistry.addNonPrintable(97, "application/cose; cose-type=\"cose-mac\"", "cbor");
        MediaTypeRegistry.addNonPrintable(98, "application/cose; cose-type=\"cose-sign\"", "cbor");
        MediaTypeRegistry.addNonPrintable(101, "application/cose-key", "cbor");
        MediaTypeRegistry.addNonPrintable(102, "application/cose-key-set", "cbor");
        MediaTypeRegistry.addPrintable(110, "application/senml+json", "json", false);
        MediaTypeRegistry.addPrintable(111, "application/sensml+json", "json", false);
        MediaTypeRegistry.addNonPrintable(112, "application/senml+cbor", "cbor");
        MediaTypeRegistry.addNonPrintable(113, "application/sensml+cbor", "cbor");
        MediaTypeRegistry.addNonPrintable(114, "application/senml+exi", "exi");
        MediaTypeRegistry.addNonPrintable(115, "application/sensml+exi", "exi");
        MediaTypeRegistry.addPrintable(256, "application/coap-group+json", "json", false);
        MediaTypeRegistry.addNonPrintable(271, "application/dots+cbor", "cbor");
        MediaTypeRegistry.addNonPrintable(272, "application/missing-blocks+cbor-seq", "cbor");
        MediaTypeRegistry.addNonPrintable(280, "application/pkcs7-mime; smime-type=\"server-generated-key\"", "pkcs");
        MediaTypeRegistry.addNonPrintable(281, "application/pkcs7-mime; smime-type=\"certs-only\"", "pkcs");
        MediaTypeRegistry.addNonPrintable(284, "application/pkcs8", "pkcs");
        MediaTypeRegistry.addNonPrintable(285, "application/csattrs", "csattrs");
        MediaTypeRegistry.addNonPrintable(286, "application/pkcs10", "pkcs");
        MediaTypeRegistry.addNonPrintable(287, "application/pkix-cert", "pkix");
        MediaTypeRegistry.addPrintable(310, "application/senml+xml", "xml", false);
        MediaTypeRegistry.addPrintable(311, "application/sensml+xml", "xml", false);
        MediaTypeRegistry.addPrintable(320, "application/senml-etch+json", "json", false);
        MediaTypeRegistry.addNonPrintable(322, "application/senml-etch+cbor", "cbor");
        MediaTypeRegistry.addPrintable(432, "application/td+json", "json", false);
        MediaTypeRegistry.addNonPrintable(10000, "application/vnd.ocf+cbor", "cbor");
        MediaTypeRegistry.addNonPrintable(10001, "application/oscore", "oscore");
        MediaTypeRegistry.addPrintable(10002, "application/javascript", "js", false);
        MediaTypeRegistry.addNonPrintable(11542, "application/vnd.oma.lwm2m+tlv", "tlv");
        MediaTypeRegistry.addPrintable(11543, "application/vnd.oma.lwm2m+json", "json", false);
        MediaTypeRegistry.addNonPrintable(11544, "application/vnd.oma.lwm2m+cbor", "cbor");
        MediaTypeRegistry.addPrintable(20000, "text/css", "css", false);
        MediaTypeRegistry.addPrintable(30000, "image/svg+xml", "xml", false);
    }

    public static class MediaTypeDefintion {
        private final Integer type;
        private final String mime;
        private final String fileExtension;
        private final boolean isPrintable;
        private final boolean isCharsetConvertible;

        public MediaTypeDefintion(Integer type, String mime, String fileExtension) {
            if (type == null) {
                throw new NullPointerException("type must not be null!");
            }
            if (mime == null) {
                throw new NullPointerException("mime must not be null!");
            }
            if (fileExtension == null) {
                throw new NullPointerException("file extension must not be null!");
            }
            this.type = type;
            this.mime = mime;
            this.fileExtension = fileExtension;
            this.isPrintable = false;
            this.isCharsetConvertible = false;
        }

        public MediaTypeDefintion(Integer type, String mime, String fileExtension, boolean isCharsetConvertible) {
            if (type == null) {
                throw new NullPointerException("type must not be null!");
            }
            if (mime == null) {
                throw new NullPointerException("mime must not be null!");
            }
            if (fileExtension == null) {
                throw new NullPointerException("file extension must not be null!");
            }
            this.type = type;
            this.mime = mime;
            this.fileExtension = fileExtension;
            this.isPrintable = true;
            this.isCharsetConvertible = isCharsetConvertible;
        }

        public boolean match(String mime) {
            return this.mime.equalsIgnoreCase(mime);
        }

        public boolean match(Pattern mimePattern) {
            return mimePattern.matcher(this.mime).matches();
        }

        public Integer getType() {
            return this.type;
        }

        public String getMime() {
            return this.mime;
        }

        public String getFileExtension() {
            return this.fileExtension;
        }

        public boolean isPrintable() {
            return this.isPrintable;
        }

        public boolean isCharsetConvertible() {
            return this.isCharsetConvertible;
        }
    }
}

