/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.oscore;

import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.oscore.OSCoreCtx;

public class OSCoreEndpointContextInfo {
    private static final String PREFIX = "*";
    public static final Definition<String> OSCORE_SENDER_ID = new Definition<String>("*OSCORE_SENDER_ID", String.class, MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> OSCORE_RECIPIENT_ID = new Definition<String>("*OSCORE_RECIPIENT_ID", String.class, MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> OSCORE_CONTEXT_ID = new Definition<String>("*OSCORE_CONTEXT_ID", String.class, MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS);
    public static final Definition<String> OSCORE_URI = new Definition<String>("*OSCORE_URI", String.class, MapBasedEndpointContext.ATTRIBUTE_DEFINITIONS);

    public static void sendingRequest(OSCoreCtx oscoreCtx, Exchange exchange) {
        exchange.setEndpointContextPreOperator(new OSCoreEndpointContextOperator(oscoreCtx));
    }

    public static void receivingRequest(OSCoreCtx oscoreCtx, Request request) {
        OSCoreEndpointContextInfo.setInfoIncoming(oscoreCtx, request);
    }

    public static void receivingResponse(OSCoreCtx oscoreCtx, Response response) {
        OSCoreEndpointContextInfo.setInfoIncoming(oscoreCtx, response);
    }

    private static void setInfoIncoming(OSCoreCtx oscoreCtx, Message message) {
        MapBasedEndpointContext newEndpointContext = OSCoreEndpointContextInfo.setInfo(oscoreCtx, message.getSourceContext());
        message.setSourceContext(newEndpointContext);
    }

    private static MapBasedEndpointContext setInfo(OSCoreCtx oscoreCtx, EndpointContext endpointContext) {
        if (endpointContext == null) {
            return null;
        }
        MapBasedEndpointContext.Attributes attributes = new MapBasedEndpointContext.Attributes();
        attributes.add(OSCORE_SENDER_ID, oscoreCtx.getSenderIdString());
        attributes.add(OSCORE_RECIPIENT_ID, oscoreCtx.getRecipientIdString());
        attributes.add(OSCORE_CONTEXT_ID, oscoreCtx.getContextIdString());
        attributes.add(OSCORE_URI, oscoreCtx.getUri());
        MapBasedEndpointContext newEndpointContext = MapBasedEndpointContext.addEntries(endpointContext, attributes);
        return newEndpointContext;
    }

    private static class OSCoreEndpointContextOperator
    implements Exchange.EndpointContextOperator {
        private final OSCoreCtx oscoreCtx;

        public OSCoreEndpointContextOperator(OSCoreCtx oscoreCtx) {
            this.oscoreCtx = oscoreCtx;
        }

        @Override
        public EndpointContext apply(EndpointContext context) {
            return OSCoreEndpointContextInfo.setInfo(this.oscoreCtx, context);
        }
    }
}

