/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.ClientObserveRelation;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.observe.NotificationListener;

public class CoapObserveRelation
extends ClientObserveRelation {
    private volatile CoapResponse current = null;
    private volatile NotificationListener notificationListener;

    protected CoapObserveRelation(Request request, Endpoint endpoint, ScheduledThreadPoolExecutor executor) {
        super(request, endpoint, executor);
    }

    public synchronized CoapResponse waitForResponse(long timeoutMillis) {
        if (this.current == null) {
            try {
                this.wait(timeoutMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.current;
    }

    public CoapResponse getCurrent() {
        return this.current;
    }

    @Override
    protected void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        if (canceled && this.notificationListener != null) {
            this.endpoint.removeNotificationListener(this.notificationListener);
        }
    }

    public void setNotificationListener(NotificationListener listener) {
        this.notificationListener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean onResponse(CoapResponse response) {
        boolean isNew = false;
        if (null != response && (isNew = super.onResponse(response.advanced()))) {
            CoapObserveRelation coapObserveRelation = this;
            synchronized (coapObserveRelation) {
                this.current = response;
                this.notifyAll();
            }
        }
        return isNew;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean onResponse(Response response) {
        if (super.onResponse(response)) {
            CoapObserveRelation coapObserveRelation = this;
            synchronized (coapObserveRelation) {
                this.current = new CoapResponse(response);
                this.notifyAll();
            }
            return true;
        }
        return false;
    }
}

