/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.server.resources;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.eclipse.californium.core.CoapResource;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;

public class ConcurrentCoapResource
extends CoapResource {
    public static int SINGLE_THREADED = 1;
    private int threads;
    private ExecutorService executor;

    public ConcurrentCoapResource(String name) {
        this(name, ConcurrentCoapResource.getAvailableProcessors());
    }

    public ConcurrentCoapResource(String name, int threads) {
        super(name);
        this.threads = threads;
        this.setExecutor(ExecutorsUtil.newFixedThreadPool(threads, new NamedThreadFactory("ConcurrentCoapResource-" + name + '#')));
    }

    public void setExecutor(ExecutorService executor) {
        this.executor = executor;
    }

    @Override
    public Executor getExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return super.getExecutor();
    }

    protected static int getAvailableProcessors() {
        return Runtime.getRuntime().availableProcessors();
    }

    public int getThreadCount() {
        return this.threads;
    }

    public static ConcurrentCoapResource createConcurrentCoapResource(int threads, final Resource impl) {
        return new ConcurrentCoapResource(impl.getName(), threads){

            @Override
            public void handleRequest(Exchange exchange) {
                impl.handleRequest(exchange);
            }
        };
    }
}

