/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORException;
import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.CBORType;
import com.upokecenter.numbers.EInteger;
import java.util.HashMap;
import java.util.Map;

final class JSONPointer {
    private String refValue;
    private CBORObject jsonobj;

    public static JSONPointer FromPointer(CBORObject obj, String pointer) {
        block24: {
            int index = 0;
            if (pointer == null) {
                throw new NullPointerException("pointer");
            }
            if (obj == null) {
                throw new NullPointerException("obj");
            }
            if (pointer.length() == 0) {
                return new JSONPointer(obj, pointer);
            }
            while (true) {
                char c;
                if (obj == null) {
                    throw new CBORException("Invalid pointer: obj is null");
                }
                if (obj.getType() == CBORType.Array) {
                    if (index >= pointer.length() || pointer.charAt(index) != '/') {
                        throw new CBORException("Invalid pointer");
                    }
                    int[] value = new int[]{0};
                    int newIndex = JSONPointer.ReadPositiveInteger(pointer, ++index, value);
                    if (value[0] < 0) {
                        if (index < pointer.length() && pointer.charAt(index) == '-' && (index + 1 == pointer.length() || pointer.charAt(index + 1) == '/')) {
                            return new JSONPointer(obj, "-");
                        }
                        throw new CBORException("Invalid pointer");
                    }
                    if (newIndex == pointer.length()) {
                        return new JSONPointer(obj, pointer.substring(index));
                    }
                    if (value[0] > obj.size()) {
                        throw new CBORException("Invalid array index in pointer");
                    }
                    if (value[0] == obj.size()) {
                        if (newIndex + 1 == pointer.length()) {
                            return new JSONPointer(obj, pointer.substring(index));
                        }
                        throw new CBORException("Invalid array index in pointer");
                    }
                    obj = obj.get(value[0]);
                    index = newIndex;
                    index = newIndex;
                    continue;
                }
                if (obj.getType() != CBORType.Map) break block24;
                if (index >= pointer.length() || pointer.charAt(index) != '/') {
                    throw new CBORException("Invalid pointer");
                }
                String key = null;
                int oldIndex = ++index;
                boolean tilde = false;
                while (index < pointer.length() && (c = pointer.charAt(index)) != '/') {
                    if (c == '~') {
                        tilde = true;
                        break;
                    }
                    ++index;
                }
                if (!tilde) {
                    key = pointer.substring(oldIndex, oldIndex + (index - oldIndex));
                } else {
                    char c2;
                    index = oldIndex;
                    StringBuilder sb = new StringBuilder();
                    while (index < pointer.length() && (c2 = pointer.charAt(index)) != '/') {
                        if (c2 == '~') {
                            if (index + 1 < pointer.length()) {
                                if (pointer.charAt(index + 1) == '1') {
                                    index += 2;
                                    sb.append('/');
                                    continue;
                                }
                                if (pointer.charAt(index + 1) == '0') {
                                    index += 2;
                                    sb.append('~');
                                    continue;
                                }
                            }
                            throw new CBORException("Invalid pointer");
                        }
                        sb.append(c2);
                        ++index;
                    }
                    key = sb.toString();
                }
                if (index == pointer.length()) {
                    return new JSONPointer(obj, key);
                }
                if ((obj = obj.GetOrDefault(key, null)) == null) break;
            }
            throw new CBORException("Invalid pointer; key not found");
        }
        throw new CBORException("Invalid pointer");
    }

    public static CBORObject GetObject(CBORObject obj, String pointer, CBORObject defaultValue) {
        if (obj == null) {
            throw new CBORException("obj");
        }
        if (pointer == null) {
            return defaultValue;
        }
        if (pointer.length() == 0) {
            return obj;
        }
        if (obj.getType() != CBORType.Array && obj.getType() != CBORType.Map) {
            return defaultValue;
        }
        try {
            CBORObject cobj = JSONPointer.FromPointer(obj, pointer).GetValue();
            return cobj == null ? defaultValue : cobj;
        }
        catch (CBORException ex) {
            return defaultValue;
        }
    }

    private static int ReadPositiveInteger(String str, int index, int[] result) {
        boolean haveNumber = false;
        boolean haveZeros = false;
        int oldIndex = index;
        result[0] = -1;
        if (index == str.length()) {
            return index;
        }
        if (str.length() - 1 == index && str.charAt(index) == '0') {
            result[0] = 0;
            return index + 1;
        }
        if (str.length() - 1 > index && str.charAt(index) == '0' && str.charAt(index + 1) != '0') {
            result[0] = 0;
            return index + 1;
        }
        if (str.charAt(index) == '0') {
            return index;
        }
        long lvalue = 0L;
        while (index < str.length()) {
            char number;
            if ((number = str.charAt(index++)) < '0' || number > '9') {
                --index;
                break;
            }
            lvalue = lvalue * 10L + (long)(number - 48);
            haveNumber = true;
            if (haveZeros) {
                return oldIndex + 1;
            }
            if (lvalue <= Integer.MAX_VALUE) continue;
            return index - 1;
        }
        if (!haveNumber) {
            return index;
        }
        result[0] = (int)lvalue;
        return index;
    }

    private JSONPointer(CBORObject jsonobj, String refValue) {
        this.jsonobj = jsonobj;
        this.refValue = refValue;
    }

    public boolean Exists() {
        if (this.refValue.length() == 0) {
            return true;
        }
        if (this.jsonobj.getType() == CBORType.Array) {
            if (this.refValue.equals("-")) {
                return false;
            }
            EInteger eivalue = EInteger.FromString(this.refValue);
            int icount = this.jsonobj.size();
            return eivalue.signum() >= 0 && eivalue.compareTo(EInteger.FromInt32(icount)) < 0;
        }
        if (this.jsonobj.getType() == CBORType.Map) {
            return this.jsonobj.ContainsKey(this.refValue);
        }
        return this.refValue.length() == 0;
    }

    public int GetIndex() {
        if (this.jsonobj.getType() == CBORType.Array) {
            if (this.refValue.equals("-")) {
                return this.jsonobj.size();
            }
            EInteger value = EInteger.FromString(this.refValue);
            int icount = this.jsonobj.size();
            return value.signum() < 0 ? -1 : (value.compareTo(EInteger.FromInt32(icount)) > 0 ? -1 : value.ToInt32Unchecked());
        }
        return -1;
    }

    public String GetKey() {
        return this.refValue;
    }

    public CBORObject GetParent() {
        return this.jsonobj;
    }

    public CBORObject GetValue() {
        if (this.refValue.length() == 0) {
            return this.jsonobj;
        }
        CBORObject tmpcbor = null;
        if (this.jsonobj.getType() == CBORType.Array) {
            int index = this.GetIndex();
            if (index >= 0 && index < this.jsonobj.size()) {
                tmpcbor = this.jsonobj;
                return tmpcbor.get(index);
            }
            return null;
        }
        if (this.jsonobj.getType() == CBORType.Map) {
            tmpcbor = this.jsonobj;
            return tmpcbor.GetOrDefault(this.refValue, null);
        }
        return this.refValue.length() == 0 ? this.jsonobj : null;
    }

    public static Map<String, CBORObject> GetPointersWithKeyAndRemove(CBORObject root, String keyToFind) {
        HashMap<String, CBORObject> list = new HashMap<String, CBORObject>();
        if (root == null) {
            throw new NullPointerException("root");
        }
        JSONPointer.GetPointersWithKey(root, keyToFind, "", list, true);
        return list;
    }

    public static Map<String, CBORObject> GetPointersWithKey(CBORObject root, String keyToFind) {
        HashMap<String, CBORObject> list = new HashMap<String, CBORObject>();
        if (root == null) {
            throw new NullPointerException("root");
        }
        JSONPointer.GetPointersWithKey(root, keyToFind, "", list, false);
        return list;
    }

    private static String Replace(String str, char c, String srep) {
        int j = -1;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != c) continue;
            j = i;
            break;
        }
        if (j == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(str.substring(0, j));
        sb.append(srep);
        for (int i = j + 1; i < str.length(); ++i) {
            if (str.charAt(i) == c) {
                sb.append(srep);
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    private static void GetPointersWithKey(CBORObject root, String keyToFind, String currentPointer, Map<String, CBORObject> pointerList, boolean remove) {
        block5: {
            block4: {
                if (root.getType() != CBORType.Map) break block4;
                CBORObject rootObj = root;
                if (rootObj.ContainsKey(keyToFind)) {
                    CBORObject pointerKey = rootObj.get(keyToFind);
                    pointerList.put(currentPointer, pointerKey);
                    if (remove) {
                        rootObj.Remove(CBORObject.FromObject(keyToFind));
                    }
                }
                for (CBORObject key : rootObj.getKeys()) {
                    String ptrkey = key.AsString();
                    ptrkey = JSONPointer.Replace(ptrkey, '~', "~0");
                    ptrkey = JSONPointer.Replace(ptrkey, '/', "~1");
                    JSONPointer.GetPointersWithKey(rootObj.get(key), keyToFind, currentPointer + "/" + ptrkey, pointerList, remove);
                }
                break block5;
            }
            if (root.getType() != CBORType.Array) break block5;
            for (int i = 0; i < root.size(); ++i) {
                String ptrkey = EInteger.FromInt32(i).toString();
                JSONPointer.GetPointersWithKey(root.get(i), keyToFind, currentPointer + "/" + ptrkey, pointerList, remove);
            }
        }
    }
}

