/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.config.CoapConfig;
import org.eclipse.californium.core.network.GroupedMessageIdTracker;
import org.eclipse.californium.core.network.MapBasedMessageIdTracker;
import org.eclipse.californium.core.network.MessageIdProvider;
import org.eclipse.californium.core.network.MessageIdTracker;
import org.eclipse.californium.core.network.NullMessageIdTracker;
import org.eclipse.californium.elements.config.Configuration;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryMessageIdProvider
implements MessageIdProvider {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryMessageIdProvider.class);
    private final LeastRecentlyUsedCache<InetSocketAddress, MessageIdTracker> trackers;
    private final MessageIdTracker multicastTracker;
    private final CoapConfig.TrackerMode mode;
    private final Random random;
    private final Configuration config;
    private final int multicastBaseMid;

    public InMemoryMessageIdProvider(Configuration config) {
        CoapConfig.TrackerMode mode;
        if (config == null) {
            throw new NullPointerException("Config must not be null");
        }
        this.mode = mode = config.get(CoapConfig.MID_TRACKER);
        this.config = config;
        this.random = config.get(CoapConfig.USE_RANDOM_MID_START) != false ? new Random(ClockUtil.nanoRealtime()) : null;
        this.trackers = new LeastRecentlyUsedCache(config.get(CoapConfig.MAX_ACTIVE_PEERS), config.get(CoapConfig.MAX_PEER_INACTIVITY_PERIOD, TimeUnit.SECONDS));
        this.trackers.setEvictingOnReadAccess(false);
        int multicastBaseMid = config.get(CoapConfig.MULTICAST_BASE_MID);
        if (0 < multicastBaseMid) {
            this.multicastBaseMid = multicastBaseMid;
            int max = 65536;
            int mid = null == this.random ? multicastBaseMid : this.random.nextInt(max - multicastBaseMid) + multicastBaseMid;
            switch (mode) {
                case NULL: {
                    this.multicastTracker = new NullMessageIdTracker(mid, multicastBaseMid, max);
                    break;
                }
                case MAPBASED: {
                    this.multicastTracker = new MapBasedMessageIdTracker(mid, multicastBaseMid, max, config);
                    break;
                }
                default: {
                    this.multicastTracker = new GroupedMessageIdTracker(mid, multicastBaseMid, max, config);
                    break;
                }
            }
        } else {
            this.multicastBaseMid = 65536;
            this.multicastTracker = null;
        }
    }

    @Override
    public int getNextMessageId(InetSocketAddress destination) {
        MessageIdTracker tracker = this.getTracker(destination);
        if (tracker == null) {
            String time = this.trackers.getExpirationThreshold() + "s";
            throw new IllegalStateException("No MID available, max. peers " + this.trackers.size() + " exhausted! (Timeout " + time + ".)");
        }
        return tracker.getNextMessageId();
    }

    private synchronized MessageIdTracker getTracker(InetSocketAddress destination) {
        if (NetworkInterfacesUtil.isMultiAddress(destination.getAddress())) {
            if (this.multicastTracker == null) {
                LOG.warn("Destination address {} is a multicast address, please configure NetworkConfig to support multicast messaging", (Object)destination);
            }
            return this.multicastTracker;
        }
        MessageIdTracker tracker = this.trackers.get(destination);
        if (tracker == null) {
            int mid = null == this.random ? 0 : this.random.nextInt(this.multicastBaseMid);
            switch (this.mode) {
                case NULL: {
                    tracker = new NullMessageIdTracker(mid, 0, this.multicastBaseMid);
                    break;
                }
                case MAPBASED: {
                    tracker = new MapBasedMessageIdTracker(mid, 0, this.multicastBaseMid, this.config);
                    break;
                }
                default: {
                    tracker = new GroupedMessageIdTracker(mid, 0, this.multicastBaseMid, this.config);
                }
            }
            if (this.trackers.put(destination, tracker)) {
                return tracker;
            }
            return null;
        }
        return tracker;
    }
}

