/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.config;

import org.eclipse.californium.elements.Definition;
import org.eclipse.californium.elements.config.ValueException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DocumentedDefinition<T>
extends Definition<T> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(DocumentedDefinition.class);
    private final String documentation;
    private final T defaultValue;

    DocumentedDefinition(String key, String documentation, Class<T> valueType) {
        this(key, documentation, valueType, null);
    }

    DocumentedDefinition(String key, String documentation, Class<T> valueType, T defaultValue) {
        super(key, valueType);
        this.documentation = documentation;
        this.defaultValue = defaultValue;
    }

    public String getTypeName() {
        return this.getValueType().getSimpleName();
    }

    public abstract String writeValue(T var1);

    public String getDocumentation() {
        return this.documentation;
    }

    public T defaultValue() {
        return this.defaultValue;
    }

    public T readValue(String value) {
        if (value == null) {
            LOGGER.debug("key [{}] is undefined", (Object)this.getKey());
            return null;
        }
        if (this.useTrim()) {
            value = value.trim();
        }
        if (value.isEmpty()) {
            LOGGER.debug("key [{}] is empty", (Object)this.getKey());
            return null;
        }
        try {
            T result = this.parseValue(value);
            return this.checkValue(result);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Key '{}': value '{}' is no {}", this.getKey(), value, this.getTypeName());
        }
        catch (ValueException e) {
            LOGGER.warn("Key '{}': {}", (Object)this.getKey(), (Object)e.getMessage());
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Key '{}': value '{}' {}", this.getKey(), value, e.getMessage());
        }
        return null;
    }

    public T checkValue(T value) throws ValueException {
        return value;
    }

    protected boolean isAssignableFrom(Object value) {
        return this.getValueType().isInstance(value);
    }

    protected abstract T parseValue(String var1) throws ValueException;

    protected boolean useTrim() {
        return true;
    }

    protected String write(Object value) {
        return this.writeValue(value);
    }
}

