/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Token;

public class Response
extends Message {
    private final CoAP.ResponseCode code;
    private volatile Long applicationRttNanos;
    private volatile Long transmissionRttNanos;

    public static Response createResponse(Request receivedRequest, CoAP.ResponseCode code) {
        if (receivedRequest == null) {
            throw new NullPointerException("received request must not be null!");
        }
        if (receivedRequest.getSourceContext() == null) {
            throw new IllegalArgumentException("received request must contain a source context.");
        }
        Response response = new Response(code);
        response.setDestinationContext(receivedRequest.getSourceContext());
        return response;
    }

    public Response(CoAP.ResponseCode code) {
        if (code == null) {
            throw new NullPointerException("ResponseCode must not be null!");
        }
        this.code = code;
    }

    public CoAP.ResponseCode getCode() {
        return this.code;
    }

    @Override
    public int getRawCode() {
        return this.code.value;
    }

    @Override
    public void assertPayloadMatchsBlocksize() {
        BlockOption block2 = this.getOptions().getBlock2();
        if (block2 != null) {
            block2.assertPayloadSize(this.getPayloadSize());
        }
    }

    public String toString() {
        return this.toTracingString(this.code.toString());
    }

    public Long getApplicationRttNanos() {
        return this.applicationRttNanos;
    }

    public void setApplicationRttNanos(long rttNanos) {
        this.applicationRttNanos = rttNanos;
    }

    public Long getTransmissionRttNanos() {
        return this.transmissionRttNanos;
    }

    public void setTransmissionRttNanos(long rtt) {
        this.transmissionRttNanos = rtt;
    }

    public void ensureToken(Token token) {
        Token current = this.getToken();
        if (current == null) {
            this.setToken(token);
        } else if (!current.equals(token)) {
            throw new IllegalArgumentException("token mismatch! (" + current + "!=" + token + ")");
        }
    }

    public boolean isNotification() {
        return this.getOptions().hasObserve();
    }

    public boolean hasBlockOption() {
        return this.getOptions().hasBlock1() || this.getOptions().hasBlock2();
    }

    @Override
    public boolean hasBlock(BlockOption block) {
        return this.hasBlock(block, this.getOptions().getBlock2());
    }

    public final boolean isError() {
        return this.isClientError() || this.isServerError();
    }

    public final boolean isClientError() {
        return CoAP.ResponseCode.isClientError(this.code);
    }

    public final boolean isServerError() {
        return CoAP.ResponseCode.isServerError(this.code);
    }
}

