/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class TcpEndpointContext
extends MapBasedEndpointContext {
    public static final String KEY_CONNECTION_ID = "CONNECTION_ID";
    public static final String KEY_CONNECTION_TIMESTAMP = "CONNECTION_TIMESTAMP";

    public TcpEndpointContext(InetSocketAddress peerAddress, String connectionId, long timestamp) {
        this(peerAddress, null, new MapBasedEndpointContext.Attributes().add(KEY_CONNECTION_ID, connectionId).add(KEY_CONNECTION_TIMESTAMP, timestamp));
    }

    protected TcpEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, MapBasedEndpointContext.Attributes attributes) {
        super(peerAddress, peerIdentity, attributes);
        if (null == this.getConnectionId()) {
            throw new IllegalArgumentException("Missing CONNECTION_ID attribute!");
        }
    }

    public String getConnectionId() {
        return this.getString(KEY_CONNECTION_ID);
    }

    public final Number getConnectionTimestamp() {
        return this.getNumber(KEY_CONNECTION_TIMESTAMP);
    }

    @Override
    public String toString() {
        return String.format("TCP(%s,ID:%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getConnectionId(), 10));
    }
}

