/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERational;

final class ERationalByteArrayString {
    private static final int MaxSafeInt = 0xCCCCCCB;

    private ERationalByteArrayString() {
    }

    public static ERational FromString(byte[] chars, int offset, int length) {
        int tmpoffset = offset;
        if (chars == null) {
            throw new NullPointerException("chars");
        }
        if (tmpoffset < 0) {
            throw new NumberFormatException("offset(" + tmpoffset + ") is less than 0");
        }
        if (tmpoffset > chars.length) {
            throw new NumberFormatException("offset(" + tmpoffset + ") is more than " + chars.length);
        }
        if (length < 0) {
            throw new NumberFormatException("length(" + length + ") is less than 0");
        }
        if (length > chars.length) {
            throw new NumberFormatException("length(" + length + ") is more than " + chars.length);
        }
        if (chars.length - tmpoffset < length) {
            throw new NumberFormatException("chars's length minus " + tmpoffset + "(" + (chars.length - tmpoffset) + ") is less than " + length);
        }
        if (length == 0) {
            throw new NumberFormatException();
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        if (chars[tmpoffset] == 43 || chars[tmpoffset] == 45) {
            negative = chars[tmpoffset] == 45;
            ++tmpoffset;
        }
        int numerInt = 0;
        EInteger numer = null;
        boolean haveDigits = false;
        boolean haveDenominator = false;
        int ndenomInt = 0;
        EInteger ndenom = null;
        int i = tmpoffset;
        if (!(i + 8 != endStr || chars[i] != 73 && chars[i] != 105 || chars[i + 1] != 78 && chars[i + 1] != 110 || chars[i + 2] != 70 && chars[i + 2] != 102 || chars[i + 3] != 73 && chars[i + 3] != 105 || chars[i + 4] != 78 && chars[i + 4] != 110 || chars[i + 5] != 73 && chars[i + 5] != 105 || chars[i + 6] != 84 && chars[i + 6] != 116 || chars[i + 7] != 89 && chars[i + 7] != 121)) {
            return negative ? ERational.NegativeInfinity : ERational.PositiveInfinity;
        }
        if (!(i + 3 != endStr || chars[i] != 73 && chars[i] != 105 || chars[i + 1] != 78 && chars[i + 1] != 110 || chars[i + 2] != 70 && chars[i + 2] != 102)) {
            return negative ? ERational.NegativeInfinity : ERational.PositiveInfinity;
        }
        int numerStart = 0;
        if (!(i + 3 > endStr || chars[i] != 78 && chars[i] != 110 || chars[i + 1] != 65 && chars[i + 1] != 97 || chars[i + 2] != 78 && chars[i + 2] != 110)) {
            if (i + 3 == endStr) {
                return !negative ? ERational.NaN : ERational.NaN.Negate();
            }
            numerStart = i += 3;
            while (i < endStr) {
                if (chars[i] >= 48 && chars[i] <= 57) {
                    int thisdigit = chars[i] - 48;
                    if (numerInt <= 0xCCCCCCB) {
                        numerInt *= 10;
                        numerInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (numerInt > 0xCCCCCCB) {
                numer = EInteger.FromSubstring(chars, numerStart, endStr);
                return ERational.CreateNaN(numer, false, negative);
            }
            return ERational.CreateNaN(EInteger.FromInt32(numerInt), false, negative);
        }
        if (!(i + 4 > endStr || chars[i] != 83 && chars[i] != 115 || chars[i + 1] != 78 && chars[i + 1] != 110 || chars[i + 2] != 65 && chars[i + 2] != 97 || chars[i + 3] != 78 && chars[i + 3] != 110)) {
            if (i + 4 == endStr) {
                return !negative ? ERational.SignalingNaN : ERational.SignalingNaN.Negate();
            }
            numerStart = i += 4;
            while (i < endStr) {
                if (chars[i] >= 48 && chars[i] <= 57) {
                    int thisdigit = chars[i] - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (numerInt <= 0xCCCCCCB) {
                        numerInt *= 10;
                        numerInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            int flags3 = (negative ? 1 : 0) | 8;
            if (numerInt > 0xCCCCCCB) {
                numer = EInteger.FromSubstring(chars, numerStart, endStr);
                return ERational.CreateNaN(numer, true, negative);
            }
            return ERational.CreateNaN(EInteger.FromInt32(numerInt), true, negative);
        }
        numerStart = i;
        int numerEnd = i;
        while (i < endStr) {
            if (chars[i] >= 48 && chars[i] <= 57) {
                int thisdigit = chars[i] - 48;
                numerEnd = i + 1;
                if (numerInt <= 0xCCCCCCB) {
                    numerInt *= 10;
                    numerInt += thisdigit;
                }
            } else {
                if (chars[i] == 47) {
                    haveDenominator = true;
                    ++i;
                    break;
                }
                throw new NumberFormatException();
            }
            haveDigits = true;
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (numerInt > 0xCCCCCCB) {
            numer = EInteger.FromSubstring(chars, numerStart, numerEnd);
        }
        if (haveDenominator) {
            EInteger denom = null;
            int denomInt = 0;
            tmpoffset = 1;
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            numerStart = i;
            while (i < endStr) {
                if (chars[i] >= 48 && chars[i] <= 57) {
                    haveDigits = true;
                    int thisdigit = chars[i] - 48;
                    numerEnd = i + 1;
                    if (denomInt <= 0xCCCCCCB) {
                        denomInt *= 10;
                        denomInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
            if (denomInt > 0xCCCCCCB) {
                denom = EInteger.FromSubstring(chars, numerStart, numerEnd);
            }
            if (denom == null) {
                ndenomInt = denomInt;
            } else {
                ndenom = denom;
            }
        } else {
            ndenomInt = 1;
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        if (ndenom == null ? ndenomInt == 0 : ndenom.isZero()) {
            throw new NumberFormatException();
        }
        ERational erat = ERational.Create(numer == null ? EInteger.FromInt32(numerInt) : numer, ndenom == null ? EInteger.FromInt32(ndenomInt) : ndenom);
        return negative ? erat.Negate() : erat;
    }
}

