/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateTypeExtension;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.ConnectionIdExtension;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.eclipse.californium.scandium.dtls.HelloExtensions;
import org.eclipse.californium.scandium.dtls.MaxFragmentLengthExtension;
import org.eclipse.californium.scandium.dtls.ProtocolVersion;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordSizeLimitExtension;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SupportedPointFormatsExtension;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;

public final class ServerHello
extends HandshakeMessage {
    private static final int VERSION_BITS = 8;
    private static final int RANDOM_BYTES = 32;
    private static final int SESSION_ID_LENGTH_BITS = 8;
    private static final int CIPHER_SUITE_BITS = 16;
    private static final int COMPRESSION_METHOD_BITS = 8;
    private final ProtocolVersion serverVersion;
    private final Random random;
    private final SessionId sessionId;
    private final CipherSuite cipherSuite;
    private final CompressionMethod compressionMethod;
    private final HelloExtensions extensions;

    public ServerHello(ProtocolVersion version, Random random, SessionId sessionId, CipherSuite cipherSuite, CompressionMethod compressionMethod) {
        if (version == null) {
            throw new NullPointerException("Negotiated protocol version must not be null");
        }
        if (random == null) {
            throw new NullPointerException("ServerHello message must contain a random");
        }
        if (sessionId == null) {
            throw new NullPointerException("ServerHello must be associated with a session ID");
        }
        if (cipherSuite == null) {
            throw new NullPointerException("Negotiated cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Negotiated compression method must not be null");
        }
        this.serverVersion = version;
        this.random = random;
        this.sessionId = sessionId;
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
        this.extensions = new HelloExtensions();
    }

    private ServerHello(DatagramReader reader) throws HandshakeException {
        int major = reader.read(8);
        int minor = reader.read(8);
        this.serverVersion = ProtocolVersion.valueOf(major, minor);
        this.random = new Random(reader.readBytes(32));
        this.sessionId = new SessionId(reader.readVarBytes(8));
        int code = reader.read(16);
        this.cipherSuite = CipherSuite.getTypeByCode(code);
        if (this.cipherSuite == null) {
            throw new HandshakeException(String.format("Server selected unknown cipher suite [%s]", Integer.toHexString(code)), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        if (this.cipherSuite == CipherSuite.TLS_NULL_WITH_NULL_NULL) {
            throw new HandshakeException("Server tries to negotiate NULL cipher suite", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE));
        }
        this.compressionMethod = CompressionMethod.getMethodByCode(reader.read(8));
        this.extensions = HelloExtensions.fromReader(reader);
    }

    @Override
    public byte[] fragmentToByteArray() {
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.serverVersion.getMajor(), 8);
        writer.write(this.serverVersion.getMinor(), 8);
        writer.writeBytes(this.random.getBytes());
        writer.writeVarBytes(this.sessionId, 8);
        writer.write(this.cipherSuite.getCode(), 16);
        writer.write(this.compressionMethod.getCode(), 8);
        writer.writeBytes(this.extensions.toByteArray());
        return writer.toByteArray();
    }

    public static HandshakeMessage fromReader(DatagramReader reader) throws HandshakeException {
        return new ServerHello(reader);
    }

    @Override
    public HandshakeType getMessageType() {
        return HandshakeType.SERVER_HELLO;
    }

    @Override
    public int getMessageLength() {
        int extensionsLength = this.extensions.isEmpty() ? 0 : 2 + this.extensions.getLength();
        return 38 + this.sessionId.length() + extensionsLength;
    }

    public ProtocolVersion getServerVersion() {
        return this.serverVersion;
    }

    public Random getRandom() {
        return this.random;
    }

    public SessionId getSessionId() {
        return this.sessionId;
    }

    public CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    public HelloExtensions getExtensions() {
        return this.extensions;
    }

    void addExtension(HelloExtension extension) {
        this.extensions.addExtension(extension);
    }

    CertificateType getClientCertificateType() {
        return this.getCertificateType(HelloExtension.ExtensionType.CLIENT_CERT_TYPE);
    }

    CertificateType getServerCertificateType() {
        return this.getCertificateType(HelloExtension.ExtensionType.SERVER_CERT_TYPE);
    }

    private CertificateType getCertificateType(HelloExtension.ExtensionType type) {
        CertificateType result = CertificateType.X_509;
        CertificateTypeExtension certificateExtension = (CertificateTypeExtension)this.extensions.getExtension(type);
        if (certificateExtension != null && !certificateExtension.getCertificateTypes().isEmpty()) {
            result = certificateExtension.getCertificateTypes().get(0);
        }
        return result;
    }

    MaxFragmentLengthExtension getMaxFragmentLength() {
        return (MaxFragmentLengthExtension)this.extensions.getExtension(HelloExtension.ExtensionType.MAX_FRAGMENT_LENGTH);
    }

    RecordSizeLimitExtension getRecordSizeLimit() {
        return (RecordSizeLimitExtension)this.extensions.getExtension(HelloExtension.ExtensionType.RECORD_SIZE_LIMIT);
    }

    boolean hasExtendedMasterSecret() {
        return this.extensions.getExtension(HelloExtension.ExtensionType.EXTENDED_MASTER_SECRET) != null;
    }

    SupportedPointFormatsExtension getSupportedPointFormatsExtension() {
        return (SupportedPointFormatsExtension)this.extensions.getExtension(HelloExtension.ExtensionType.EC_POINT_FORMATS);
    }

    public ConnectionIdExtension getConnectionIdExtension() {
        return (ConnectionIdExtension)this.extensions.getExtension(HelloExtension.ExtensionType.CONNECTION_ID);
    }

    boolean hasServerNameExtension() {
        return this.extensions.getExtension(HelloExtension.ExtensionType.SERVER_NAME) != null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString());
        sb.append("\t\tServer Version: ").append(this.serverVersion.getMajor()).append(", ").append(this.serverVersion.getMinor());
        sb.append(StringUtil.lineSeparator()).append("\t\tRandom:").append(this.random);
        sb.append(StringUtil.lineSeparator()).append("\t\tSession ID Length: ").append(this.sessionId.length());
        if (this.sessionId.length() > 0) {
            sb.append(StringUtil.lineSeparator()).append("\t\tSession ID: ").append(this.sessionId);
        }
        sb.append(StringUtil.lineSeparator()).append("\t\tCipher Suite: ").append((Object)this.cipherSuite);
        sb.append(StringUtil.lineSeparator()).append("\t\tCompression Method: ").append((Object)this.compressionMethod);
        sb.append(StringUtil.lineSeparator()).append(this.extensions);
        return sb.toString();
    }
}

