/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.MessageDigest;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.elements.util.NoPublicAPI;
import org.eclipse.californium.scandium.config.DtlsConnectorConfig;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.ChangeCipherSpecMessage;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ContentType;
import org.eclipse.californium.scandium.dtls.DTLSFlight;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.ExtendedMasterSecretMode;
import org.eclipse.californium.scandium.dtls.Finished;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HandshakeMessage;
import org.eclipse.californium.scandium.dtls.HandshakeResult;
import org.eclipse.californium.scandium.dtls.HandshakeState;
import org.eclipse.californium.scandium.dtls.HandshakeType;
import org.eclipse.californium.scandium.dtls.Random;
import org.eclipse.californium.scandium.dtls.RecordLayer;
import org.eclipse.californium.scandium.dtls.ResumptionVerificationResult;
import org.eclipse.californium.scandium.dtls.ServerHandshaker;
import org.eclipse.californium.scandium.dtls.ServerHello;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.dtls.resumption.ResumptionVerifier;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;

@NoPublicAPI
public class ResumingServerHandshaker
extends ServerHandshaker {
    private static final HandshakeState[] ABBREVIATED_HANDSHAKE = new HandshakeState[]{new HandshakeState(ContentType.CHANGE_CIPHER_SPEC), new HandshakeState(HandshakeType.FINISHED)};
    private final ResumptionVerifier resumptionHandler;
    private ClientHello pendingClientHello;
    private boolean fullHandshake;
    private byte[] handshakeHash;

    public ResumingServerHandshaker(long initialRecordSequenceNo, int sequenceNumber, RecordLayer recordLayer, ScheduledExecutorService timer, Connection connection, DtlsConnectorConfig config) {
        super(initialRecordSequenceNo, sequenceNumber, recordLayer, timer, connection, config);
        this.resumptionHandler = config.getResumptionVerifier();
        if (this.resumptionHandler == null) {
            throw new IllegalArgumentException("Resumption verifier missing!");
        }
    }

    @Override
    protected void doProcessMessage(HandshakeMessage message) throws HandshakeException {
        if (this.fullHandshake) {
            super.doProcessMessage(message);
            return;
        }
        switch (message.getMessageType()) {
            case CLIENT_HELLO: {
                this.handshakeStarted();
                this.receivedResumingClientHello((ClientHello)message);
                break;
            }
            case FINISHED: {
                this.receivedClientFinished((Finished)message);
                break;
            }
            default: {
                throw new HandshakeException(String.format("Received unexpected handshake message [%s] from peer %s", new Object[]{message.getMessageType(), this.peerToLog}), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.UNEXPECTED_MESSAGE));
            }
        }
    }

    private void receivedResumingClientHello(ClientHello clientHello) throws HandshakeException {
        if (!clientHello.hasSessionId()) {
            throw new IllegalArgumentException("Client hello doesn't contain session id required for resumption!");
        }
        this.pendingClientHello = clientHello;
        ResumptionVerificationResult result = this.resumptionHandler.verifyResumptionRequest(this.getConnection().getConnectionId(), clientHello.getServerNames(), clientHello.getSessionId());
        if (result != null) {
            this.LOGGER.debug("Process client hello synchronous");
            this.processResumptionVerificationResult(result);
        } else {
            this.startInitialTimeout();
        }
    }

    private void receivedClientFinished(Finished message) throws HandshakeException {
        this.verifyFinished(message, this.handshakeHash);
        this.contextEstablished();
        this.handshakeCompleted();
    }

    @Override
    protected boolean hasPendingApiCall() {
        return this.pendingClientHello != null || super.hasPendingApiCall();
    }

    @Override
    public void processAsyncHandshakeResult(HandshakeResult handshakeResult) throws HandshakeException {
        if (handshakeResult instanceof ResumptionVerificationResult) {
            this.LOGGER.debug("Process client hello asynchronous");
            this.ensureUndestroyed();
            this.processResumptionVerificationResult((ResumptionVerificationResult)handshakeResult);
        }
        super.processAsyncHandshakeResult(handshakeResult);
    }

    private void processResumptionVerificationResult(ResumptionVerificationResult resumptionResult) throws HandshakeException {
        if (this.pendingClientHello == null) {
            throw new IllegalStateException("resumption verification not pending!");
        }
        ClientHello clientHello = this.pendingClientHello;
        this.pendingClientHello = null;
        DTLSSession session = resumptionResult.getDTLSSession();
        boolean bl = this.fullHandshake = !this.validateResumption(session, clientHello);
        if (this.fullHandshake) {
            this.LOGGER.debug("DTLS session {} not available, switch to full-handshake with peer [{}]!", (Object)clientHello.getSessionId(), this.peerToLog);
            SecretUtil.destroy(session);
            this.receivedClientHello(clientHello);
        } else {
            this.getSession().set(session);
            SecretUtil.destroy(session);
            this.setCustomArgument(resumptionResult);
            this.processResumingClientHello(clientHello);
        }
    }

    private boolean validateResumption(DTLSSession session, ClientHello clientHello) {
        ServerNames clientServerNames;
        ServerNames serverNames;
        if (session == null) {
            this.LOGGER.debug("DTLS session {} not available, switch to full-handshake with peer [{}]!", (Object)clientHello.getSessionId(), this.peerToLog);
            return false;
        }
        CipherSuite cipherSuite = session.getCipherSuite();
        CompressionMethod compressionMethod = session.getCompressionMethod();
        if (!clientHello.getCipherSuites().contains((Object)cipherSuite)) {
            this.LOGGER.debug("Cipher-suite {} changed by client hello, switch to full-handshake with peer [{}]!", (Object)cipherSuite, this.peerToLog);
            return false;
        }
        if (!session.getProtocolVersion().equals(clientHello.getClientVersion())) {
            this.LOGGER.debug("Protocol version {} changed by client hello {}, switch to full-handshake with peer [{}]!", session.getProtocolVersion(), clientHello.getClientVersion(), this.peerToLog);
            return false;
        }
        if (!clientHello.getCompressionMethods().contains((Object)compressionMethod)) {
            this.LOGGER.debug("Compression method {} changed by client hello, switch to full-handshake with peer [{}]!", (Object)session.getCompressionMethod(), this.peerToLog);
            return false;
        }
        if (this.extendedMasterSecretMode.is(ExtendedMasterSecretMode.ENABLED) && !clientHello.hasExtendedMasterSecret()) {
            this.LOGGER.debug("Missing extended master secret extension in client hello, switch to full-handshake with peer [{}]!", this.peerToLog);
            return false;
        }
        if (this.extendedMasterSecretMode == ExtendedMasterSecretMode.OPTIONAL && session.useExtendedMasterSecret() && !clientHello.hasExtendedMasterSecret()) {
            this.LOGGER.debug("Disabled extended master secret extension in client hello, switch to full-handshake with peer [{}]!", this.peerToLog);
            return false;
        }
        if (this.sniEnabled && !Objects.equals(serverNames = this.getServerNames(), clientServerNames = clientHello.getServerNames())) {
            this.LOGGER.debug("SNI {} changed by client hello {}, switch to full-handshake with peer [{}]!", serverNames, clientServerNames, this.peerToLog);
            return false;
        }
        return true;
    }

    private void processResumingClientHello(ClientHello clientHello) throws HandshakeException {
        DTLSSession session = this.getSession();
        CipherSuite cipherSuite = session.getCipherSuite();
        this.LOGGER.debug("Start resumption-handshake with peer [{}].", this.peerToLog);
        this.clientRandom = clientHello.getRandom();
        this.serverRandom = new Random();
        this.flightNumber += 2;
        DTLSFlight flight = this.createFlight();
        ServerHello serverHello = new ServerHello(clientHello.getClientVersion(), this.serverRandom, session.getSessionIdentifier(), cipherSuite, session.getCompressionMethod());
        this.addHelloExtensions(clientHello, serverHello);
        this.wrapMessage(flight, serverHello);
        ChangeCipherSpecMessage changeCipherSpecMessage = new ChangeCipherSpecMessage();
        this.wrapMessage(flight, changeCipherSpecMessage);
        MessageDigest md = this.getHandshakeMessageDigest();
        MessageDigest mdWithServerFinished = this.cloneMessageDigest(md);
        this.resumeMasterSecret();
        this.setCurrentWriteState();
        Finished finished = this.createFinishedMessage(md.digest());
        this.wrapMessage(flight, finished);
        mdWithServerFinished.update(finished.toByteArray());
        this.handshakeHash = mdWithServerFinished.digest();
        this.sendFlight(flight);
        this.setExpectedStates(ABBREVIATED_HANDSHAKE);
        this.expectChangeCipherSpecMessage();
    }
}

