/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.security.Principal;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.core.CoapResponse;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.MediaTypeRegistry;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public final class Utils {
    private Utils() {
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            return "null";
        }
        return "[" + StringUtil.byteArray2Hex(bytes) + "]";
    }

    public static String toHexText(byte[] bytes, int length) {
        if (bytes == null) {
            return "null";
        }
        if (length > bytes.length) {
            length = bytes.length;
        }
        StringBuilder sb = new StringBuilder();
        if (16 < length) {
            sb.append(StringUtil.lineSeparator());
        }
        for (int index = 0; index < length; ++index) {
            sb.append(String.format("%02x", bytes[index] & 0xFF));
            if (31 == (0x1F & index)) {
                sb.append(StringUtil.lineSeparator());
                continue;
            }
            sb.append(' ');
        }
        if (length < bytes.length) {
            sb.append(" .. ").append(bytes.length).append(" bytes");
        }
        return sb.toString();
    }

    public static String prettyPrint(Request request) {
        String nl = StringUtil.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Request ]=============================================").append(nl);
        sb.append(String.format("MID    : %d%n", request.getMID()));
        sb.append(String.format("Token  : %s%n", request.getTokenString()));
        sb.append(String.format("Type   : %s%n", new Object[]{request.getType()}));
        CoAP.Code code = request.getCode();
        if (code == null) {
            sb.append("Method : 0.00 - PING").append(nl);
        } else {
            sb.append(String.format("Method : %s - %s%n", code.text, code.name()));
        }
        if (request.getOffloadMode() != null) {
            sb.append("(offloaded)").append(nl);
        } else {
            sb.append(String.format("Options: %s%n", request.getOptions()));
            sb.append(String.format("Payload: %d Bytes%n", request.getPayloadSize()));
            if (request.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(request.getOptions().getContentFormat())) {
                sb.append("---------------------------------------------------------------").append(nl);
                sb.append(request.getPayloadString());
                sb.append(nl);
            }
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(CoapResponse response) {
        return Utils.prettyPrint(response.advanced());
    }

    public static String prettyPrint(Response response) {
        String nl = StringUtil.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append("==[ CoAP Response ]============================================").append(nl);
        sb.append(String.format("MID    : %d%n", response.getMID()));
        sb.append(String.format("Token  : %s%n", response.getTokenString()));
        sb.append(String.format("Type   : %s%n", new Object[]{response.getType()}));
        CoAP.ResponseCode code = response.getCode();
        sb.append(String.format("Status : %s - %s%n", new Object[]{code, code.name()}));
        Long rtt = response.getApplicationRttNanos();
        if (response.getOffloadMode() != null) {
            if (rtt != null) {
                sb.append(String.format("RTT    : %d ms%n", TimeUnit.NANOSECONDS.toMillis(rtt)));
            }
            sb.append("(offloaded)").append(nl);
        } else {
            sb.append(String.format("Options: %s%n", response.getOptions()));
            if (rtt != null) {
                sb.append(String.format("RTT    : %d ms%n", TimeUnit.NANOSECONDS.toMillis(rtt)));
            }
            sb.append(String.format("Payload: %d Bytes%n", response.getPayloadSize()));
            if (response.getPayloadSize() > 0 && MediaTypeRegistry.isPrintable(response.getOptions().getContentFormat())) {
                sb.append("---------------------------------------------------------------").append(nl);
                sb.append(response.getPayloadString());
                sb.append(nl);
            }
        }
        sb.append("===============================================================");
        return sb.toString();
    }

    public static String prettyPrint(EndpointContext endpointContext) {
        Principal principal;
        String nl = StringUtil.lineSeparator();
        StringBuilder sb = new StringBuilder();
        sb.append(">>> ").append(endpointContext);
        String cipher = endpointContext.getString("DTLS_CIPHER");
        if (cipher == null) {
            cipher = endpointContext.getString("TLS_CIPHER");
        }
        if (cipher != null) {
            sb.append(nl).append(">>> ").append(cipher);
        }
        if ((principal = endpointContext.getPeerIdentity()) != null) {
            sb.append(nl).append(">>> ").append(principal);
        }
        return sb.toString();
    }
}

