/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.scandium.util.ServerName;

public final class ServerNames
implements Iterable<ServerName> {
    private static final int LIST_LENGTH_BITS = 16;
    private final Set<ServerName> names = new LinkedHashSet<ServerName>();
    int encodedLength;

    private ServerNames() {
    }

    private ServerNames(ServerName serverName) {
        this();
        this.add(serverName);
    }

    public static ServerNames newInstance() {
        return new ServerNames();
    }

    public static ServerNames newInstance(ServerName serverName) {
        if (serverName == null) {
            throw new NullPointerException("server name must not be null");
        }
        return new ServerNames(serverName);
    }

    public static ServerNames newInstance(String hostName) {
        if (hostName == null) {
            throw new NullPointerException("host name must not be null");
        }
        return new ServerNames(ServerName.from(ServerName.NameType.HOST_NAME, hostName.getBytes(ServerName.CHARSET)));
    }

    public ServerNames add(ServerName serverName) {
        if (serverName == null) {
            throw new NullPointerException("server name must not be null");
        }
        if (this.names.contains(serverName)) {
            throw new IllegalStateException("there already is a name of the given type");
        }
        this.names.add(serverName);
        ++this.encodedLength;
        this.encodedLength += 2;
        this.encodedLength += serverName.getName().length;
        return this;
    }

    public int getEncodedLength() {
        return this.encodedLength;
    }

    public int size() {
        return this.names.size();
    }

    public byte[] get(ServerName.NameType type) {
        for (ServerName name : this.names) {
            if (!name.getType().equals((Object)type)) continue;
            return name.getName();
        }
        return null;
    }

    public void encode(DatagramWriter writer) {
        writer.write(this.encodedLength, 16);
        for (ServerName serverName : this.names) {
            writer.writeByte(serverName.getType().getCode());
            writer.writeVarBytes(serverName.getName(), 16);
        }
    }

    public void decode(DatagramReader reader) {
        int listLengthBytes = reader.read(16);
        DatagramReader rangeReader = reader.createRangeReader(listLengthBytes);
        block3: while (rangeReader.bytesAvailable()) {
            ServerName.NameType nameType = ServerName.NameType.fromCode(rangeReader.readNextByte());
            switch (nameType) {
                case HOST_NAME: {
                    byte[] hostname = rangeReader.readVarBytes(16);
                    this.add(ServerName.from(nameType, hostname));
                    continue block3;
                }
            }
            throw new IllegalArgumentException("ServerNames: unknown name_type!", new IllegalArgumentException(nameType.name()));
        }
    }

    public ServerName getServerName(ServerName.NameType type) {
        for (ServerName name : this.names) {
            if (!name.getType().equals((Object)type)) continue;
            return name;
        }
        return null;
    }

    @Override
    public Iterator<ServerName> iterator() {
        return this.names.iterator();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("ServerNames[");
        Iterator<ServerName> iter = this.names.iterator();
        while (iter.hasNext()) {
            b.append(iter.next().getNameAsString());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append("]");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (ServerName name : this.names) {
            result = 31 * result + name.hashCode();
        }
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServerNames other = (ServerNames)object;
        if (this.names.size() != other.names.size()) {
            return false;
        }
        return this.names.containsAll(other.names);
    }
}

