/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.x509;

import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.californium.elements.auth.RawPublicKeyIdentity;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.CertificateType;
import org.eclipse.californium.scandium.dtls.CertificateVerificationResult;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.x509.StaticNewAdvancedCertificateVerifier;
import org.eclipse.californium.scandium.util.ServerNames;

public class AsyncNewAdvancedCertificateVerifier
extends StaticNewAdvancedCertificateVerifier {
    private static final NamedThreadFactory THREAD_FACTORY = new DaemonThreadFactory("AsyncTimer#");
    private final ScheduledExecutorService executorService = ExecutorsUtil.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private volatile int delayMillis = 1;
    private HandshakeResultHandler resultHandler;

    public AsyncNewAdvancedCertificateVerifier(X509Certificate[] trustedCertificates, RawPublicKeyIdentity[] trustedRPKs, List<CertificateType> supportedCertificateTypes) {
        super(trustedCertificates, trustedRPKs, supportedCertificateTypes);
    }

    public AsyncNewAdvancedCertificateVerifier setDelay(int delayMillis) {
        this.delayMillis = delayMillis;
        if (delayMillis > 0) {
            this.LOGGER.info("Asynchronous delayed PSK store {}ms.", (Object)delayMillis);
        } else if (delayMillis < 0) {
            this.LOGGER.info("Synchronous delayed PSK store {}ms.", (Object)(-delayMillis));
        } else {
            this.LOGGER.info("Synchronous PSK store.");
        }
        return this;
    }

    public int getDelay() {
        return this.delayMillis;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public CertificateVerificationResult verifyCertificate(final ConnectionId cid, final ServerNames serverName, final boolean clientUsage, final boolean truncateCertificatePath, final CertificateMessage message) {
        if (this.delayMillis <= 0) {
            if (this.delayMillis < 0) {
                try {
                    Thread.sleep(-this.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return super.verifyCertificate(cid, serverName, clientUsage, truncateCertificatePath, message);
        }
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                AsyncNewAdvancedCertificateVerifier.this.verifyCertificateAsynchronous(cid, serverName, clientUsage, truncateCertificatePath, message);
            }
        }, (long)this.delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    private void verifyCertificateAsynchronous(ConnectionId cid, ServerNames serverName, boolean clientUsage, boolean truncateCertificatePath, CertificateMessage message) {
        CertificateVerificationResult result = super.verifyCertificate(cid, serverName, clientUsage, truncateCertificatePath, message);
        CertPath certPath = result.getCertificatePath();
        PublicKey publicKey = result.getPublicKey();
        if (certPath == null && publicKey == null) {
            this.LOGGER.info("Validation failed!");
        } else if (certPath != null) {
            this.LOGGER.info("Validation {}", (Object)certPath.getCertificates().size());
        } else if (publicKey != null) {
            this.LOGGER.info("Validation RPK");
        }
        this.resultHandler.apply(result);
    }

    @Override
    public void setResultHandler(HandshakeResultHandler resultHandler) {
        if (this.resultHandler != null && resultHandler != null && this.resultHandler != resultHandler) {
            throw new IllegalStateException("handshake result handler already set!");
        }
        this.resultHandler = resultHandler;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends StaticNewAdvancedCertificateVerifier.Builder {
        @Override
        public AsyncNewAdvancedCertificateVerifier build() {
            return new AsyncNewAdvancedCertificateVerifier(this.trustedCertificates, this.trustedRPKs, this.supportedCertificateTypes);
        }
    }
}

