/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.HelloExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HelloExtensions {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelloExtensions.class);
    public static final int LENGTH_BITS = 16;
    private final List<HelloExtension> extensions = new ArrayList<HelloExtension>();

    boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public int getLength() {
        int length = 0;
        for (HelloExtension extension : this.extensions) {
            length += extension.getLength();
        }
        return length;
    }

    public void addExtension(HelloExtension extension) {
        if (extension != null) {
            if (this.getExtension(extension.getType()) == null) {
                this.extensions.add(extension);
            } else {
                throw new IllegalArgumentException("Hello Extension of type " + (Object)((Object)extension.getType()) + " already added!");
            }
        }
    }

    public <T extends HelloExtension> T getExtension(HelloExtension.ExtensionType type) {
        if (type != null) {
            for (HelloExtension ext : this.extensions) {
                if (!type.equals((Object)ext.getType())) continue;
                return (T)ext;
            }
        }
        return null;
    }

    public List<HelloExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\t\tExtensions Length: ").append(this.getLength());
        for (HelloExtension ext : this.extensions) {
            sb.append(StringUtil.lineSeparator()).append(ext);
        }
        return sb.toString();
    }

    public byte[] toByteArray() {
        if (this.extensions.isEmpty()) {
            return Bytes.EMPTY;
        }
        DatagramWriter writer = new DatagramWriter();
        writer.write(this.getLength(), 16);
        for (HelloExtension extension : this.extensions) {
            writer.writeBytes(extension.toByteArray());
        }
        return writer.toByteArray();
    }

    public static HelloExtensions fromReader(DatagramReader reader) throws HandshakeException {
        try {
            HelloExtensions extensions = new HelloExtensions();
            if (reader.bytesAvailable()) {
                int length = reader.read(16);
                DatagramReader rangeReader = reader.createRangeReader(length);
                while (rangeReader.bytesAvailable()) {
                    int typeId = rangeReader.read(16);
                    int extensionLength = rangeReader.read(16);
                    DatagramReader extensionDataReader = rangeReader.createRangeReader(extensionLength);
                    HelloExtension extension = HelloExtension.fromExtensionDataReader(typeId, extensionDataReader);
                    if (extensionDataReader.bytesAvailable()) {
                        byte[] bytesLeft = extensionDataReader.readBytesLeft();
                        throw new HandshakeException(String.format("Too many bytes, %d left, hello extension not completely parsed! hello extension type %d", bytesLeft.length, typeId), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
                    }
                    if (extension != null) {
                        if (extensions.getExtension(extension.getType()) == null) {
                            extensions.addExtension(extension);
                            continue;
                        }
                        throw new HandshakeException("Hello message contains extension " + (Object)((Object)extension.getType()) + " more than once!", new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
                    }
                    LOGGER.debug("Peer included an unknown extension type code [{}] in its Hello message", (Object)typeId);
                }
            }
            return extensions;
        }
        catch (IllegalArgumentException ex) {
            throw new HandshakeException("Hello message contained malformed extensions, " + ex.getMessage(), new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.DECODE_ERROR));
        }
    }
}

