/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.californium.elements.util.Bytes;
import org.eclipse.californium.elements.util.DatagramReader;
import org.eclipse.californium.elements.util.DatagramWriter;

public class DataStreamReader {
    protected final InputStream byteStream;
    protected byte currentByte;
    protected int currentBitIndex;
    private byte markByte;
    private int markBitIndex;

    public DataStreamReader(InputStream byteStream) {
        if (byteStream == null) {
            throw new NullPointerException("byte stream must not be null!");
        }
        this.byteStream = byteStream;
        this.currentByte = 0;
        this.currentBitIndex = -1;
        this.markByte = this.currentByte;
        this.markBitIndex = this.currentBitIndex;
    }

    public void mark() {
        this.markByte = this.currentByte;
        this.markBitIndex = this.currentBitIndex;
        this.byteStream.mark(0);
    }

    public void reset() {
        try {
            this.byteStream.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentByte = this.markByte;
        this.currentBitIndex = this.markBitIndex;
    }

    public void close() {
        try {
            this.byteStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.currentByte = 0;
        this.currentBitIndex = -1;
    }

    public long skip(long numBits) {
        int skipped = 0;
        if (this.currentBitIndex >= 0) {
            skipped = this.currentBitIndex + 1;
            numBits -= (long)skipped;
            this.currentBitIndex = -1;
        }
        int left = (int)(numBits & 7L);
        long skipBytes = numBits / 8L;
        long bytes = this.skipBytes(skipBytes);
        if (bytes < 0L) {
            return skipped;
        }
        if (bytes < skipBytes) {
            left = 0;
        } else {
            try {
                this.readCurrentByte();
                this.currentBitIndex -= left;
            }
            catch (IllegalArgumentException ex) {
                left = 0;
            }
        }
        return bytes * 8L + (long)left + (long)skipped;
    }

    public long readLong(int numBits) {
        if (numBits < 0 || numBits > 64) {
            throw new IllegalArgumentException("bits must be in range 0 ... 64!");
        }
        long bits = 0L;
        if (this.currentBitIndex < 0 && (numBits & 7) == 0) {
            for (int i = 0; i < numBits; i += 8) {
                bits <<= 8;
                bits |= (long)this.readByte();
            }
        } else {
            for (int i = numBits - 1; i >= 0; --i) {
                boolean bit;
                if (this.currentBitIndex < 0) {
                    this.readCurrentByte();
                }
                boolean bl = bit = (this.currentByte >> this.currentBitIndex & 1) != 0;
                if (bit) {
                    bits |= 1L << i;
                }
                --this.currentBitIndex;
            }
        }
        return bits;
    }

    public int read(int numBits) {
        if (numBits < 0 || numBits > 32) {
            throw new IllegalArgumentException("bits must be in range 0 ... 32!");
        }
        int bits = 0;
        if (this.currentBitIndex < 0 && (numBits & 7) == 0) {
            for (int i = 0; i < numBits; i += 8) {
                bits <<= 8;
                bits |= this.readByte();
            }
        } else {
            for (int i = numBits - 1; i >= 0; --i) {
                boolean bit;
                if (this.currentBitIndex < 0) {
                    this.readCurrentByte();
                }
                boolean bl = bit = (this.currentByte >> this.currentBitIndex & 1) != 0;
                if (bit) {
                    bits |= 1 << i;
                }
                --this.currentBitIndex;
            }
        }
        return bits;
    }

    public byte[] readBytes(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count " + count + " must not be negative!");
        }
        if (count == 0) {
            return Bytes.EMPTY;
        }
        byte[] bytes = new byte[count];
        if (this.currentBitIndex >= 0) {
            for (int i = 0; i < count; ++i) {
                bytes[i] = (byte)this.read(8);
            }
        } else {
            this.readBytes(bytes, 0, bytes.length, true);
        }
        return bytes;
    }

    public byte readNextByte() {
        if (this.currentBitIndex >= 0) {
            return (byte)this.read(8);
        }
        return (byte)this.readByte();
    }

    public byte[] readVarBytes(int numBits) {
        int varLengthBits = DatagramWriter.getVarLengthBits(numBits);
        int nullLengthValue = DatagramWriter.getNullLengthValue(varLengthBits);
        int len = this.read(varLengthBits);
        if (len == nullLengthValue) {
            return null;
        }
        return this.readBytes(len);
    }

    public DatagramReader createRangeReader(int count) {
        return new DatagramReader(this.createRangeInputStream(count));
    }

    public ByteArrayInputStream createRangeInputStream(int count) {
        if (this.currentBitIndex > 0) {
            throw new IllegalStateException(this.currentBitIndex + " bits unread!");
        }
        if (this.byteStream instanceof RangeInputStream) {
            RangeInputStream range = (RangeInputStream)this.byteStream;
            return range.range(count);
        }
        byte[] range = new byte[count];
        this.readBytes(range, 0, count, true);
        return new RangeInputStream(range);
    }

    private long skipBytes(long skip) {
        try {
            return this.byteStream.skip(skip);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    private void readCurrentByte() {
        this.currentByte = (byte)this.readByte();
        this.currentBitIndex = 7;
    }

    private int readByte() {
        try {
            int val = this.byteStream.read();
            if (val < 0) {
                throw new IllegalArgumentException("requested byte exceeds available bytes!");
            }
            return val;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("request byte fails!", e);
        }
    }

    private int readBytes(byte[] buffer, int offset, int length, boolean full) {
        try {
            int available;
            int left = length;
            int read = 0;
            while (length > 0 && (available = this.byteStream.read(buffer, offset + read, left)) > 0) {
                read += available;
                left -= available;
                if (full) continue;
            }
            if (read < length) {
                throw new IllegalArgumentException("requested " + length + " bytes exceeds available " + read + " bytes.");
            }
            return read;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("request bytes fails!", e);
        }
    }

    protected static class RangeInputStream
    extends ByteArrayInputStream {
        protected RangeInputStream(byte[] buffer) {
            super(buffer);
        }

        protected RangeInputStream(byte[] buffer, int offset, int length) {
            super(buffer, offset, length);
        }

        private RangeInputStream range(int count) {
            int offset = this.pos;
            long available = this.skip(count);
            if (available < (long)count) {
                throw new IllegalArgumentException("requested " + count + " bytes exceeds available " + available + " bytes.");
            }
            return new RangeInputStream(this.buf, offset, count);
        }
    }
}

