/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.net.InetSocketAddress;
import java.security.Principal;
import org.eclipse.californium.elements.MapBasedEndpointContext;
import org.eclipse.californium.elements.TcpEndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public class TlsEndpointContext
extends TcpEndpointContext {
    public static final String KEY_SESSION_ID = "TLS_SESSION_ID";
    public static final String KEY_CIPHER = "TLS_CIPHER";

    public TlsEndpointContext(InetSocketAddress peerAddress, Principal peerIdentity, String connectionId, String sessionId, String cipher, long timestamp) {
        super(peerAddress, peerIdentity, new MapBasedEndpointContext.Attributes().add("CONNECTION_ID", connectionId).add("CONNECTION_TIMESTAMP", timestamp).add(KEY_SESSION_ID, sessionId).add(KEY_CIPHER, cipher));
    }

    public String getSessionId() {
        return this.getString(KEY_SESSION_ID);
    }

    public String getCipher() {
        return this.getString(KEY_CIPHER);
    }

    @Override
    public String toString() {
        return String.format("TLS(%s,%s,%s,%s)", this.getPeerAddressAsString(), StringUtil.trunc(this.getConnectionId(), 10), StringUtil.trunc(this.getSessionId(), 10), this.getCipher());
    }
}

