/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.StringUtil;

public final class KeyUri {
    private final String uri;
    private final InetSocketAddress address;
    private final int hash;

    public KeyUri(String requestUri, InetSocketAddress address) {
        if (requestUri == null) {
            throw new NullPointerException("URI must not be null");
        }
        if (address == null) {
            throw new NullPointerException("address must not be null");
        }
        this.uri = requestUri;
        this.address = address;
        this.hash = requestUri.hashCode() * 31 + address.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyUri other = (KeyUri)obj;
        if (!this.address.equals(other.address)) {
            return false;
        }
        return this.uri.equals(other.uri);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("KeyUri[");
        b.append(this.uri);
        b.append(", ").append(StringUtil.toDisplayString(this.address)).append("]");
        return b.toString();
    }

    private static String getUri(Request request) {
        if (request == null) {
            throw new NullPointerException("request must not be null");
        }
        return request.getScheme() + ":" + request.getOptions().getUriString();
    }

    public static KeyUri getKey(Exchange exchange, Request request) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        String uri = KeyUri.getUri(request);
        EndpointContext peer = exchange.isOfLocalOrigin() ? request.getDestinationContext() : request.getSourceContext();
        return new KeyUri(uri, peer.getPeerAddress());
    }

    public static KeyUri getKey(Exchange exchange, Response response) {
        if (exchange == null) {
            throw new NullPointerException("exchange must not be null");
        }
        String uri = KeyUri.getUri(exchange.getRequest());
        EndpointContext peer = exchange.isOfLocalOrigin() ? response.getSourceContext() : response.getDestinationContext();
        return new KeyUri(uri, peer.getPeerAddress());
    }
}

