/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.coap;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Message;
import org.eclipse.californium.core.coap.MessageObserver;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Endpoint;
import org.eclipse.californium.core.network.EndpointManager;
import org.eclipse.californium.elements.AddressEndpointContext;
import org.eclipse.californium.elements.EndpointContext;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.StringUtil;

public class Request
extends Message {
    private static final Pattern IP_PATTERN = Pattern.compile("(\\[[0-9a-fA-F:]+(%\\w+)?\\]|[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3})");
    private final CoAP.Code code;
    private boolean multicast;
    private Response response;
    private boolean ready;
    private String scheme;
    private boolean uri;
    private boolean proxyUri;
    private boolean proxyScheme;
    private Map<String, String> userContext;
    private volatile Throwable responseHandlingError;

    public Request(CoAP.Code code) {
        this(code, CoAP.Type.CON);
    }

    public Request(CoAP.Code code, CoAP.Type type) {
        super(type);
        this.code = code;
    }

    public CoAP.Code getCode() {
        return this.code;
    }

    @Override
    public int getRawCode() {
        return this.code == null ? 0 : this.code.value;
    }

    public String getScheme() {
        return this.scheme == null ? "coap" : this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public boolean isMulticast() {
        return this.multicast;
    }

    @Override
    public boolean isIntendedPayload() {
        return this.code != CoAP.Code.GET && this.code != CoAP.Code.DELETE;
    }

    @Override
    public Request setPayload(String payload) {
        super.setPayload(payload);
        return this;
    }

    @Override
    public Request setPayload(byte[] payload) {
        super.setPayload(payload);
        return this;
    }

    @Override
    public void assertPayloadMatchsBlocksize() {
        BlockOption block1 = this.getOptions().getBlock1();
        if (block1 != null) {
            block1.assertPayloadSize(this.getPayloadSize());
        }
    }

    public Request setProxyUri(String proxyUri) {
        if (this.uri) {
            throw new IllegalStateException("CoAP URI is set!");
        }
        if (this.proxyScheme) {
            throw new IllegalStateException("Proxy Scheme is set!");
        }
        this.getOptions().setProxyUri(proxyUri);
        this.proxyUri = true;
        return this;
    }

    public boolean hasProxyURI() {
        return this.proxyUri;
    }

    public Request setProxyScheme(String proxyScheme) {
        if (this.proxyUri) {
            throw new IllegalStateException("Proxy URI is set!");
        }
        this.getOptions().setProxyScheme(proxyScheme);
        this.proxyScheme = true;
        return this;
    }

    public Request setURI(String uri) {
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        try {
            String coapUri = uri;
            if (!uri.contains("://")) {
                coapUri = "coap://" + uri;
                LOGGER.warn("update your code to supply an RFC 7252 compliant URI including a scheme");
            }
            return this.setURI(new URI(coapUri));
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("invalid uri: " + uri, e);
        }
    }

    public Request setURI(URI uri) {
        this.checkURI(uri);
        String host = uri.getHost() == null ? "localhost" : uri.getHost();
        String uriScheme = uri.getScheme();
        boolean literalIp = IP_PATTERN.matcher(host).matches();
        try {
            InetSocketAddress destinationAdress;
            EndpointContext destinationContext = this.getDestinationContext();
            if (destinationContext == null) {
                int port = uri.getPort();
                InetAddress destAddress = InetAddress.getByName(host);
                String destHost = literalIp ? null : host;
                int destPort = port <= 0 ? CoAP.getDefaultPort(uriScheme) : port;
                destinationAdress = new InetSocketAddress(destAddress, destPort);
                destinationContext = new AddressEndpointContext(destinationAdress, destHost, null);
            } else {
                destinationAdress = destinationContext.getPeerAddress();
            }
            this.setOptionsInternal(uri, destinationAdress, literalIp);
            this.setDestinationContext(destinationContext);
            this.scheme = uriScheme.toLowerCase();
            this.uri = true;
            return this;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("cannot resolve host name: " + host);
        }
    }

    public Request setOptions(URI uri) {
        this.checkURI(uri);
        EndpointContext destinationContext = this.getDestinationContext();
        if (destinationContext == null) {
            throw new IllegalStateException("destination must be set ahead!");
        }
        this.setOptionsInternal(uri, destinationContext.getPeerAddress(), IP_PATTERN.matcher(uri.getHost()).matches());
        this.uri = true;
        return this;
    }

    private void checkURI(URI uri) {
        if (this.proxyUri) {
            throw new IllegalStateException("Proxy URI is set!");
        }
        if (uri == null) {
            throw new NullPointerException("URI must not be null");
        }
        if (!CoAP.isSupportedScheme(uri.getScheme())) {
            throw new IllegalArgumentException("URI scheme '" + uri.getScheme() + "' is not supported!");
        }
        if (uri.getFragment() != null) {
            throw new IllegalArgumentException("URI must not contain a fragment");
        }
    }

    private void setOptionsInternal(URI uri, InetSocketAddress destination, boolean literalIp) {
        int port;
        if (destination == null) {
            throw new NullPointerException("destination address must not be null!");
        }
        OptionSet options = this.getOptions();
        boolean explicitUriOption = options.hasExplicitUriOptions();
        String host = uri.getHost();
        if (host != null) {
            if (literalIp) {
                try {
                    InetAddress hostAddress = InetAddress.getByName(host);
                    InetAddress destinationAddress = destination.getAddress();
                    if (hostAddress.equals(destinationAddress)) {
                        host = null;
                    }
                }
                catch (UnknownHostException e) {
                    LOGGER.warn("could not parse IP address of URI despite successful IP address pattern matching");
                }
            } else if (!StringUtil.isValidHostName(host)) {
                throw new IllegalArgumentException("URI's hostname '" + host + "' is invalid!'");
            }
            if (host != null) {
                options.setUriHost(host.toLowerCase());
            }
        }
        if (host == null) {
            options.removeUriHost();
        }
        if ((port = uri.getPort()) <= 0) {
            port = CoAP.getDefaultPort(uri.getScheme());
        }
        if (port == destination.getPort()) {
            port = -1;
        }
        if (0 < port) {
            options.setUriPort(port);
        } else {
            options.removeUriPort();
        }
        String path = uri.getPath();
        if (path != null && path.length() > 1) {
            options.setUriPath(path);
        } else if (!explicitUriOption) {
            options.clearUriPath();
        }
        String query = uri.getQuery();
        if (query != null) {
            options.setUriQuery(query);
        } else if (!explicitUriOption) {
            options.clearUriQuery();
        }
        if (!explicitUriOption) {
            options.resetExplicitUriOptions();
        }
    }

    public void setUriIsApplied() {
        this.uri = true;
    }

    public boolean hasURI() {
        return this.uri;
    }

    public String getURI() {
        OptionSet options = this.getOptions();
        String host = options.getUriHost();
        Integer port = options.getUriPort();
        if (host == null) {
            host = this.getDestinationContext() != null ? this.getDestinationContext().getPeerAddress().getAddress().getHostAddress() : "localhost";
        }
        if (port == null) {
            port = this.getDestinationContext() != null ? Integer.valueOf(this.getDestinationContext().getPeerAddress().getPort()) : Integer.valueOf(-1);
        }
        if (port > 0) {
            if (CoAP.isSupportedScheme(this.getScheme()) && CoAP.getDefaultPort(this.getScheme()) == port) {
                port = -1;
            }
        } else {
            port = -1;
        }
        String path = "/" + options.getUriPathString();
        String query = options.getURIQueryCount() > 0 ? options.getUriQueryString() : null;
        try {
            URI uri = new URI(this.getScheme(), null, host, port, path, query, null);
            return uri.toASCIIString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("cannot create URI from request", e);
        }
    }

    @Override
    public boolean hasBlock(BlockOption block) {
        return this.hasBlock(block, this.getOptions().getBlock1());
    }

    @Override
    public Request setDestinationContext(EndpointContext peerContext) {
        super.setRequestDestinationContext(peerContext);
        this.multicast = peerContext != null && !peerContext.getPeerAddress().isUnresolved() && NetworkInterfacesUtil.isMultiAddress(peerContext.getPeerAddress().getAddress());
        return this;
    }

    public void setLocalAddress(InetSocketAddress local, boolean multicast) {
        super.setLocalAddress(local);
        this.multicast = multicast;
    }

    public Request send() {
        this.send(EndpointManager.getEndpointManager().getDefaultEndpoint(this.getScheme()));
        return this;
    }

    public Request send(Endpoint endpoint) {
        this.validateBeforeSending();
        endpoint.sendRequest(this);
        return this;
    }

    private void validateBeforeSending() {
        if (this.getDestinationContext() == null) {
            throw new IllegalStateException("Destination is null");
        }
        if (this.getDestinationContext().getPeerAddress().getAddress() == null) {
            throw new IllegalStateException("Destination address is null");
        }
        if (this.getDestinationContext().getPeerAddress().getPort() == 0) {
            throw new IllegalStateException("Destination port is 0");
        }
    }

    public final Request setObserve() {
        if (!CoAP.isObservable(this.code)) {
            throw new IllegalStateException("observe option can only be set on a GET or FETCH request");
        }
        this.getOptions().setObserve(0);
        return this;
    }

    public final boolean isObserve() {
        return this.isObserveOption(0);
    }

    public final Request setObserveCancel() {
        if (!CoAP.isObservable(this.code)) {
            throw new IllegalStateException("observe option can only be set on a GET or FETCH request");
        }
        this.getOptions().setObserve(1);
        return this;
    }

    public final boolean isObserveCancel() {
        return this.isObserveOption(1);
    }

    private final boolean isObserveOption(int observe) {
        Integer optionObserver = this.getOptions().getObserve();
        return optionObserver != null && optionObserver == observe;
    }

    public synchronized Response getResponse() {
        return this.response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(Response response) {
        Request request = this;
        synchronized (request) {
            this.response = response;
            this.notifyAll();
        }
        for (MessageObserver handler : this.getMessageObservers()) {
            handler.onResponse(response);
        }
    }

    public Response waitForResponse() throws InterruptedException {
        return this.waitForResponse(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response waitForResponse(long timeout) throws InterruptedException {
        long expiresNano = ClockUtil.nanoRealtime() + TimeUnit.MILLISECONDS.toNanos(timeout);
        long leftTimeout = timeout;
        Request request = this;
        synchronized (request) {
            while (!this.ready && this.response == null) {
                this.wait(leftTimeout);
                if (timeout <= 0L) continue;
                long leftNanos = expiresNano - ClockUtil.nanoRealtime();
                if (leftNanos <= 0L) break;
                leftTimeout = TimeUnit.NANOSECONDS.toMillis(leftNanos) + 1L;
            }
            Response r = this.response;
            this.response = null;
            return r;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimedOut(boolean timedOut) {
        super.setTimedOut(timedOut);
        if (timedOut) {
            Request request = this;
            synchronized (request) {
                this.ready = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCanceled(boolean canceled) {
        super.setCanceled(canceled);
        if (canceled) {
            Request request = this;
            synchronized (request) {
                this.ready = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRejected(boolean rejected) {
        super.setRejected(rejected);
        if (rejected) {
            Request request = this;
            synchronized (request) {
                this.ready = true;
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSendError(Throwable sendError) {
        super.setSendError(sendError);
        if (sendError != null) {
            Request request = this;
            synchronized (request) {
                this.ready = true;
                this.notifyAll();
            }
        }
    }

    public Throwable getOnResponseError() {
        return this.responseHandlingError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOnResponseError(Throwable cause) {
        this.responseHandlingError = cause;
        if (this.responseHandlingError != null) {
            for (MessageObserver handler : this.getMessageObservers()) {
                handler.onResponseHandlingError(this.responseHandlingError);
            }
            Request request = this;
            synchronized (request) {
                this.ready = true;
                this.notifyAll();
            }
        }
    }

    public Map<String, String> getUserContext() {
        return this.userContext;
    }

    public Request setUserContext(Map<String, String> userContext) {
        this.userContext = userContext == null || userContext.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(new HashMap<String, String>(userContext));
        return this;
    }

    public String toString() {
        CoAP.Code code = this.getCode();
        return this.toTracingString(code == null ? "PING" : code.toString());
    }

    public static Request newGet() {
        return new Request(CoAP.Code.GET);
    }

    public static Request newFetch() {
        return new Request(CoAP.Code.FETCH);
    }

    public static Request newPost() {
        return new Request(CoAP.Code.POST);
    }

    public static Request newPut() {
        return new Request(CoAP.Code.PUT);
    }

    public static Request newPatch() {
        return new Request(CoAP.Code.PATCH);
    }

    public static Request newIPatch() {
        return new Request(CoAP.Code.IPATCH);
    }

    public static Request newDelete() {
        return new Request(CoAP.Code.DELETE);
    }
}

