/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.numbers.EInteger;

final class FastInteger2 {
    private int smallValue;
    private MutableNumber mnum;
    private EInteger largeValue;
    private int integerMode;

    FastInteger2(int value) {
        this.smallValue = value;
    }

    FastInteger2(EInteger largeValue) {
        this.integerMode = 2;
        this.largeValue = largeValue;
    }

    int AsInt32() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue;
            }
            case 1: {
                return this.mnum.ToInt32();
            }
            case 2: {
                return this.largeValue.ToInt32Checked();
            }
        }
        throw new IllegalStateException();
    }

    static EInteger WordsToEInteger(int[] words) {
        int wordCount = words.length;
        if (wordCount == 1 && words[0] >> 31 == 0) {
            return EInteger.FromInt64(words[0]);
        }
        byte[] bytes = new byte[wordCount * 4 + 1];
        for (int i = 0; i < wordCount; ++i) {
            bytes[i * 4 + 0] = (byte)(words[i] & 0xFF);
            bytes[i * 4 + 1] = (byte)(words[i] >> 8 & 0xFF);
            bytes[i * 4 + 2] = (byte)(words[i] >> 16 & 0xFF);
            bytes[i * 4 + 3] = (byte)(words[i] >> 24 & 0xFF);
        }
        bytes[bytes.length - 1] = 0;
        return EInteger.FromBytes(bytes, true);
    }

    FastInteger2 SetInt(int val) {
        this.smallValue = val;
        this.integerMode = 0;
        return this;
    }

    FastInteger2 Multiply(int val) {
        if (val == 0) {
            this.smallValue = 0;
            this.integerMode = 0;
        } else {
            switch (this.integerMode) {
                case 0: {
                    boolean bpos;
                    boolean apos = (long)this.smallValue > 0L;
                    boolean bl = bpos = (long)val > 0L;
                    if (apos && (!bpos && Integer.MIN_VALUE / this.smallValue > val || bpos && this.smallValue > Integer.MAX_VALUE / val) || !apos && (!bpos && (long)this.smallValue != 0L && Integer.MAX_VALUE / this.smallValue > val || bpos && this.smallValue < Integer.MIN_VALUE / val)) {
                        if (apos && bpos) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Multiply(val);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt32(this.smallValue);
                        this.largeValue = this.largeValue.Multiply(EInteger.FromInt32(val));
                        break;
                    }
                    this.smallValue *= val;
                    break;
                }
                case 1: {
                    if (val < 0) {
                        this.integerMode = 2;
                        this.largeValue = this.mnum.ToEInteger();
                        this.largeValue = this.largeValue.Multiply(EInteger.FromInt32(val));
                        break;
                    }
                    this.mnum.Multiply(val);
                    break;
                }
                case 2: {
                    this.largeValue = this.largeValue.Multiply(EInteger.FromInt32(val));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        return this;
    }

    FastInteger2 Subtract(FastInteger2 val) {
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    int vsv = val.smallValue;
                    if (vsv < 0 && Integer.MAX_VALUE + vsv < this.smallValue || vsv > 0 && Integer.MIN_VALUE + vsv > this.smallValue) {
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt32(this.smallValue);
                        this.largeValue = this.largeValue.Subtract(EInteger.FromInt32(vsv));
                        break;
                    }
                    this.smallValue -= vsv;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt32(this.smallValue);
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 1) {
                    this.mnum.Subtract(val.mnum);
                    break;
                }
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.SubtractInt(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            case 2: {
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Subtract(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger2 SubtractInt(int val) {
        if (val == Integer.MIN_VALUE) {
            return this.AddInt(Integer.MAX_VALUE).AddInt(1);
        }
        if (this.integerMode == 0) {
            if (val < 0 && Integer.MAX_VALUE + val < this.smallValue || val > 0 && Integer.MIN_VALUE + val > this.smallValue) {
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt32(this.smallValue);
                this.largeValue = this.largeValue.Subtract(EInteger.FromInt32(val));
            } else {
                this.smallValue -= val;
            }
            return this;
        }
        return this.AddInt(-val);
    }

    FastInteger2 Add(FastInteger2 val) {
        switch (this.integerMode) {
            case 0: {
                if (val.integerMode == 0) {
                    if (this.smallValue < 0 && val.smallValue < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val.smallValue > Integer.MAX_VALUE - this.smallValue) {
                        if (val.smallValue >= 0) {
                            this.integerMode = 1;
                            this.mnum = new MutableNumber(this.smallValue);
                            this.mnum.Add(val.smallValue);
                            break;
                        }
                        this.integerMode = 2;
                        this.largeValue = EInteger.FromInt32(this.smallValue);
                        this.largeValue = this.largeValue.Add(EInteger.FromInt64(val.smallValue));
                        break;
                    }
                    this.smallValue += val.smallValue;
                    break;
                }
                this.integerMode = 2;
                this.largeValue = EInteger.FromInt32(this.smallValue);
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 1: {
                if (val.integerMode == 0 && val.smallValue >= 0) {
                    this.mnum.Add(val.smallValue);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 2: {
                EInteger valValue = val.AsEInteger();
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    FastInteger2 AddInt(int val) {
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue < 0 && val < Integer.MIN_VALUE - this.smallValue || this.smallValue > 0 && val > Integer.MAX_VALUE - this.smallValue) {
                    if (val >= 0) {
                        this.integerMode = 1;
                        this.mnum = new MutableNumber(this.smallValue);
                        this.mnum.Add(val);
                        break;
                    }
                    this.integerMode = 2;
                    this.largeValue = EInteger.FromInt32(this.smallValue);
                    this.largeValue = this.largeValue.Add(EInteger.FromInt32(val));
                    break;
                }
                this.smallValue += val;
                break;
            }
            case 1: {
                if (val >= 0) {
                    this.mnum.Add(val);
                    break;
                }
                this.integerMode = 2;
                this.largeValue = this.mnum.ToEInteger();
                EInteger valValue = EInteger.FromInt32(val);
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            case 2: {
                EInteger valValue = EInteger.FromInt32(val);
                this.largeValue = this.largeValue.Add(valValue);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return this;
    }

    boolean CanFitInInt32() {
        switch (this.integerMode) {
            case 0: {
                return true;
            }
            case 1: {
                return this.mnum.CanFitInInt32();
            }
            case 2: {
                return this.largeValue.CanFitInInt32();
            }
        }
        throw new IllegalStateException();
    }

    final int signum() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0 ? 0 : (this.smallValue < 0 ? -1 : 1);
            }
            case 1: {
                return this.mnum.signum();
            }
            case 2: {
                return this.largeValue.signum();
            }
        }
        return 0;
    }

    EInteger AsEInteger() {
        switch (this.integerMode) {
            case 0: {
                return EInteger.FromInt32(this.smallValue);
            }
            case 1: {
                return this.mnum.ToEInteger();
            }
            case 2: {
                return this.largeValue;
            }
        }
        throw new IllegalStateException();
    }

    private static final class MutableNumber {
        private int[] data;
        private int wordCount;

        MutableNumber(int val) {
            if (val < 0) {
                throw new IllegalArgumentException("val(" + val + ") is less than 0 ");
            }
            this.data = new int[4];
            this.wordCount = val == 0 ? 0 : 1;
            this.data[0] = val;
        }

        EInteger ToEInteger() {
            if (this.wordCount == 1 && this.data[0] >> 31 == 0) {
                return EInteger.FromInt64(this.data[0]);
            }
            byte[] bytes = new byte[this.wordCount * 4 + 1];
            for (int i = 0; i < this.wordCount; ++i) {
                bytes[i * 4] = (byte)(this.data[i] & 0xFF);
                bytes[i * 4 + 1] = (byte)(this.data[i] >> 8 & 0xFF);
                bytes[i * 4 + 2] = (byte)(this.data[i] >> 16 & 0xFF);
                bytes[i * 4 + 3] = (byte)(this.data[i] >> 24 & 0xFF);
            }
            bytes[bytes.length - 1] = 0;
            return EInteger.FromBytes(bytes, true);
        }

        int[] GetLastWordsInternal(int numWords32Bit) {
            int[] ret = new int[numWords32Bit];
            System.arraycopy(this.data, 0, ret, 0, Math.min(numWords32Bit, this.wordCount));
            return ret;
        }

        boolean CanFitInInt32() {
            return this.wordCount == 0 || this.wordCount == 1 && this.data[0] >> 31 == 0;
        }

        int ToInt32() {
            return this.wordCount == 0 ? 0 : this.data[0];
        }

        MutableNumber Multiply(int multiplicand) {
            if (multiplicand < 0) {
                throw new IllegalArgumentException("multiplicand(" + multiplicand + ") is less than 0 ");
            }
            if (multiplicand != 0) {
                int result3;
                int result2;
                int result0;
                int result1;
                int y0;
                int x1;
                int x0;
                int i;
                int carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if (multiplicand < 65536) {
                    for (i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * y0;
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        result2 = 0;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | result3 << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                } else {
                    for (i = 0; i < this.wordCount; ++i) {
                        x1 = x0 = this.data[i];
                        int y1 = y0 = multiplicand;
                        x1 = x1 >> 16 & 0xFFFF;
                        y1 = y1 >> 16 & 0xFFFF;
                        int temp = (x0 &= 0xFFFF) * (y0 &= 0xFFFF);
                        result1 = temp >> 16 & 0xFFFF;
                        result0 = temp & 0xFFFF;
                        temp = x0 * y1;
                        result2 = temp >> 16 & 0xFFFF;
                        result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF;
                        result1 &= 0xFFFF;
                        temp = x1 * y0;
                        result2 += temp >> 16 & 0xFFFF;
                        result3 = (result2 += (result1 += temp & 0xFFFF) >> 16 & 0xFFFF) >> 16 & 0xFFFF;
                        result2 &= 0xFFFF;
                        temp = x1 * y1;
                        result3 += temp >> 16 & 0xFFFF;
                        x0 = result0 | (result1 &= 0xFFFF) << 16;
                        x1 = (result2 &= 0xFFFF) | (result3 += (result2 += temp & 0xFFFF) >> 16 & 0xFFFF) << 16;
                        int x2 = x0 + carry;
                        if (x2 >> 31 == x0 >> 31 ? (x2 & Integer.MAX_VALUE) < (x0 & Integer.MAX_VALUE) : x2 >> 31 == 0) {
                            // empty if block
                        }
                        this.data[i] = x2;
                        carry = ++x1;
                    }
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        int[] newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            } else {
                if (this.data.length > 0) {
                    this.data[0] = 0;
                }
                this.wordCount = 0;
            }
            return this;
        }

        final int signum() {
            return this.wordCount == 0 ? 0 : 1;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber SubtractInt(int other) {
            block8: {
                if (other < 0) {
                    throw new IllegalArgumentException("other(" + other + ") is less than 0 ");
                }
                if (other == 0) break block8;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                if ((a = this.data[0]) >> 31 != (u = a - other) >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                if (a == u && other != 0) lbl-1000:
                // 2 sources

                {
                    v0 = 1;
                } else {
                    v0 = 0;
                }
                borrow = v0;
                this.data[0] = u;
                if (borrow != 0) {
                    for (i = 1; i < this.wordCount; ++i) {
                        u = this.data[i] - borrow;
                        borrow = (this.data[i] >> 31 == u >> 31 ? (this.data[i] & 0x7FFFFFFF) < (u & 0x7FFFFFFF) : this.data[i] >> 31 == 0) ? 1 : 0;
                        this.data[i] = u;
                    }
                }
                while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                    --this.wordCount;
                }
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber Subtract(MutableNumber other) {
            block8: {
                v0 = neededSize = this.wordCount > other.wordCount ? this.wordCount : other.wordCount;
                if (this.data.length < neededSize) {
                    newdata = new int[neededSize + 20];
                    System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                    this.data = newdata;
                }
                neededSize = this.wordCount < other.wordCount ? this.wordCount : other.wordCount;
                u = 0;
                borrow = 0;
                for (i = 0; i < neededSize; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v1 = 1;
                    } else {
                        v1 = 0;
                    }
                    borrow = v1;
                    this.data[i] = u;
                }
                if (borrow == 0) break block8;
                for (i = neededSize; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a - other.data[i] - borrow;
                    if (a >> 31 != u >> 31 ? a >> 31 == 0 : (a & 0x7FFFFFFF) < (u & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (a == u && other.data[i] != 0) lbl-1000:
                    // 2 sources

                    {
                        v2 = 1;
                    } else {
                        v2 = 0;
                    }
                    borrow = v2;
                    this.data[i] = u;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }

        /*
         * Unable to fully structure code
         */
        MutableNumber Add(int augend) {
            block10: {
                if (augend < 0) {
                    throw new IllegalArgumentException("augend(" + augend + ") is less than 0 ");
                }
                if (augend == 0) break block10;
                carry = 0;
                if (this.wordCount == 0) {
                    if (this.data.length == 0) {
                        this.data = new int[4];
                    }
                    this.data[0] = 0;
                    this.wordCount = 1;
                }
                for (i = 0; i < this.wordCount; ++i) {
                    a = this.data[i];
                    u = a + augend + carry;
                    if (u >> 31 != a >> 31 ? u >> 31 == 0 : (u & 0x7FFFFFFF) < (a & 0x7FFFFFFF)) ** GOTO lbl-1000
                    if (u == a && augend != 0) lbl-1000:
                    // 2 sources

                    {
                        v0 = 1;
                    } else {
                        v0 = 0;
                    }
                    carry = v0;
                    this.data[i] = u;
                    if (carry == 0) {
                        return this;
                    }
                    augend = 0;
                }
                if (carry != 0) {
                    if (this.wordCount >= this.data.length) {
                        newdata = new int[this.wordCount + 20];
                        System.arraycopy(this.data, 0, newdata, 0, this.data.length);
                        this.data = newdata;
                    }
                    this.data[this.wordCount] = carry;
                    ++this.wordCount;
                }
            }
            while (this.wordCount != 0 && this.data[this.wordCount - 1] == 0) {
                --this.wordCount;
            }
            return this;
        }
    }
}

