/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.CompressionMethod;
import org.eclipse.californium.scandium.dtls.DtlsAeadConnectionState;
import org.eclipse.californium.scandium.dtls.DtlsBlockConnectionState;
import org.eclipse.californium.scandium.dtls.Record;
import org.eclipse.californium.scandium.dtls.cipher.CipherSuite;
import org.eclipse.californium.scandium.util.SecretIvParameterSpec;

public abstract class DTLSConnectionState
implements Destroyable {
    public static final DTLSConnectionState NULL = new DTLSConnectionState(CipherSuite.TLS_NULL_WITH_NULL_NULL, CompressionMethod.NULL){

        @Override
        public byte[] encrypt(Record record, byte[] fragment) {
            return fragment;
        }

        @Override
        public byte[] decrypt(Record record, byte[] fragment) {
            return fragment;
        }

        public final String toString() {
            StringBuilder b = new StringBuilder("DtlsNullConnectionState:");
            b.append(StringUtil.lineSeparator()).append("\tCipher suite: ").append((Object)this.cipherSuite);
            b.append(StringUtil.lineSeparator()).append("\tCompression method: ").append((Object)this.compressionMethod);
            return b.toString();
        }

        @Override
        public void destroy() throws DestroyFailedException {
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }
    };
    protected final CipherSuite cipherSuite;
    protected final CompressionMethod compressionMethod;

    public static DTLSConnectionState create(CipherSuite cipherSuite, CompressionMethod compressionMethod, SecretKey encryptionKey, SecretIvParameterSpec iv, SecretKey macKey) {
        switch (cipherSuite.getCipherType()) {
            case NULL: {
                return NULL;
            }
            case BLOCK: {
                return new DtlsBlockConnectionState(cipherSuite, compressionMethod, encryptionKey, macKey);
            }
            case AEAD: {
                return new DtlsAeadConnectionState(cipherSuite, compressionMethod, encryptionKey, iv);
            }
        }
        throw new IllegalArgumentException("cipher type " + (Object)((Object)cipherSuite.getCipherType()) + " not supported!");
    }

    DTLSConnectionState(CipherSuite cipherSuite, CompressionMethod compressionMethod) {
        if (cipherSuite == null) {
            throw new NullPointerException("Cipher suite must not be null");
        }
        if (compressionMethod == null) {
            throw new NullPointerException("Compression method must not be null");
        }
        this.cipherSuite = cipherSuite;
        this.compressionMethod = compressionMethod;
    }

    CipherSuite getCipherSuite() {
        return this.cipherSuite;
    }

    public boolean hasValidCipherSuite() {
        return !CipherSuite.TLS_NULL_WITH_NULL_NULL.equals((Object)this.cipherSuite);
    }

    public abstract byte[] encrypt(Record var1, byte[] var2) throws GeneralSecurityException;

    public abstract byte[] decrypt(Record var1, byte[] var2) throws GeneralSecurityException;

    CompressionMethod getCompressionMethod() {
        return this.compressionMethod;
    }

    int getMacLength() {
        return this.cipherSuite.getMacLength();
    }

    int getMacKeyLength() {
        return this.cipherSuite.getMacKeyLength();
    }

    int getRecordIvLength() {
        return this.cipherSuite.getRecordIvLength();
    }
}

