/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.pskstore;

import java.util.Arrays;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.crypto.SecretKey;
import org.eclipse.californium.elements.util.DaemonThreadFactory;
import org.eclipse.californium.elements.util.ExecutorsUtil;
import org.eclipse.californium.elements.util.NamedThreadFactory;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.PskSecretResultHandler;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedInMemoryPskStore;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncInMemoryPskStore
extends AdvancedInMemoryPskStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(AsyncInMemoryPskStore.class);
    private static final NamedThreadFactory THREAD_FACTORY = new DaemonThreadFactory("AsyncPskStoreTimer#");
    private volatile int delayMillis = 1;
    private volatile boolean generateMasterSecret;
    private final ScheduledExecutorService executorService = ExecutorsUtil.newSingleThreadScheduledExecutor(THREAD_FACTORY);
    private PskSecretResultHandler resultHandler;

    public AsyncInMemoryPskStore(PskStore pskStore) {
        super(pskStore);
    }

    public AsyncInMemoryPskStore setSecretMode(boolean enableGenerateMasterSecret) {
        this.generateMasterSecret = this.generateMasterSecret;
        return this;
    }

    public AsyncInMemoryPskStore setDelay(int delayMillis) {
        this.delayMillis = delayMillis;
        if (delayMillis > 0) {
            LOGGER.info("Asynchronous delayed PSK store {}ms.", (Object)delayMillis);
        } else if (delayMillis < 0) {
            LOGGER.info("Synchronous delayed PSK store {}ms.", (Object)(-delayMillis));
        } else {
            LOGGER.info("Synchronous PSK store.");
        }
        return this;
    }

    public void shutdown() {
        this.executorService.shutdown();
    }

    @Override
    public PskSecretResult requestPskSecretResult(final ConnectionId cid, final ServerNames serverNames, final PskPublicInformation identity, final String hmacAlgorithm, SecretKey otherSecret, byte[] seed) {
        if (this.delayMillis <= 0) {
            if (this.delayMillis < 0) {
                try {
                    Thread.sleep(-this.delayMillis);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return this.getPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed);
        }
        final byte[] randomSeed = Arrays.copyOf(seed, seed.length);
        final SecretKey other = SecretUtil.create(otherSecret);
        this.executorService.schedule(new Runnable(){

            @Override
            public void run() {
                AsyncInMemoryPskStore.this.getSecretAsynchronous(cid, serverNames, identity, hmacAlgorithm, other, randomSeed);
            }
        }, (long)this.delayMillis, TimeUnit.MILLISECONDS);
        return null;
    }

    private void getSecretAsynchronous(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed) {
        PskSecretResult result = this.getPskSecretResult(cid, serverNames, identity, hmacAlgorithm, otherSecret, seed);
        this.resultHandler.apply(result);
    }

    private PskSecretResult getPskSecretResult(ConnectionId cid, ServerNames serverNames, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed) {
        SecretKey secret;
        SecretKey secretKey = secret = serverNames != null ? this.pskStore.getKey(serverNames, identity) : this.pskStore.getKey(identity);
        if (this.generateMasterSecret && secret != null) {
            SecretKey masterSecret = this.generateMasterSecret(hmacAlgorithm, secret, otherSecret, seed);
            SecretUtil.destroy(secret);
            secret = masterSecret;
        }
        return new PskSecretResult(cid, identity, secret);
    }

    @Override
    public void setResultHandler(PskSecretResultHandler resultHandler) {
        this.resultHandler = resultHandler;
    }
}

