/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.EmptyMessage;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.ExchangeCompleteException;
import org.eclipse.californium.core.network.Outbox;
import org.eclipse.californium.core.network.stack.AbstractLayer;
import org.eclipse.californium.core.network.stack.CoapStack;
import org.eclipse.californium.core.network.stack.Layer;
import org.eclipse.californium.core.observe.ObservationStoreException;
import org.eclipse.californium.core.server.MessageDeliverer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCoapStack
implements CoapStack {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseCoapStack.class);
    private List<Layer> layers;
    private final Outbox outbox;
    private final StackTopAdapter top = new StackTopAdapter();
    private final StackBottomAdapter bottom = new StackBottomAdapter();
    private MessageDeliverer deliverer;

    protected BaseCoapStack(Outbox outbox) {
        this.outbox = outbox;
    }

    protected final void setLayers(Layer[] specificLayers) {
        Layer.TopDownBuilder builder = new Layer.TopDownBuilder().add(this.top);
        for (Layer layer : specificLayers) {
            builder.add(layer);
        }
        builder.add(this.bottom);
        this.layers = builder.create();
    }

    @Override
    public void sendRequest(Exchange exchange, Request request) {
        try {
            this.top.sendRequest(exchange, request);
        }
        catch (ObservationStoreException ex) {
            LOGGER.debug("error send request {} - {}", (Object)request, (Object)ex.getMessage());
            request.setSendError(ex);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("error send request {}", (Object)request, (Object)ex);
            request.setSendError(ex);
        }
    }

    @Override
    public void sendResponse(Exchange exchange, Response response) {
        boolean retransmit = exchange.getRequest().getOptions().hasObserve();
        try {
            if (retransmit) {
                exchange.retransmitResponse();
            }
            this.top.sendResponse(exchange, response);
        }
        catch (ExchangeCompleteException ex) {
            LOGGER.warn("error send response {}", (Object)response, (Object)ex);
            response.setSendError(ex);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("error send response {}", (Object)response, (Object)ex);
            if (!retransmit) {
                exchange.sendReject();
            }
            response.setSendError(ex);
        }
    }

    @Override
    public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
        try {
            this.top.sendEmptyMessage(exchange, message);
        }
        catch (RuntimeException ex) {
            LOGGER.warn("error send empty message {}", (Object)message, (Object)ex);
            message.setSendError(ex);
        }
    }

    @Override
    public void receiveRequest(Exchange exchange, Request request) {
        this.bottom.receiveRequest(exchange, request);
    }

    @Override
    public void receiveResponse(Exchange exchange, Response response) {
        this.bottom.receiveResponse(exchange, response);
    }

    @Override
    public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        this.bottom.receiveEmptyMessage(exchange, message);
    }

    @Override
    public final void setExecutors(ScheduledExecutorService mainExecutor, ScheduledExecutorService secondaryExecutor) {
        for (Layer layer : this.layers) {
            layer.setExecutors(mainExecutor, secondaryExecutor);
        }
    }

    @Override
    public final void setDeliverer(MessageDeliverer deliverer) {
        this.deliverer = deliverer;
    }

    @Override
    public final boolean hasDeliverer() {
        return this.deliverer != null;
    }

    @Override
    public void start() {
        for (Layer layer : this.layers) {
            layer.start();
        }
    }

    @Override
    public void destroy() {
        for (Layer layer : this.layers) {
            layer.destroy();
        }
    }

    private class StackBottomAdapter
    extends AbstractLayer {
        private StackBottomAdapter() {
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            BaseCoapStack.this.outbox.sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            BaseCoapStack.this.outbox.sendResponse(exchange, response);
            BlockOption block2 = response.getOptions().getBlock2();
            if (block2 == null || !block2.isM()) {
                response.onComplete();
            }
        }

        @Override
        public void sendEmptyMessage(Exchange exchange, EmptyMessage message) {
            BaseCoapStack.this.outbox.sendEmptyMessage(exchange, message);
        }
    }

    private class StackTopAdapter
    extends AbstractLayer {
        private StackTopAdapter() {
        }

        @Override
        public void sendRequest(Exchange exchange, Request request) {
            exchange.setRequest(request);
            this.lower().sendRequest(exchange, request);
        }

        @Override
        public void sendResponse(Exchange exchange, Response response) {
            exchange.setResponse(response);
            this.lower().sendResponse(exchange, response);
        }

        @Override
        public void receiveRequest(Exchange exchange, Request request) {
            if (exchange.getRequest() == null) {
                exchange.setRequest(request);
            }
            if (BaseCoapStack.this.hasDeliverer()) {
                BaseCoapStack.this.deliverer.deliverRequest(exchange);
            } else {
                LOGGER.error("Top of CoAP stack has no deliverer to deliver request");
            }
        }

        @Override
        public void receiveResponse(Exchange exchange, Response response) {
            if (BaseCoapStack.this.hasDeliverer()) {
                BaseCoapStack.this.deliverer.deliverResponse(exchange, response);
            } else {
                LOGGER.error("Top of CoAP stack has no deliverer to deliver response");
            }
        }

        @Override
        public void receiveEmptyMessage(Exchange exchange, EmptyMessage message) {
        }
    }
}

