/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network.stack;

import org.eclipse.californium.core.coap.BlockOption;
import org.eclipse.californium.core.coap.OptionSet;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.network.stack.BlockwiseStatus;

public final class Block1BlockwiseStatus
extends BlockwiseStatus {
    private Request request;

    private Block1BlockwiseStatus(int bufferSize, int contentFormat) {
        super(bufferSize, contentFormat);
    }

    public static Block1BlockwiseStatus forOutboundRequest(Exchange exchange, Request request, int preferredBlockSize) {
        Block1BlockwiseStatus status = new Block1BlockwiseStatus(0, request.getOptions().getContentFormat());
        status.request = request;
        status.exchange = exchange;
        status.setCurrentSzx(BlockOption.size2Szx(preferredBlockSize));
        return status;
    }

    public static Block1BlockwiseStatus forInboundRequest(Exchange exchange, Request block, int maxBodySize) {
        int contentFormat = block.getOptions().getContentFormat();
        int bufferSize = maxBodySize;
        if (block.getOptions().hasSize1()) {
            bufferSize = block.getOptions().getSize1();
        }
        Block1BlockwiseStatus status = new Block1BlockwiseStatus(bufferSize, contentFormat);
        status.exchange = exchange;
        status.setFirst(block);
        return status;
    }

    public synchronized Request getNextRequestBlock(int num, int szx) {
        if (this.request == null) {
            throw new IllegalStateException("no request body");
        }
        this.setCurrentNum(num);
        this.setCurrentSzx(szx);
        return this.getNextRequestBlock();
    }

    public synchronized Request getNextRequestBlock() {
        if (this.request == null) {
            throw new IllegalStateException("no request body");
        }
        int num = this.getCurrentNum();
        int szx = this.getCurrentSzx();
        Request block = new Request(this.request.getCode());
        block.setType(this.request.getType());
        block.setOptions(new OptionSet(this.request.getOptions()));
        block.addMessageObservers(this.request.getMessageObservers());
        if (num == 0) {
            block.getOptions().setSize1(this.request.getPayloadSize());
        }
        if (this.request.isUnintendedPayload()) {
            block.setUnintendedPayload();
        }
        int currentSize = this.getCurrentSize();
        int from = num * currentSize;
        int to = Math.min((num + 1) * currentSize, this.request.getPayloadSize());
        int length = to - from;
        if (length > 0) {
            byte[] blockPayload = new byte[length];
            System.arraycopy(this.request.getPayload(), from, blockPayload, 0, length);
            block.setPayload(blockPayload);
        }
        boolean m = to < this.request.getPayloadSize();
        block.getOptions().setBlock1(szx, m, num);
        this.setComplete(!m);
        return block;
    }

    public void cancelRequest() {
        if (this.request != null) {
            this.request.cancel();
        }
    }

    public boolean hasMatchingToken(Response response) {
        return this.request != null && response.getToken().equals(this.request.getToken());
    }
}

