/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.cbor;

import com.upokecenter.cbor.CBORObject;
import com.upokecenter.cbor.FastInteger2;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EInteger;

public final class CBORDataUtilities {
    private static final int MaxSafeInt = 0xCCCCCCB;

    private CBORDataUtilities() {
    }

    public static CBORObject ParseJSONNumber(String str) {
        return CBORDataUtilities.ParseJSONNumber(str, false, false);
    }

    public static CBORObject ParseJSONNumber(String str, boolean integersOnly, boolean positiveOnly) {
        return CBORDataUtilities.ParseJSONNumber(str, integersOnly, positiveOnly, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CBORObject ParseJSONNumber(String str, boolean integersOnly, boolean positiveOnly, boolean preserveNegativeZero) {
        EInteger bigexp;
        if (str == null || str.length() == 0) {
            return null;
        }
        int offset = 0;
        boolean negative = false;
        if (str.charAt(0) == '-' && !positiveOnly) {
            negative = true;
            ++offset;
        }
        int mantInt = 0;
        FastInteger2 mant = null;
        int mantBuffer = 0;
        int mantBufferMult = 1;
        int expBuffer = 0;
        int expBufferMult = 1;
        boolean haveDecimalPoint = false;
        boolean haveDigits = false;
        boolean haveDigitsAfterDecimal = false;
        boolean haveExponent = false;
        int newScaleInt = 0;
        FastInteger2 newScale = null;
        int i = offset;
        if (i < str.length() && str.charAt(i) == '0') {
            haveDigits = true;
            if (++i == str.length()) {
                if (!preserveNegativeZero || !negative) return CBORObject.FromObject(0);
                return CBORObject.FromObject(EDecimal.NegativeZero);
            }
            if (integersOnly) return null;
            if (str.charAt(i) == '.') {
                haveDecimalPoint = true;
                ++i;
            } else {
                if (str.charAt(i) != 'E' && str.charAt(i) != 'e') return null;
                haveExponent = true;
            }
        }
        while (i < str.length()) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                int thisdigit = str.charAt(i) - 48;
                if (mantInt > 0xCCCCCCB) {
                    if (mant == null) {
                        mant = new FastInteger2(mantInt);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else if (mantBufferMult >= 1000000000) {
                        mant.Multiply(mantBufferMult).AddInt(mantBuffer);
                        mantBuffer = thisdigit;
                        mantBufferMult = 10;
                    } else {
                        mantBufferMult *= 10;
                        mantBuffer = (mantBuffer << 3) + (mantBuffer << 1);
                        mantBuffer += thisdigit;
                    }
                } else {
                    mantInt *= 10;
                    mantInt += thisdigit;
                }
                haveDigits = true;
                if (haveDecimalPoint) {
                    haveDigitsAfterDecimal = true;
                    if (newScaleInt == Integer.MIN_VALUE) {
                        newScale = newScale == null ? new FastInteger2(newScaleInt) : newScale;
                        newScale.AddInt(-1);
                    } else {
                        --newScaleInt;
                    }
                }
            } else if (!integersOnly && str.charAt(i) == '.') {
                if (!haveDigits) {
                    return null;
                }
                if (haveDecimalPoint) {
                    return null;
                }
                haveDecimalPoint = true;
            } else {
                if (integersOnly || str.charAt(i) != 'E' && str.charAt(i) != 'e') return null;
                haveExponent = true;
                ++i;
                break;
            }
            ++i;
        }
        if (!haveDigits || haveDecimalPoint && !haveDigitsAfterDecimal) {
            return null;
        }
        if (mant != null && (mantBufferMult != 1 || mantBuffer != 0)) {
            mant.Multiply(mantBufferMult).AddInt(mantBuffer);
        }
        if (haveExponent) {
            FastInteger2 exp = null;
            int expInt = 0;
            offset = 1;
            haveDigits = false;
            if (i == str.length()) {
                return null;
            }
            if (str.charAt(i) == '+' || str.charAt(i) == '-') {
                if (str.charAt(i) == '-') {
                    offset = -1;
                }
                ++i;
            }
            while (i < str.length()) {
                if (str.charAt(i) < '0' || str.charAt(i) > '9') return null;
                haveDigits = true;
                int thisdigit = str.charAt(i) - 48;
                if (expInt > 0xCCCCCCB) {
                    if (exp == null) {
                        exp = new FastInteger2(expInt);
                        expBuffer = thisdigit;
                        expBufferMult = 10;
                    } else if (expBufferMult >= 1000000000) {
                        exp.Multiply(expBufferMult).AddInt(expBuffer);
                        expBuffer = thisdigit;
                        expBufferMult = 10;
                    } else {
                        expBufferMult = (expBufferMult << 3) + (expBufferMult << 1);
                        expBuffer = (expBuffer << 3) + (expBuffer << 1);
                        expBuffer += thisdigit;
                    }
                } else {
                    expInt *= 10;
                    expInt += thisdigit;
                }
                ++i;
            }
            if (!haveDigits) {
                return null;
            }
            if (exp != null && (expBufferMult != 1 || expBuffer != 0)) {
                exp.Multiply(expBufferMult).AddInt(expBuffer);
            }
            if (offset >= 0 && newScaleInt == 0 && newScale == null && exp == null) {
                newScaleInt = expInt;
            } else if (exp == null) {
                FastInteger2 fastInteger2 = newScale = newScale == null ? new FastInteger2(newScaleInt) : newScale;
                if (offset < 0) {
                    newScale.SubtractInt(expInt);
                } else if (expInt != 0) {
                    newScale.AddInt(expInt);
                }
            } else {
                FastInteger2 fastInteger2 = newScale = newScale == null ? new FastInteger2(newScaleInt) : newScale;
                if (offset < 0) {
                    newScale.Subtract(exp);
                } else {
                    newScale.Add(exp);
                }
            }
        }
        if (i != str.length()) {
            return null;
        }
        if (newScale == null && newScaleInt == 0 || newScale != null && newScale.signum() == 0) {
            if (mant != null && mant.CanFitInInt32()) {
                mantInt = mant.AsInt32();
                mant = null;
            }
            if (mant == null) {
                if (!negative) return CBORObject.FromObject(mantInt);
                mantInt = -mantInt;
                if (!preserveNegativeZero || mantInt != 0) return CBORObject.FromObject(mantInt);
                return CBORObject.FromObject(EDecimal.NegativeZero);
            }
            EInteger bigmant2 = mant.AsBigInteger();
            if (!negative) return CBORObject.FromObject(bigmant2);
            bigmant2 = bigmant2.Negate();
            return CBORObject.FromObject(bigmant2);
        }
        EInteger bigmant = mant == null ? EInteger.FromInt32(mantInt) : mant.AsBigInteger();
        EInteger eInteger = bigexp = newScale == null ? EInteger.FromInt32(newScaleInt) : newScale.AsBigInteger();
        if (negative) {
            bigmant = bigmant.Negate();
        }
        EDecimal edec = EDecimal.Create(bigmant, bigexp);
        if (!negative || !preserveNegativeZero || !bigmant.isZero()) return CBORObject.FromObject(edec);
        EDecimal negzero = EDecimal.NegativeZero;
        negzero = negzero.Quantize(bigexp, null);
        edec = negzero.Subtract(edec);
        return CBORObject.FromObject(edec);
    }
}

