/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.californium.elements.util.LeastRecentlyUsedCache;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.ConnectionListener;
import org.eclipse.californium.scandium.dtls.ClientSessionCache;
import org.eclipse.californium.scandium.dtls.CloseSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.Connection;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.ConnectionIdGenerator;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.ResumptionSupportingConnectionStore;
import org.eclipse.californium.scandium.dtls.SessionCache;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.eclipse.californium.scandium.dtls.SingleNodeConnectionIdGenerator;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryConnectionStore
implements ResumptionSupportingConnectionStore,
CloseSupportingConnectionStore {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryConnectionStore.class);
    private static final int DEFAULT_SMALL_EXTRA_CID_LENGTH = 2;
    private static final int DEFAULT_LARGE_EXTRA_CID_LENGTH = 3;
    private static final int DEFAULT_CACHE_SIZE = 150000;
    private static final long DEFAULT_EXPIRATION_THRESHOLD = 129600L;
    private final SessionCache sessionCache;
    protected final LeastRecentlyUsedCache<ConnectionId, Connection> connections;
    protected final ConcurrentMap<InetSocketAddress, Connection> connectionsByAddress;
    protected final ConcurrentMap<SessionId, Connection> connectionsByEstablishedSession;
    private ConnectionListener connectionListener;
    private ConnectionIdGenerator connectionIdGenerator;
    protected String tag = "";

    public InMemoryConnectionStore() {
        this(150000, 129600L, null);
    }

    public InMemoryConnectionStore(SessionCache sessionCache) {
        this(150000, 129600L, sessionCache);
    }

    public InMemoryConnectionStore(int capacity, long threshold) {
        this(capacity, threshold, null);
    }

    public InMemoryConnectionStore(int capacity, long threshold, SessionCache sessionCache) {
        this.connections = new LeastRecentlyUsedCache(capacity, threshold);
        this.connections.setEvictingOnReadAccess(false);
        this.connections.setUpdatingOnReadAccess(false);
        this.connectionsByEstablishedSession = new ConcurrentHashMap<SessionId, Connection>();
        this.connectionsByAddress = new ConcurrentHashMap<InetSocketAddress, Connection>();
        this.sessionCache = sessionCache;
        this.connections.addEvictionListener(new LeastRecentlyUsedCache.EvictionListener<Connection>(){

            @Override
            public void onEviction(final Connection staleConnection) {
                Runnable remove = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Handshaker handshaker = staleConnection.getOngoingHandshake();
                        if (handshaker != null) {
                            handshaker.handshakeFailed(new RuntimeException("Evicted!"));
                        }
                        InMemoryConnectionStore inMemoryConnectionStore = InMemoryConnectionStore.this;
                        synchronized (inMemoryConnectionStore) {
                            InMemoryConnectionStore.this.removeFromAddressConnections(staleConnection);
                            InMemoryConnectionStore.this.removeFromEstablishedSessions(staleConnection);
                            ConnectionListener listener = InMemoryConnectionStore.this.connectionListener;
                            if (listener != null) {
                                listener.onConnectionRemoved(staleConnection);
                            }
                        }
                    }
                };
                if (staleConnection.isExecuting()) {
                    staleConnection.getExecutor().execute(remove);
                } else {
                    remove.run();
                }
            }
        });
        LOG.info("Created new InMemoryConnectionStore [capacity: {}, connection expiration threshold: {}s]", (Object)capacity, (Object)threshold);
    }

    public synchronized InMemoryConnectionStore setTag(String tag) {
        this.tag = StringUtil.normalizeLoggingTag(tag);
        return this;
    }

    private ConnectionId newConnectionId() {
        for (int i = 0; i < 10; ++i) {
            ConnectionId cid = this.connectionIdGenerator.createConnectionId();
            if (this.connections.get(cid) != null) continue;
            return cid;
        }
        return null;
    }

    @Override
    public void setConnectionListener(ConnectionListener listener) {
        this.connectionListener = listener;
    }

    @Override
    public void attach(ConnectionIdGenerator connectionIdGenerator) {
        int bits;
        int cidLength;
        if (this.connectionIdGenerator != null) {
            throw new IllegalStateException("Connection id generator already attached!");
        }
        this.connectionIdGenerator = connectionIdGenerator == null || !connectionIdGenerator.useConnectionId() ? new SingleNodeConnectionIdGenerator(cidLength += (cidLength = ((bits = 32 - Integer.numberOfLeadingZeros(this.connections.getCapacity())) + 7) / 8) < 3 ? 2 : 3) : connectionIdGenerator;
        if (this.sessionCache instanceof ClientSessionCache) {
            ClientSessionCache clientCache = (ClientSessionCache)this.sessionCache;
            LOG.debug("resume client sessions {}", (Object)clientCache);
            for (InetSocketAddress peer : clientCache) {
                SessionTicket ticket = clientCache.getSessionTicket(peer);
                SessionId id = clientCache.getSessionIdentity(peer);
                if (ticket == null || id == null) continue;
                Connection connection = new Connection(ticket, id, peer);
                ConnectionId connectionId = this.newConnectionId();
                if (connectionId != null) {
                    connection.setConnectionId(connectionId);
                    this.connections.put(connectionId, connection);
                    this.connectionsByAddress.put(peer, connection);
                    LOG.debug("{}resume {} {}", this.tag, peer, id);
                    continue;
                }
                LOG.info("{}drop session {} {}, could not allocated cid!", this.tag, peer, id);
            }
        }
    }

    @Override
    public synchronized boolean put(Connection connection) {
        if (connection != null) {
            if (!connection.isExecuting()) {
                throw new IllegalStateException("Connection is not executing!");
            }
            ConnectionId connectionId = connection.getConnectionId();
            if (connectionId == null) {
                if (this.connectionIdGenerator == null) {
                    throw new IllegalStateException("Connection id generator must be attached before!");
                }
                connectionId = this.newConnectionId();
                if (connectionId == null) {
                    throw new IllegalStateException("Connection ids exhausted!");
                }
                connection.setConnectionId(connectionId);
            } else {
                if (connectionId.isEmpty()) {
                    throw new IllegalStateException("Connection must have a none empty connection id!");
                }
                if (this.connections.get(connectionId) != null) {
                    throw new IllegalStateException("Connection id already used! " + connectionId);
                }
            }
            if (this.connections.put(connectionId, connection)) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("{}connection: add {} (size {})", this.tag, connection, this.connections.size(), new Throwable("connection added!"));
                } else {
                    LOG.debug("{}connection: add {} (size {})", this.tag, connectionId, this.connections.size());
                }
                this.addToAddressConnections(connection);
                DTLSSession session = connection.getEstablishedSession();
                if (session != null) {
                    this.putEstablishedSession(session, connection);
                }
                return true;
            }
            LOG.warn("{}connection store is full! {} max. entries.", (Object)this.tag, (Object)this.connections.getCapacity());
            return false;
        }
        return false;
    }

    @Override
    public synchronized boolean update(Connection connection, InetSocketAddress newPeerAddress) {
        if (connection == null) {
            return false;
        }
        if (this.connections.update(connection.getConnectionId())) {
            if (newPeerAddress == null) {
                LOG.debug("{}connection: {} updated usage!", (Object)this.tag, (Object)connection.getConnectionId());
            } else if (!connection.equalsPeerAddress(newPeerAddress)) {
                InetSocketAddress oldPeerAddress = connection.getPeerAddress();
                LOG.debug("{}connection: {} updated, address changed from {} to {}!", this.tag, connection.getConnectionId(), oldPeerAddress, newPeerAddress);
                if (oldPeerAddress != null) {
                    this.connectionsByAddress.remove(oldPeerAddress, connection);
                    connection.updatePeerAddress(null);
                }
                connection.updatePeerAddress(newPeerAddress);
                this.addToAddressConnections(connection);
            }
            return true;
        }
        LOG.debug("{}connection: {} - {} update failed!", this.tag, connection.getConnectionId(), newPeerAddress);
        return false;
    }

    @Override
    public synchronized boolean removeFromAddress(Connection connection) {
        InetSocketAddress peerAddress;
        if (connection != null && (peerAddress = connection.getPeerAddress()) != null) {
            LOG.debug("{}connection: {} removed from address {}!", this.tag, connection.getConnectionId(), peerAddress);
            this.connectionsByAddress.remove(peerAddress, connection);
            connection.updatePeerAddress(null);
            return true;
        }
        return false;
    }

    @Override
    public synchronized void putEstablishedSession(DTLSSession session, Connection connection) {
        SessionId sessionId;
        ConnectionListener listener = this.connectionListener;
        if (listener != null) {
            listener.onConnectionEstablished(connection);
        }
        if (!(sessionId = session.getSessionIdentifier()).isEmpty()) {
            Connection previous;
            if (this.sessionCache != null) {
                this.sessionCache.put(session);
            }
            if ((previous = this.connectionsByEstablishedSession.put(sessionId, connection)) != null && previous != connection) {
                Runnable removePreviousConnection = new Runnable(){

                    @Override
                    public void run() {
                        InMemoryConnectionStore.this.remove(previous, false);
                    }
                };
                if (previous.isExecuting()) {
                    previous.getExecutor().execute(removePreviousConnection);
                } else {
                    removePreviousConnection.run();
                }
            }
        }
    }

    @Override
    public synchronized void removeFromEstablishedSessions(DTLSSession session, Connection connection) {
        SessionId sessionId = session.getSessionIdentifier();
        if (!sessionId.isEmpty()) {
            this.connectionsByEstablishedSession.remove(sessionId, connection);
        }
    }

    @Override
    public synchronized Connection find(SessionId id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        Connection conFromLocalCache = this.findLocally(id);
        if (this.sessionCache == null) {
            return conFromLocalCache;
        }
        SessionTicket ticket = this.sessionCache.get(id);
        if (ticket == null) {
            if (conFromLocalCache != null) {
                this.remove(conFromLocalCache, false);
            }
            return null;
        }
        if (conFromLocalCache == null) {
            return new Connection(ticket, id, null);
        }
        return conFromLocalCache;
    }

    private synchronized Connection findLocally(SessionId id) {
        Connection connection = (Connection)this.connectionsByEstablishedSession.get(id);
        if (connection != null) {
            DTLSSession establishedSession = connection.getEstablishedSession();
            if (establishedSession != null) {
                if (!establishedSession.getSessionIdentifier().equals(id)) {
                    LOG.warn("{}connection {} changed session {}!={}!", this.tag, connection.getConnectionId(), id, establishedSession.getSessionIdentifier());
                }
            } else {
                LOG.warn("{}connection {} lost session {}!", this.tag, connection.getConnectionId(), id);
            }
            this.connections.update(connection.getConnectionId());
        }
        return connection;
    }

    @Override
    public synchronized void markAllAsResumptionRequired() {
        for (Connection connection : this.connections.values()) {
            if (connection.getPeerAddress() == null || connection.isResumptionRequired()) continue;
            connection.setResumptionRequired(true);
            LOG.debug("{}connection: mark for resumption {}!", (Object)this.tag, (Object)connection);
        }
    }

    @Override
    public synchronized int remainingCapacity() {
        int remaining = this.connections.remainingCapacity();
        LOG.debug("{}connection: size {}, remaining {}!", this.tag, this.connections.size(), remaining);
        return remaining;
    }

    @Override
    public synchronized Connection get(InetSocketAddress peerAddress) {
        Connection connection = (Connection)this.connectionsByAddress.get(peerAddress);
        if (connection == null) {
            LOG.debug("{}connection: missing connection for {}!", (Object)this.tag, (Object)peerAddress);
        } else {
            InetSocketAddress address = connection.getPeerAddress();
            if (address == null) {
                LOG.warn("{}connection {} lost ip-address {}!", this.tag, connection.getConnectionId(), peerAddress);
            } else if (!address.equals(peerAddress)) {
                LOG.warn("{}connection {} changed ip-address {}!={}!", this.tag, connection.getConnectionId(), peerAddress, address);
            }
        }
        return connection;
    }

    @Override
    public synchronized Connection get(ConnectionId cid) {
        Connection connection = this.connections.get(cid);
        if (connection == null) {
            LOG.debug("{}connection: missing connection for {}!", (Object)this.tag, (Object)cid);
        } else {
            ConnectionId connectionId = connection.getConnectionId();
            if (connectionId == null) {
                LOG.warn("{}connection lost cid {}!", (Object)this.tag, (Object)cid);
            } else if (!connectionId.equals(cid)) {
                LOG.warn("{}connection changed cid {}!={}!", this.tag, connectionId, cid);
            }
        }
        return connection;
    }

    @Override
    public boolean remove(Connection connection) {
        return this.remove(connection, true);
    }

    @Override
    public synchronized boolean remove(Connection connection, boolean removeFromSessionCache) {
        boolean removed;
        boolean bl = removed = this.connections.remove(connection.getConnectionId(), connection) == connection;
        if (removed) {
            ConnectionListener listener;
            List<Runnable> pendings = connection.getExecutor().shutdownNow();
            if (LOG.isTraceEnabled()) {
                LOG.trace("{}connection: remove {} (size {}, left jobs: {})", this.tag, connection, this.connections.size(), pendings.size(), new Throwable("connection removed!"));
            } else if (pendings.isEmpty()) {
                LOG.debug("{}connection: remove {} (size {})", this.tag, connection, this.connections.size());
            } else {
                LOG.debug("{}connection: remove {} (size {}, left jobs: {})", this.tag, connection, this.connections.size(), pendings.size());
            }
            this.removeFromEstablishedSessions(connection);
            this.removeFromAddressConnections(connection);
            if (removeFromSessionCache) {
                this.removeSessionFromCache(connection);
            }
            if ((listener = this.connectionListener) != null) {
                listener.onConnectionRemoved(connection);
            }
        }
        return removed;
    }

    private void removeFromEstablishedSessions(Connection connection) {
        DTLSSession establishedSession = connection.getEstablishedSession();
        if (establishedSession != null) {
            SessionId sessionId = establishedSession.getSessionIdentifier();
            this.connectionsByEstablishedSession.remove(sessionId, connection);
            SecretUtil.destroy(establishedSession);
        }
    }

    private void removeFromAddressConnections(Connection connection) {
        InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            this.connectionsByAddress.remove(peerAddress, connection);
            connection.updatePeerAddress(null);
        }
    }

    private synchronized void removeSessionFromCache(Connection connection) {
        DTLSSession establishedSession;
        if (this.sessionCache != null && (establishedSession = connection.getEstablishedSession()) != null) {
            SessionId sessionId = establishedSession.getSessionIdentifier();
            this.sessionCache.remove(sessionId);
        }
    }

    private void addToAddressConnections(Connection connection) {
        final InetSocketAddress peerAddress = connection.getPeerAddress();
        if (peerAddress != null) {
            final Connection previous = this.connectionsByAddress.put(peerAddress, connection);
            if (previous != null && previous != connection) {
                Runnable removeAddress = new Runnable(){

                    @Override
                    public void run() {
                        if (previous.equalsPeerAddress(peerAddress)) {
                            previous.updatePeerAddress(null);
                        }
                    }
                };
                LOG.debug("{}connection: {} - {} added! {} removed from address.", this.tag, connection.getConnectionId(), peerAddress, previous.getConnectionId());
                if (previous.isExecuting()) {
                    previous.getExecutor().execute(removeAddress);
                } else {
                    removeAddress.run();
                }
            } else {
                LOG.debug("{}connection: {} - {} added!", this.tag, connection.getConnectionId(), peerAddress);
            }
        } else {
            LOG.debug("{}connection: {} - missing address!", (Object)this.tag, (Object)connection.getConnectionId());
        }
    }

    @Override
    public final synchronized void clear() {
        for (Connection connection : this.connections.values()) {
            SerialExecutor executor = connection.getExecutor();
            if (executor == null) continue;
            executor.shutdownNow();
        }
        this.connections.clear();
        this.connectionsByEstablishedSession.clear();
        this.connectionsByAddress.clear();
    }

    @Override
    public final synchronized void stop(List<Runnable> pending) {
        for (Connection connection : this.connections.values()) {
            SerialExecutor executor = connection.getExecutor();
            if (executor == null) continue;
            executor.shutdownNow(pending);
        }
    }

    @Override
    public Iterator<Connection> iterator() {
        return this.connections.valuesIterator();
    }
}

