/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.SocketException;
import org.eclipse.californium.elements.UDPConnector;
import org.eclipse.californium.elements.util.NetworkInterfacesUtil;
import org.eclipse.californium.elements.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpMulticastConnector
extends UDPConnector {
    public static final Logger LOGGER = LoggerFactory.getLogger(UdpMulticastConnector.class);
    private InetAddress intfAddress;
    private InetAddress[] multicastGroups;

    public UdpMulticastConnector(InetAddress intfAddress, InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        super(localAddress);
        this.intfAddress = intfAddress;
        this.multicastGroups = multicastGroups;
    }

    public UdpMulticastConnector(InetSocketAddress localAddress, InetAddress ... multicastGroups) {
        this(null, localAddress, multicastGroups);
    }

    @Override
    public synchronized void start() throws IOException {
        if (this.running) {
            return;
        }
        InetAddress effectiveInterface = this.localAddr.getAddress();
        MulticastSocket socket = new MulticastSocket(this.localAddr);
        if (this.intfAddress != null && !this.intfAddress.isAnyLocalAddress()) {
            socket.setInterface(this.intfAddress);
            effectiveInterface = this.intfAddress;
        }
        for (InetAddress group : this.multicastGroups) {
            try {
                socket.joinGroup(group);
                LOGGER.info("joined group {}", (Object)StringUtil.toString(group));
            }
            catch (SocketException ex) {
                socket.close();
                if (group instanceof Inet4Address) {
                    if (effectiveInterface.isAnyLocalAddress() && !NetworkInterfacesUtil.isAnyIpv4() || effectiveInterface instanceof Inet6Address) {
                        throw new SocketException("IPv6 only interface doesn't support IPv4 multicast!");
                    }
                } else if (group instanceof Inet6Address && (effectiveInterface.isAnyLocalAddress() && !NetworkInterfacesUtil.isAnyIpv6() || effectiveInterface instanceof Inet4Address)) {
                    throw new SocketException("IPv4 only interface doesn't support IPv6 multicast!");
                }
                throw ex;
            }
        }
        this.init(socket);
    }
}

