/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.security.auth.DestroyFailedException;
import javax.security.auth.Destroyable;
import org.eclipse.californium.elements.util.Bytes;

public class SecretIvParameterSpec
implements AlgorithmParameterSpec,
Destroyable {
    private final byte[] iv;
    private boolean destroyed;

    public SecretIvParameterSpec(byte[] iv) {
        this(iv, 0, iv.length);
    }

    public SecretIvParameterSpec(byte[] iv, int offset, int length) {
        if (iv == null) {
            throw new NullPointerException("IV missing");
        }
        if (iv.length == 0) {
            throw new IllegalArgumentException("IV is empty");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("len is negative");
        }
        if (iv.length - offset < length) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        this.iv = Arrays.copyOfRange(iv, offset, offset + length);
    }

    public byte[] getIV() {
        if (this.destroyed) {
            throw new IllegalStateException("secret destroyed!");
        }
        return Arrays.copyOf(this.iv, this.iv.length);
    }

    public byte[] getIV(byte[] explicitNonce) {
        return this.getIV(explicitNonce, 0, explicitNonce.length);
    }

    public byte[] getIV(byte[] explicitNonce, int offset, int length) {
        if (this.destroyed) {
            throw new IllegalStateException("secret destroyed!");
        }
        if (explicitNonce == null) {
            throw new NullPointerException("explicit nonce missing");
        }
        if (explicitNonce.length == 0) {
            throw new IllegalArgumentException("IV key");
        }
        if (length < 0) {
            throw new ArrayIndexOutOfBoundsException("len is negative");
        }
        if (explicitNonce.length - offset < length) {
            throw new IllegalArgumentException("Invalid offset/length combination");
        }
        byte[] result = Arrays.copyOf(this.iv, this.iv.length + length);
        System.arraycopy(explicitNonce, offset, result, this.iv.length, length);
        return result;
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Bytes.clear(this.iv);
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

