/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.californium.elements.util.ClockUtil;
import org.eclipse.californium.elements.util.SerialExecutor;
import org.eclipse.californium.elements.util.StringUtil;
import org.eclipse.californium.scandium.dtls.ClientHello;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.Handshaker;
import org.eclipse.californium.scandium.dtls.SessionId;
import org.eclipse.californium.scandium.dtls.SessionListener;
import org.eclipse.californium.scandium.dtls.SessionTicket;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Connection {
    private static final Logger LOGGER = LoggerFactory.getLogger(Connection.class.getName());
    private final AtomicReference<Handshaker> ongoingHandshake = new AtomicReference();
    private final SessionListener sessionListener = new ConnectionSessionListener();
    private ClientHello startingClientHello;
    private long lastMessageNanos;
    private long lastPeerAddressNanos;
    private SerialExecutor serialExecutor;
    private InetSocketAddress peerAddress;
    private ConnectionId cid;
    private SessionTicket ticket;
    private SessionId sessionId;
    private volatile DTLSSession establishedSession;
    private volatile boolean resumptionRequired;

    public Connection(InetSocketAddress peerAddress, SerialExecutor serialExecutor) {
        if (peerAddress == null) {
            throw new NullPointerException("Peer address must not be null");
        }
        if (serialExecutor == null) {
            throw new NullPointerException("Serial executor must not be null");
        }
        long now = ClockUtil.nanoRealtime();
        this.sessionId = null;
        this.ticket = null;
        this.peerAddress = peerAddress;
        this.serialExecutor = serialExecutor;
        this.lastPeerAddressNanos = now;
        this.lastMessageNanos = now;
    }

    public Connection(SessionTicket sessionTicket, SessionId sessionId, InetSocketAddress peerAddress) {
        if (sessionTicket == null) {
            throw new NullPointerException("session ticket must not be null");
        }
        if (sessionId == null) {
            throw new NullPointerException("session identity must not be null");
        }
        this.ticket = sessionTicket;
        this.sessionId = sessionId;
        this.resumptionRequired = true;
        this.peerAddress = peerAddress;
        this.cid = null;
        this.serialExecutor = null;
    }

    public void setExecutor(SerialExecutor serialExecutor) {
        if (serialExecutor == null) {
            throw new NullPointerException("Serial executor must not be null1");
        }
        if (this.isExecuting()) {
            throw new IllegalStateException("Serial executor already available!");
        }
        this.serialExecutor = serialExecutor;
    }

    public SerialExecutor getExecutor() {
        return this.serialExecutor;
    }

    public boolean isExecuting() {
        return this.serialExecutor != null && !this.serialExecutor.isShutdown();
    }

    public final SessionListener getSessionListener() {
        return this.sessionListener;
    }

    public boolean isActive() {
        return this.establishedSession != null || this.ticket != null;
    }

    public SessionId getSessionIdentity() {
        return this.sessionId;
    }

    public SessionTicket getSessionTicket() {
        return this.ticket;
    }

    public boolean expectCid() {
        DTLSSession session = this.getSession();
        return session != null && session.getWriteConnectionId() != null;
    }

    public ConnectionId getConnectionId() {
        return this.cid;
    }

    public void setConnectionId(ConnectionId cid) {
        this.cid = cid;
    }

    public long getLastPeerAddressNanos() {
        return this.lastPeerAddressNanos;
    }

    public InetSocketAddress getPeerAddress() {
        return this.peerAddress;
    }

    public void updatePeerAddress(InetSocketAddress peerAddress) {
        if (!this.equalsPeerAddress(peerAddress)) {
            this.lastPeerAddressNanos = ClockUtil.nanoRealtime();
            this.peerAddress = peerAddress;
            if (this.establishedSession != null) {
                this.establishedSession.setPeer(peerAddress);
            } else if (peerAddress == null) {
                Handshaker pendingHandshaker = this.getOngoingHandshake();
                if (pendingHandshaker != null) {
                    pendingHandshaker.handshakeFailed(new IOException("address changed!"));
                }
            } else {
                throw new IllegalArgumentException("Address change without established sesson is not supported!");
            }
        }
    }

    public boolean equalsPeerAddress(InetSocketAddress peerAddress) {
        if (this.peerAddress == peerAddress) {
            return true;
        }
        if (this.peerAddress == null) {
            return false;
        }
        return this.peerAddress.equals(peerAddress);
    }

    public DTLSSession getEstablishedSession() {
        return this.establishedSession;
    }

    public boolean hasEstablishedSession() {
        return this.establishedSession != null;
    }

    public Handshaker getOngoingHandshake() {
        return this.ongoingHandshake.get();
    }

    public boolean hasOngoingHandshake() {
        return this.ongoingHandshake.get() != null;
    }

    public boolean isStartedByClientHello(ClientHello clientHello) {
        if (clientHello == null) {
            throw new NullPointerException("client hello must not be null!");
        }
        return this.startingClientHello != null && this.startingClientHello.getRandom().equals(clientHello.getRandom()) && this.startingClientHello.getMessageSeq() >= clientHello.getMessageSeq();
    }

    public void startByClientHello(ClientHello clientHello) {
        this.startingClientHello = clientHello;
    }

    public DTLSSession getSession(int readEpoch) {
        DTLSSession session = this.establishedSession;
        if (session != null && session.getReadEpoch() == readEpoch) {
            return session;
        }
        Handshaker handshaker = this.ongoingHandshake.get();
        if (handshaker != null && (session = handshaker.getSession()) != null && session.getReadEpoch() == readEpoch) {
            return session;
        }
        return null;
    }

    public DTLSSession getSession() {
        Handshaker handshaker;
        DTLSSession session = this.establishedSession;
        if (session == null && (handshaker = this.ongoingHandshake.get()) != null) {
            session = handshaker.getSession();
        }
        return session;
    }

    public void resetSession() {
        if (this.establishedSession == null && this.ticket == null) {
            throw new IllegalStateException("No session established nor ticket available!");
        }
        this.establishedSession = null;
        this.sessionId = null;
        this.ticket = null;
        this.resumptionRequired = false;
    }

    public boolean isResumptionRequired() {
        return this.resumptionRequired;
    }

    public boolean isAutoResumptionRequired(Long autoResumptionTimeoutMillis) {
        long expires;
        long now;
        if (!this.resumptionRequired && autoResumptionTimeoutMillis != null && this.establishedSession != null && (now = ClockUtil.nanoRealtime()) - (expires = this.lastMessageNanos + TimeUnit.MILLISECONDS.toNanos(autoResumptionTimeoutMillis)) > 0L) {
            this.setResumptionRequired(true);
        }
        return this.resumptionRequired;
    }

    public void refreshAutoResumptionTime() {
        this.lastMessageNanos = ClockUtil.nanoRealtime();
    }

    public void setResumptionRequired(boolean resumptionRequired) {
        this.resumptionRequired = resumptionRequired;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("dtls-con: ");
        if (this.cid != null) {
            builder.append(this.cid);
        }
        if (this.peerAddress != null) {
            SessionId id;
            builder.append(", ").append(this.peerAddress);
            if (this.getOngoingHandshake() != null) {
                builder.append(", ongoing handshake ");
                id = this.getOngoingHandshake().getSession().getSessionIdentifier();
                if (id != null && !id.isEmpty()) {
                    builder.append(StringUtil.byteArray2HexString(id.getBytes(), '\u0000', 6));
                }
            }
            if (this.isResumptionRequired()) {
                builder.append(", resumption required");
            } else if (this.hasEstablishedSession()) {
                builder.append(", session established ");
                id = this.getEstablishedSession().getSessionIdentifier();
                if (id != null && !id.isEmpty()) {
                    builder.append(StringUtil.byteArray2HexString(id.getBytes(), '\u0000', 6));
                }
            }
        }
        if (this.sessionId != null) {
            builder.append(", ").append(this.sessionId);
            builder.append(", ").append(this.ticket);
        }
        if (this.isExecuting()) {
            builder.append(", is alive");
        }
        return builder.toString();
    }

    private class ConnectionSessionListener
    implements SessionListener {
        private ConnectionSessionListener() {
        }

        @Override
        public void handshakeStarted(Handshaker handshaker) throws HandshakeException {
            Connection.this.ongoingHandshake.set(handshaker);
            LOGGER.debug("Handshake with [{}] has been started", (Object)handshaker.getPeerAddress());
        }

        @Override
        public void sessionEstablished(Handshaker handshaker, DTLSSession session) throws HandshakeException {
            Connection.this.establishedSession = session;
            LOGGER.debug("Session with [{}] has been established", (Object)session.getPeer());
        }

        @Override
        public void handshakeCompleted(Handshaker handshaker) {
            if (Connection.this.ongoingHandshake.compareAndSet(handshaker, null)) {
                LOGGER.debug("Handshake with [{}] has been completed", (Object)handshaker.getPeerAddress());
            }
        }

        @Override
        public void handshakeFailed(Handshaker handshaker, Throwable error) {
            if (Connection.this.ongoingHandshake.compareAndSet(handshaker, null)) {
                Connection.this.startingClientHello = null;
                LOGGER.debug("Handshake with [{}] has failed", (Object)handshaker.getPeerAddress());
            }
        }

        @Override
        public void handshakeFlightRetransmitted(Handshaker handshaker, int flight) {
        }
    }
}

