/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import org.eclipse.californium.elements.util.SslContextUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;

public class SslContextUtilCredentialsTest {
    public static final char[] KEY_STORE_PASSWORD = "endPass".toCharArray();
    public static final String KEY_STORE_PASSWORD_HEX = "656E6450617373";
    public static final String KEY_STORE_LOCATION = "classpath://certs/keyStore.jks";
    public static final char[] TRUST_STORE_PASSWORD = "rootPass".toCharArray();
    public static final String SERVER_P12_LOCATION = "classpath://certs/server.p12";
    public static final String SERVER_PEM_LOCATION = "classpath://certs/server.pem";
    public static final String PUBLIC_KEY_PEM_LOCATION = "classpath://certs/ec_public.pem";
    public static final String ALIAS_SERVER = "server";
    public static final String ALIAS_CLIENT = "client";
    public static final String ALIAS_MISSING = "missing";
    public static final String DN_SERVER = "C=CA, L=Ottawa, O=Eclipse IoT, OU=Californium, CN=cf-server";

    @Test
    public void testLoadCredentials() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getPrivateKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain().length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)credentials.getCertificateChain()[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = credentials.getCertificateChain()[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_SERVER));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadCredentialsNotFound() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_MISSING, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
    }

    @Test(expected=IOException.class)
    public void testLoadCredentialsNoFile() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials("classpath://certs/keyStore.jksno-file", ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadCredentialsNullUri() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials(null, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadCredentialsNoStorePassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, null, KEY_STORE_PASSWORD);
    }

    @Test(expected=NullPointerException.class)
    public void testLoadCredentialsNoKeyPassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, null);
    }

    @Test(expected=IOException.class)
    public void testLoadCredentialsWrongStorePassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD_HEX.toCharArray(), KEY_STORE_PASSWORD);
    }

    @Test(expected=GeneralSecurityException.class)
    public void testLoadCredentialsWrongKeyPassword() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD_HEX.toCharArray());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadCredentialsSingleParameterWithoutAlias() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCredentials("classpath://certs/keyStore.jks#656E6450617373#656E6450617373#");
    }

    @Test
    public void testLoadCredentialsSingleParameter() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials("classpath://certs/keyStore.jks#656E6450617373#656E6450617373#server");
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getPrivateKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain().length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)credentials.getCertificateChain()[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = credentials.getCertificateChain()[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_SERVER));
    }

    @Test
    public void testLoadCertificateChain() throws IOException, GeneralSecurityException {
        X509Certificate[] chain = SslContextUtil.loadCertificateChain(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD);
        Assert.assertThat((Object)chain, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)chain.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)chain[0].getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)chain[0].getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_SERVER));
    }

    @Test(expected=NullPointerException.class)
    public void testLoadCertificateChainMissingAlias() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCertificateChain(KEY_STORE_LOCATION, null, KEY_STORE_PASSWORD);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLoadCertificateChainEmptyAlias() throws IOException, GeneralSecurityException {
        SslContextUtil.loadCertificateChain(KEY_STORE_LOCATION, "", KEY_STORE_PASSWORD);
    }

    @Test
    public void testLoadKeyManager() throws IOException, GeneralSecurityException {
        KeyManager[] manager = SslContextUtil.loadKeyManager(KEY_STORE_LOCATION, null, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509KeyManager.class)));
    }

    @Test(expected=GeneralSecurityException.class)
    public void testLoadKeyManagerCertificateNotFound() throws IOException, GeneralSecurityException {
        SslContextUtil.loadKeyManager(KEY_STORE_LOCATION, ALIAS_MISSING, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
    }

    @Test
    public void testCreateKeyManager() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        KeyManager[] manager = SslContextUtil.createKeyManager("test", credentials.getPrivateKey(), credentials.getCertificateChain());
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509KeyManager.class)));
    }

    @Test(expected=NullPointerException.class)
    public void testCreateKeytManagerNullPrivateKey() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        SslContextUtil.createKeyManager("test", null, credentials.getCertificateChain());
    }

    @Test(expected=NullPointerException.class)
    public void testCreateKeytManagerNullCertChain() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        SslContextUtil.createKeyManager("test", credentials.getPrivateKey(), null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCreateKeyManagerEmptyCertChain() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(KEY_STORE_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        SslContextUtil.createKeyManager("test", credentials.getPrivateKey(), new X509Certificate[0]);
    }

    @Test
    public void testLoadP12Credentials() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(SERVER_P12_LOCATION, ALIAS_SERVER, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getPrivateKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain().length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)credentials.getCertificateChain()[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = credentials.getCertificateChain()[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_SERVER));
    }

    @Test
    public void testLoadP12KeyManager() throws IOException, GeneralSecurityException {
        KeyManager[] manager = SslContextUtil.loadKeyManager(SERVER_P12_LOCATION, null, KEY_STORE_PASSWORD, KEY_STORE_PASSWORD);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509KeyManager.class)));
    }

    @Test
    public void testLoadPemCredentials() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials(SERVER_PEM_LOCATION, null, null, null);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getPrivateKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getCertificateChain().length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)credentials.getCertificateChain()[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509Certificate.class)));
        X509Certificate x509 = credentials.getCertificateChain()[0];
        Assert.assertThat((Object)x509.getPublicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)x509.getSubjectDN().getName(), (Matcher)CoreMatchers.is((Object)DN_SERVER));
    }

    @Test
    public void testLoadPemKeyManager() throws IOException, GeneralSecurityException {
        KeyManager[] manager = SslContextUtil.loadKeyManager(SERVER_PEM_LOCATION, null, null, null);
        Assert.assertThat((Object)manager, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)manager.length, (Matcher)CoreMatchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
        Assert.assertThat((Object)manager[0], (Matcher)CoreMatchers.is((Matcher)Matchers.instanceOf(X509KeyManager.class)));
    }

    @Test
    public void testLoadPemPublicKey() throws IOException, GeneralSecurityException {
        PublicKey publicKey = SslContextUtil.loadPublicKey(PUBLIC_KEY_PEM_LOCATION, null, null);
        Assert.assertThat((Object)publicKey, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testLoadPemPrivateKey() throws IOException, GeneralSecurityException {
        PrivateKey privateKey = SslContextUtil.loadPrivateKey(SERVER_PEM_LOCATION, null, null, null);
        Assert.assertThat((Object)privateKey, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testLoadPemPrivateKeyV2() throws IOException, GeneralSecurityException {
        PrivateKey privateKey = SslContextUtil.loadPrivateKey("classpath://certs/ec_private.pem", null, null, null);
        Assert.assertThat((Object)privateKey, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }

    @Test
    public void testLoadPemCredentialsV2() throws IOException, GeneralSecurityException {
        SslContextUtil.Credentials credentials = SslContextUtil.loadCredentials("classpath://certs/ec_private.pem", null, null, null);
        Assert.assertThat((Object)credentials, (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getPrivateKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
        Assert.assertThat((Object)credentials.getPubicKey(), (Matcher)CoreMatchers.is((Matcher)IsNull.notNullValue()));
    }
}

