/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core.network;

import java.net.InetSocketAddress;
import org.eclipse.californium.core.coap.Token;
import org.eclipse.californium.elements.util.StringUtil;

public class KeyToken {
    private final int hash;
    private final Token token;
    private final Object peer;

    public KeyToken(Token token, Object peer) {
        this.token = token;
        this.peer = peer;
        int hash = token.hashCode();
        if (peer != null) {
            hash += peer.hashCode() * 31;
        }
        this.hash = hash;
    }

    public Token getToken() {
        return this.token;
    }

    public Object getPeer() {
        return this.peer;
    }

    public final int hashCode() {
        return this.hash;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyToken other = (KeyToken)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (!this.token.equals(other.token)) {
            return false;
        }
        if (this.peer == other.peer) {
            return true;
        }
        if (this.peer == null) {
            return false;
        }
        return this.peer.equals(other.peer);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("KeyToken[");
        if (this.peer != null) {
            String peerAsString = this.peer instanceof InetSocketAddress ? StringUtil.toString((InetSocketAddress)this.peer) : this.peer.toString();
            builder.append(peerAsString).append('-');
        }
        builder.append(this.token.getAsString()).append(']');
        return builder.toString();
    }
}

