/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.elements.util;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import org.eclipse.californium.elements.util.Asn1DerDecoder;
import org.eclipse.californium.elements.util.Base64;
import org.eclipse.californium.elements.util.DatagramReader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Asn1DerDecoderTest {
    private static final String DH_BASE64 = "MIIBpjCCARsGCSqGSIb3DQEDATCCAQwCgYEA/X9TgR11EilS30qcLuzk5/YRt1I870QAwx4/gLZRJmlFXUAiUftZPY1Y+r/F9bow9subVWzXgTuAHTRv8mZgt2uZUKWkn5/oBHsQIsJPu6nX/rfGG/g7V+fGqKYVDwT7g/bTxR7DAjVUE1oWkTL2dfOuK2HXKu/yIgMZndFIAccCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoCAgIAA4GEAAKBgH5J+o19W2ct7iGFz0/dLMaYLjCuw7TdaU2QtzZb5FmGj1TyglARYb9V3nKoqifSKlgnwFU8RBu61Sw5/gZYhAeap8kvPH7dwIrBNc4wbt5CMdicCZlSluOPrX6mYn9HzvuIaS0V8G11soSHikCCIp9gFeMLfI0AtbPOYDYD0jHA";
    private static final String EC_BASE64 = "MFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEx4ABEJuzneP12mmh/RLlE6lM58MIrngQtfOK/eguzwNuTEP0wrE3H0p9rg1fZywtwleyl7lYUcxa8mQPOi4mRA==";
    private static final String DSA_BASE64 = "MIIBtzCCASwGByqGSM44BAEwggEfAoGBAP1/U4EddRIpUt9KnC7s5Of2EbdSPO9EAMMeP4C2USZpRV1AIlH7WT2NWPq/xfW6MPbLm1Vs14E7gB00b/JmYLdrmVClpJ+f6AR7ECLCT7up1/63xhv4O1fnxqimFQ8E+4P208UewwI1VBNaFpEy9nXzrith1yrv8iIDGZ3RSAHHAhUAl2BQjxUjC8yykrmCouuEC/BYHPUCgYEA9+GghdabPd7LvKtcNrhXuXmUr7v6OuqC+VdMCz0HgmdRWVeOutRZT+ZxBxCBgLRJFnEj6EwoFhO3zwkyjMim4TwWeotUfI0o4KOuHiuzpnWRbqN/C/ohNWLx+2J6ASQ7zKTxvqhRkImog9/hWuWfBpKLZl6Ae1UlZAFMO/7PSSoDgYQAAoGAdp65TFSOhis6Ezu3Hq5LmKuu1eVDFkb1G/YuLOCYnkjG976B8G+W4TIVdM5yg7+Q0DU35mb2jrKHnRqnf5hRODnlp7kmUE2y1VBpgkx/9y+NYVMmfCqFqEn3c4DbWJvDcmvlKxG0okcSUdHcfxsF7grsyKB0RUTaXpwzdskHYo0=";
    private static final String RSA_BASE64 = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCNPpjuSuq6BQ3/YGWbVpmNa0q+/vURtkbwPJIocT/b8QqmqdebnQxvADv9UpwWSrEyPkzY8Mq9bJRzRokJ8KQKbf9DTVFQmRmzikIk/Jwcm4+ST2plfHxDnywT9EYPrnNf6TrL/6fZsN0x1NMtr5unnlTND66HGNp+YMjqFgfnWwIDAQAB";
    private static byte[] sequence;

    @BeforeClass
    public static void init() throws IOException {
        sequence = Base64.decode(RSA_BASE64);
    }

    @Test
    public void testSequenceEntityDecoder() throws NoSuchAlgorithmException {
        DatagramReader reader = new DatagramReader(sequence);
        byte[] sequenceEntity = Asn1DerDecoder.readSequenceEntity(reader);
        Assert.assertThat((Object)sequenceEntity, (Matcher)CoreMatchers.is((Object)sequence));
    }

    @Test
    public void testSequenceEntityDecoderProvideMoreData() throws NoSuchAlgorithmException {
        byte[] more = Arrays.copyOf(sequence, sequence.length * 2);
        DatagramReader reader = new DatagramReader(more);
        byte[] sequenceEntity = Asn1DerDecoder.readSequenceEntity(reader);
        Assert.assertThat((Object)sequenceEntity, (Matcher)CoreMatchers.is((Object)sequence));
    }

    @Test
    public void testKeyAlgorithmRsa() throws IOException {
        byte[] data = Base64.decode(RSA_BASE64);
        Assert.assertThat((Object)Asn1DerDecoder.readSubjectPublicKeyAlgorithm(data), (Matcher)CoreMatchers.is((Object)"RSA"));
    }

    @Test
    public void testKeyAlgorithmDsa() throws IOException {
        byte[] data = Base64.decode(DSA_BASE64);
        Assert.assertThat((Object)Asn1DerDecoder.readSubjectPublicKeyAlgorithm(data), (Matcher)CoreMatchers.is((Object)"DSA"));
    }

    @Test
    public void testKeyAlgorithmEc() throws IOException {
        byte[] data = Base64.decode(EC_BASE64);
        Assert.assertThat((Object)Asn1DerDecoder.readSubjectPublicKeyAlgorithm(data), (Matcher)CoreMatchers.is((Object)"EC"));
    }

    @Test
    public void testKeyAlgorithmDH() throws IOException {
        byte[] data = Base64.decode(DH_BASE64);
        Assert.assertThat((Object)Asn1DerDecoder.readSubjectPublicKeyAlgorithm(data), (Matcher)CoreMatchers.is((Object)"DH"));
    }

    @Test
    public void testEqualKeyAlgorithmSynonyms() throws NoSuchAlgorithmException {
        this.assertSynonym(true, "RSA", "RSA");
        this.assertSynonym(true, "DH", "DiffieHellman");
        this.assertSynonym(true, "DiffieHellman", "DiffieHellman");
        this.assertSynonym(true, "DiffieHellman", "DH");
        this.assertSynonym(false, "DH", "RSA");
        this.assertSynonym(false, "DSA", "DiffieHellman");
    }

    private void assertSynonym(boolean expected, String keyAlgorithm1, String keyAlgorithm2) {
        if (expected != Asn1DerDecoder.equalKeyAlgorithmSynonyms(keyAlgorithm1, keyAlgorithm2)) {
            if (expected) {
                Assert.fail((String)(keyAlgorithm1 + " should be a valid synonym for " + keyAlgorithm2));
            } else {
                Assert.fail((String)(keyAlgorithm1 + " should not be a valid synonym for " + keyAlgorithm2));
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testViolatesMinimumEntityLength() {
        byte[] data = new byte[]{48};
        DatagramReader reader = new DatagramReader(data);
        Asn1DerDecoder.readSequenceEntity(reader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoSequence() {
        byte[] data = new byte[]{49, 1, 1};
        DatagramReader reader = new DatagramReader(data);
        Asn1DerDecoder.readSequenceEntity(reader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSequenceExceedsSupportedLengthBytes() {
        byte[] data = new byte[]{48, -123, 1, 1};
        DatagramReader reader = new DatagramReader(data);
        Asn1DerDecoder.readSequenceEntity(reader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSequenceExceedsSupportedLength() {
        byte[] data = new byte[]{48, -125, 1, 1, 1};
        DatagramReader reader = new DatagramReader(data);
        Asn1DerDecoder.readSequenceEntity(reader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNoOid() {
        byte[] data = new byte[]{49, 1, 1};
        DatagramReader reader = new DatagramReader(data);
        Asn1DerDecoder.readOidValue(reader);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOidExceedsSupportedLength() {
        byte[] data = new byte[]{48, 99, 1};
        DatagramReader reader = new DatagramReader(data);
        Asn1DerDecoder.readOidValue(reader);
    }
}

