/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.util;

import org.eclipse.californium.elements.auth.PreSharedKeyIdentity;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.DTLSSession;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.pskstore.PskStore;
import org.eclipse.californium.scandium.util.ServerNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PskUtil.class.getName());
    private byte[] pskSecret;
    private PskPublicInformation pskIdentity;
    private PreSharedKeyIdentity pskPrincipal;

    public PskUtil(boolean sniEnabled, DTLSSession session, PskStore pskStore) throws HandshakeException {
        if (session == null) {
            throw new NullPointerException("Dtls session cannot be null");
        }
        if (pskStore == null) {
            throw new NullPointerException("psk store cannot be null");
        }
        ServerNames virtualHost = session.getServerNames();
        if (sniEnabled && virtualHost != null) {
            if (!session.isSniSupported()) {
                LOGGER.warn("client is configured to use SNI but server does not support it, PSK authentication is likely to fail");
            }
            String virtualHostName = session.getVirtualHost();
            this.pskIdentity = pskStore.getIdentity(session.getPeer(), virtualHost);
            if (this.pskIdentity == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No Identity found for peer [address: %s, virtual host: %s]", session.getPeer(), virtualHostName), alert);
            }
            this.pskSecret = pskStore.getKey(virtualHost, this.pskIdentity);
            if (this.pskSecret == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No pre-shared key found for [virtual host: %s, identity: %s]", virtualHostName, this.pskIdentity), alert);
            }
            this.pskPrincipal = new PreSharedKeyIdentity(virtualHostName, this.pskIdentity.getPublicInfoAsString());
        } else {
            this.pskIdentity = pskStore.getIdentity(session.getPeer());
            if (this.pskIdentity == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No Identity found for peer [address: %s]", session.getPeer()), alert);
            }
            this.pskSecret = pskStore.getKey(this.pskIdentity);
            if (this.pskSecret == null) {
                AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.HANDSHAKE_FAILURE, session.getPeer());
                throw new HandshakeException(String.format("No pre-shared key found for [identity: %s]", this.pskIdentity), alert);
            }
            this.pskPrincipal = sniEnabled ? new PreSharedKeyIdentity(null, this.pskIdentity.getPublicInfoAsString()) : new PreSharedKeyIdentity(this.pskIdentity.getPublicInfoAsString());
        }
    }

    public PreSharedKeyIdentity getPskPrincipal() {
        return this.pskPrincipal;
    }

    public PskPublicInformation getPskPublicIdentity() {
        return this.pskIdentity;
    }

    public byte[] getPreSharedKey() {
        return this.pskSecret;
    }
}

