/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.scandium.dtls.cipher;

import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;

public class ThreadLocalCipher {
    private final String transformation;
    private final GeneralSecurityException exception;
    private final ThreadLocal<Cipher> threadLocalCipher;

    public ThreadLocalCipher(String transformation) {
        GeneralSecurityException exception = null;
        String supportedTransformation = null;
        ThreadLocal<Cipher> threadLocalCipher = null;
        try {
            Cipher cipher = Cipher.getInstance(transformation);
            if (cipher != null) {
                supportedTransformation = transformation;
                threadLocalCipher = new ThreadLocal<Cipher>();
                threadLocalCipher.set(cipher);
            }
        }
        catch (GeneralSecurityException e) {
            exception = e;
        }
        this.threadLocalCipher = threadLocalCipher;
        this.transformation = supportedTransformation;
        this.exception = exception;
    }

    public Cipher current() {
        if (!this.isSupported()) {
            return null;
        }
        Cipher cipher = this.threadLocalCipher.get();
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(this.transformation);
                this.threadLocalCipher.set(cipher);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        return cipher;
    }

    public final boolean isSupported() {
        return this.transformation != null;
    }

    public final GeneralSecurityException getCause() {
        return this.exception;
    }
}

